/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.criteria.Criterion;
import de.justsoftware.onx.searchnew.business.criteria.FilterQueryCriteria;
import de.justsoftware.onx.searchnew.business.criteria.LocalParam;
import de.justsoftware.onx.searchnew.business.criteria.OrExpression;
import de.justsoftware.onx.searchnew.business.criteria.Restrictions;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.util.ClientUtils;

public class SolrQueryBuilder {
    public static final Function<String, String> ESCAPE_QUERY_CHARS = new NullPermeableFunction<String, String>(){

        @Override
        protected String applySafe(String input) {
            return ClientUtils.escapeQueryChars((String)input);
        }
    };
    protected static final String QUERYTYPE_JUCO_SEARCH = "jucoSearch";
    protected static final String QUERYTYPE_STANDARD = "standard";
    protected static final String QUERYTYPE_SUGGEST = "suggest";
    protected static final String QUERY_JUCO_PERSON_IDS_PARAM_NAME = "jucoPersonIds";
    protected static final String QUERY_JUCO_ROLES_PARAM_NAME = "jucoRoles";

    @Nonnull
    static String getFacetQueryWithExclusion(@Nonnull String field, @Nonnull String value, @Nullable String facetName, @Nullable List<String> exclusionFilter) {
        return SolrQueryBuilder.createLocalParams(facetName, exclusionFilter).append(field).append(":").append(value).toString();
    }

    @Nonnull
    static String getGenericFacetQueryWithExclusion(@Nonnull String query, @Nullable String facetName, @Nullable List<String> exclusionFilter) {
        return SolrQueryBuilder.createLocalParams(facetName, exclusionFilter).append(query).toString();
    }

    @Nonnull
    static String getFacetFieldWithExclusion(@Nonnull String field, @Nullable String facetName, @Nullable List<String> exclusionFilter) {
        return SolrQueryBuilder.createLocalParams(facetName, exclusionFilter).append(field).toString();
    }

    static void setFacetFieldSortByCount(@Nonnull SolrQuery query, @Nonnull String field) {
        query.set("f." + field + ".facet.sort", new String[]{"count"});
    }

    static void setFacetFieldLimit(@Nonnull SolrQuery query, @Nonnull String field, int limit) {
        query.set("f." + field + ".facet.limit", limit);
    }

    static void setFacetFieldMissing(@Nonnull SolrQuery query, @Nonnull String field, boolean includeMissing) {
        query.set("f." + field + ".facet.missing", includeMissing);
    }

    static void setFacetFieldContains(@Nonnull SolrQuery query, @Nonnull String field, @Nonnull String searchString) {
        query.set("f." + field + ".facet.contains", new String[]{searchString});
        query.set("f." + field + ".facet.contains.ignoreCase", true);
    }

    static void addFacetFields(@Nonnull SolrQuery query, String ... fieldNames) {
        if (fieldNames.length > 0) {
            query.addFacetField(fieldNames);
        }
    }

    static void addFacetFields(@Nonnull SolrQuery query, @Nonnull Iterable<String> fieldNames) {
        SolrQueryBuilder.addFacetFields(query, (String[])Iterables.toArray(fieldNames, String.class));
    }

    static void setUnlimitedFacet(@Nonnull SolrQuery query) {
        query.setFacet(true);
        query.setFacetLimit(-1);
        query.setFacetMinCount(1);
    }

    @Nonnull
    private static StringBuilder createLocalParams(@Nullable String facetName, @Nullable List<String> exclusionFilter) {
        StringBuilder result = new StringBuilder();
        if (!CollectionUtil.isEmpty(exclusionFilter) || facetName != null) {
            result.append("{");
            if (!CollectionUtil.isEmpty(exclusionFilter)) {
                result.append("!ex=").append(Joiner.on((char)',').skipNulls().join(exclusionFilter));
            }
            if (facetName != null) {
                result.append(" key=").append(facetName);
            }
            result.append("}");
        }
        return result;
    }

    public static void addJoinQuery(@Nonnull FilterQueryCriteria filterQueryCriteria, @Nonnull SearchField from, @Nonnull SearchField to) {
        filterQueryCriteria.addLocalParam(new LocalParam("join"));
        filterQueryCriteria.addLocalParam(new LocalParam("from", from.getFieldName()));
        filterQueryCriteria.addLocalParam(new LocalParam("to", to.getFieldName()));
    }

    @CheckForNull
    public static FilterQueryCriteria createFilterTypeFilterQuery(@Nullable Iterable<? extends FilterType> selectedFilter, @Nullable String filterExcludeName) {
        if (CollectionUtil.isEmpty(selectedFilter)) {
            return null;
        }
        FilterQueryCriteria fq = new FilterQueryCriteria();
        if (filterExcludeName != null) {
            fq.addLocalParam(new LocalParam("tag", filterExcludeName));
        }
        OrExpression or = Restrictions.or(new Criterion[0]);
        fq.add(or);
        for (FilterType filterType : selectedFilter) {
            or.add(Restrictions.eq("type", filterType.getType().name()));
        }
        return fq;
    }
}

