/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.searchnew.shared.model.AbstractSearchConfigurationProvider;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class ServerSearchConfigurationProvider
extends AbstractSearchConfigurationProvider {
    private final EntityConfigService _entityConfigService;
    private final ConfigService _configService;
    private final PersonRoleService _personRoleService;
    private final Settings _settings;

    @Autowired
    public ServerSearchConfigurationProvider(EntityConfigService entityConfigService, ConfigService configService, PersonRoleService personRoleService, Settings settings) {
        super(entityConfigService.getOrderedActivatedEntityTypes());
        this._entityConfigService = entityConfigService;
        this._configService = configService;
        this._personRoleService = personRoleService;
        this._settings = settings;
    }

    @Override
    public EntityDurationTimeOption getDurationTimeOption(EntityType entityType) {
        return this._entityConfigService.getDurationTimeOption(entityType);
    }

    @Override
    public boolean isShowEntityStatusSearchFilter(EntityType entityType) {
        return this._entityConfigService.showEntityStatusSearchFilter(entityType);
    }

    @Override
    public boolean isShowArchivedSearchFilter(EntityType entityType) {
        return this._entityConfigService.showArchiveSearchFilter(entityType);
    }

    @Override
    public ImmutableSetMultimap<Boolean, EntityStatusId> getEntityStatusByArchivedFlag(EntityType entityType) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.transformValues((ListMultimap)FluentIterable.from(this._entityConfigService.getAvailableEntityStatus(entityType)).index(Functions.forPredicate(EntityStatus.IS_ARCHIVED)), Identifiables.toId()));
    }

    @Override
    public boolean isShowTagSearchFilterForEntities(EntityType entityType) {
        return this._entityConfigService.tagsEnabled(entityType);
    }

    @Override
    public boolean isShowTagSearchFilterForDocuments() {
        return this._configService.isTagsForDocumentsEnabled();
    }

    @Override
    public boolean isShowPersonRoleFilter() {
        return !this._personRoleService.getVisibleRoleNames().isEmpty();
    }

    @Override
    public boolean isShowSearchContextFilter() {
        return this._settings.getSearchContextShown();
    }
}

