/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.SearchFieldUtil;
import de.justsoftware.onx.searchnew.shared.model.InvalidSearchFieldException;
import de.justsoftware.onx.searchnew.shared.server.model.SearchTermModel;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.util.ClientUtils;

public final class SearchTermParser {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("((\\S+:)?(\"[^\"]+\"|\\S+))");

    private SearchTermParser() {
    }

    @CheckForNull
    static Collection<SearchTermModel> parseSearchTerm(@Nullable String searchString, @Nonnull ImmutableSetMultimap<EntityType, DynamicAttributeConfig> searchableEntityDynAttributes) {
        return SearchTermParser.parseSearchTerm(searchString, true, searchableEntityDynAttributes);
    }

    @CheckForNull
    static Collection<SearchTermModel> parseSimpleSearchTerm(@Nullable String searchString, @Nonnull ImmutableSetMultimap<EntityType, DynamicAttributeConfig> searchableEntityDynAttributes) {
        return SearchTermParser.parseSearchTerm(searchString, false, searchableEntityDynAttributes);
    }

    @CheckForNull
    private static Collection<SearchTermModel> parseSearchTerm(@Nullable String searchString, boolean parseFields, @Nonnull ImmutableSetMultimap<EntityType, DynamicAttributeConfig> searchableEntityDynAttributes) {
        if (StringUtils.isBlank((String)searchString)) {
            return null;
        }
        HashSet<SearchTermModel> result = new HashSet<SearchTermModel>();
        Matcher matcher = WHITESPACE_PATTERN.matcher(searchString);
        while (matcher.find()) {
            SearchTermModel searchTerm;
            String plainSearchTerm = matcher.group().trim();
            if (plainSearchTerm.isEmpty() || (searchTerm = SearchTermParser.parseSingleSearchTerm(plainSearchTerm, parseFields, searchableEntityDynAttributes)) == null) continue;
            result.add(searchTerm);
        }
        return result;
    }

    private static SearchTermModel parseSingleSearchTerm(@Nonnull String searchString, boolean parseFields, @Nonnull ImmutableSetMultimap<EntityType, DynamicAttributeConfig> searchableEntityDynAttributes) {
        if (parseFields && searchString.contains(":")) {
            String[] searchStringSplitted = searchString.split(":");
            if (searchStringSplitted.length <= 1) {
                return new SearchTermModel(null, SearchTermParser.toLowerCaseWildcardAndEscapeQuery(searchString));
            }
            String strFieldname = SearchTermParser.convertFieldName(searchStringSplitted[0]);
            SearchField fieldName = SearchFieldUtil.getSearchFieldByName(strFieldname, searchableEntityDynAttributes);
            if (fieldName != null) {
                String searchTerm = searchStringSplitted[1];
                return new SearchTermModel(fieldName, SearchTermParser.toLowerCaseWildcardAndEscapeQuery(searchTerm));
            }
            throw new InvalidSearchFieldException(strFieldname);
        }
        return new SearchTermModel(null, SearchTermParser.toLowerCaseWildcardAndEscapeQuery(searchString));
    }

    private static String convertFieldName(String userFieldName) {
        if (userFieldName == null) {
            return null;
        }
        return userFieldName.trim();
    }

    private static String toLowerCaseWildcardAndEscapeQuery(@Nullable String searchString) {
        if (searchString == null) {
            return null;
        }
        if (searchString.contains("*")) {
            return ClientUtils.escapeQueryChars((String)searchString.toLowerCase()).replaceAll("\\\\\\*", "*");
        }
        return ClientUtils.escapeQueryChars((String)searchString.toLowerCase());
    }
}

