/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.attributes.ArithmeticOperationInput;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.NumberInput;
import de.justsoftware.onx.common.shared.model.attributes.PersonSuggestInput;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.model.attributes.TextAreaInput;
import de.justsoftware.onx.common.shared.model.attributes.TextInput;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusClientModel;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.searchnew.business.model.SubFilterSet;
import de.justsoftware.onx.searchnew.shared.model.DocumentFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.DriveFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.ModelBasedSearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.PersonModelSearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.PersonRoleSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.SearchContextFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.SimpleSearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.TagSubFilter;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;

public final class SearchResultFacetCountsExtractor {
    private SearchResultFacetCountsExtractor() {
    }

    @Nonnull
    public static ImmutableMap<SearchFacet, SearchFacetCounts> getFacetCounts(@Nonnull QueryResponse response, @Nonnull ImmutableSet<SearchFacet> availableSearchFacets, @Nullable Iterable<? extends SubFilter> additionalFilter, @Nonnull Optional<String> highlightingFacetString, @Nonnull FacetDataAccessor facetDataAccessor) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        ExtractFacetCountsVisitor visitor = new ExtractFacetCountsVisitor(response, facetDataAccessor, additionalFilter, highlightingFacetString);
        for (SearchFacet facet : availableSearchFacets) {
            SearchFacetCounts facetCount = facet.accept(visitor);
            if (facetCount == null) continue;
            result.put((Object)facet, (Object)facetCount);
        }
        return result.build();
    }

    @Nonnull
    public static SimpleSearchFacetCounts createSimpleSearchFacetCountsFor(@Nonnull QueryResponse response, @Nonnull String facetName, @Nonnull Iterable<String> selectedSubfilterValues, @Nonnull Optional<String> highlightingFacetSearchString) {
        LinkedHashMap facetCounts = Maps.newLinkedHashMap();
        facetCounts.putAll(SearchResultFacetCountsExtractor.extractFacetCountsFor(response, facetName, false));
        facetCounts.putAll(SearchResultFacetCountsExtractor.extractFacetCountsForSubfilter(response, facetName, selectedSubfilterValues));
        return new SimpleSearchFacetCounts((ImmutableMap<String, Long>)ImmutableMap.copyOf((Map)facetCounts), SearchResultFacetCountsExtractor.createFacetHighlightings(facetCounts, highlightingFacetSearchString), SearchFacetCounts.FacetSortType.COUNTS);
    }

    @Nonnull
    private static ImmutableMap<String, String> createFacetHighlightings(@Nonnull Map<String, Long> facetCounts, @Nonnull Optional<String> highlightingFacetSearchString) {
        if (!highlightingFacetSearchString.isPresent() || Strings.isNullOrEmpty((String)((String)highlightingFacetSearchString.get()))) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder highlightedFacetValues = ImmutableMap.builder();
        for (String facetValue : facetCounts.keySet()) {
            Matcher matcher = Pattern.compile("(" + Pattern.quote((String)highlightingFacetSearchString.get()) + ")", 66).matcher(facetValue);
            if (!matcher.find()) continue;
            highlightedFacetValues.put((Object)facetValue, (Object)matcher.replaceAll("[hl]" + matcher.group(1) + "[/hl]"));
        }
        return highlightedFacetValues.build();
    }

    @Nonnull
    private static Map<String, Long> extractFacetCountsForSubfilter(@Nonnull QueryResponse response, @Nonnull String facetName, @Nonnull Iterable<String> selectedSubfilterValues) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Map facetQuery = response.getFacetQuery();
        if (facetQuery == null) {
            return result;
        }
        for (String subfilterValue : selectedSubfilterValues) {
            Integer subfilterValueCount = (Integer)facetQuery.get(facetName + ":" + subfilterValue);
            if (subfilterValueCount == null) continue;
            result.put(subfilterValue, subfilterValueCount.longValue());
        }
        return result;
    }

    @Nonnull
    private static Map<String, Long> extractFacetCountsFor(@Nonnull QueryResponse response, @Nonnull String facetName, boolean includeEmptyValue) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        FacetField facet = response.getFacetField(facetName);
        if (facet == null) {
            return result;
        }
        List values = facet.getValues();
        if (values == null) {
            return result;
        }
        for (FacetField.Count count : values) {
            String facetValueName = count.getName();
            if (!StringUtils.isNotBlank((String)facetValueName) && !includeEmptyValue) continue;
            result.put(count.getName(), count.getCount());
        }
        return result;
    }

    @ParametersAreNonnullByDefault
    private static final class EntityDynamicAttributeFacetCountsExtractor
    implements Input.InputVisitor<SearchFacetCounts> {
        private static final int INCLUDE_ZERO_FACET_LIMIT = 5;
        private final SimpleSearchFacetCounts _counts;
        private final FacetDataAccessor _facetDataAccessor;

        private EntityDynamicAttributeFacetCountsExtractor(SimpleSearchFacetCounts counts, FacetDataAccessor facetDataAccessor) {
            this._counts = counts;
            this._facetDataAccessor = facetDataAccessor;
        }

        @Override
        public SearchFacetCounts visit(SelectionInput input) {
            boolean doReorder;
            ImmutableMap.Builder result = ImmutableMap.builder();
            boolean bl = doReorder = input.getValues().size() <= 5;
            if (doReorder) {
                for (String configuredValue : input.getValues()) {
                    result.put((Object)configuredValue, (Object)((Long)MoreObjects.firstNonNull((Object)((Long)this._counts.getFacetCounts().get((Object)configuredValue.toLowerCase())), (Object)0L)));
                }
            } else {
                HashMap<String, String> translation = new HashMap<String, String>();
                for (String configuredValue : input.getValues()) {
                    translation.put(configuredValue.toLowerCase(), configuredValue);
                }
                for (Map.Entry facetCount : this._counts.getFacetCounts().entrySet()) {
                    String lowerCaseKey = (String)facetCount.getKey();
                    String configuredValue = (String)MoreObjects.firstNonNull((Object)((String)translation.get(lowerCaseKey)), (Object)lowerCaseKey);
                    result.put((Object)configuredValue, (Object)((Long)facetCount.getValue()));
                }
            }
            return new SimpleSearchFacetCounts((ImmutableMap<String, Long>)result.build(), (ImmutableMap<String, String>)ImmutableMap.of(), doReorder ? SearchFacetCounts.FacetSortType.CUSTOM : this._counts.getSortType());
        }

        @Override
        public SearchFacetCounts visit(TextInput input) {
            return this._counts;
        }

        @Override
        public SearchFacetCounts visit(TextAreaInput input) {
            return this._counts;
        }

        @Override
        public SearchFacetCounts visit(NumberInput numberInput) {
            return this._counts;
        }

        @Override
        public SearchFacetCounts visit(ArithmeticOperationInput input) {
            return this._counts;
        }

        @Override
        public SearchFacetCounts visit(PersonSuggestInput suggestInput) {
            ImmutableSet personIds = FluentIterable.from((Iterable)this._counts.getFacetCounts().keySet()).transform(PersonId.PARSE).filter(Predicates.notNull()).toSet();
            ImmutableList.Builder result = ImmutableList.builder();
            ImmutableMap<PersonId, PersonTeaserModel> personTeaserByIds = personIds.isEmpty() ? ImmutableMap.of() : this._facetDataAccessor.getPersonTeaserByIds((Set<PersonId>)personIds);
            for (Map.Entry e : this._counts.getFacetCounts().entrySet()) {
                PersonTeaserModel personTeaserModel = (PersonTeaserModel)personTeaserByIds.get(PersonId.PARSE.apply((Object)((String)e.getKey())));
                if (personTeaserModel == null) continue;
                result.add(new ModelBasedSearchFacetCounts.SearchFacetCountEntry<PersonTeaserModel>(personTeaserModel, (Long)e.getValue()));
            }
            return new PersonModelSearchFacetCounts((ImmutableList<ModelBasedSearchFacetCounts.SearchFacetCountEntry<PersonTeaserModel>>)result.build());
        }
    }

    private static final class ExtractFacetCountsVisitor
    implements SearchFacet.SearchFacetVisitor<SearchFacetCounts> {
        private final QueryResponse _response;
        private final FacetDataAccessor _facetDataAccessor;
        private final SubFilterSet _subfilter;
        private final Optional<String> _highlightingFacetString;

        public ExtractFacetCountsVisitor(@Nonnull QueryResponse response, @Nonnull FacetDataAccessor facetDataAccessor, @Nullable Iterable<? extends SubFilter> subfilter, @Nonnull Optional<String> highlightingFacetString) {
            this._response = response;
            this._facetDataAccessor = facetDataAccessor;
            this._highlightingFacetString = highlightingFacetString;
            this._subfilter = new SubFilterSet((Iterable<? extends SubFilter>)(subfilter != null ? subfilter : ImmutableSet.of()));
        }

        @Override
        public SearchFacetCounts visitDateFuture(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitDatePast(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitDateAll(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitDocumentFileType(SearchFacet searchFacet) {
            if (CollectionUtil.isEmpty(this._response.getFacetFields())) {
                return null;
            }
            ImmutableSet<String> subfilterValues = this._subfilter.getMultiSelectValuesAsStrings(DocumentFileTypeSubFilter.class, Functions.toStringFunction());
            return SearchResultFacetCountsExtractor.createSimpleSearchFacetCountsFor(this._response, searchFacet.getFacetName(), subfilterValues, this._highlightingFacetString);
        }

        @Override
        public SearchFacetCounts visitModifyDateAll(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitModifyDateLastHour(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitModifyDateLast24Hours(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitModifyDateLastWeek(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitModifyDateLastMonth(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitModifyDateLastYear(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitArchiveAll(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitArchiveNonArchived(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitArchiveArchived(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitBlockAll(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitBlockNonBlocked(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitBlockBlocked(SearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @CheckForNull
        private SearchFacetCounts getSingleFacetCountFromFacetQuery(@Nonnull SearchFacet searchFacet) {
            if (CollectionUtil.isEmpty(this._response.getFacetQuery())) {
                return null;
            }
            return SimpleSearchFacetCounts.ofSingleCount(searchFacet, (Integer)this._response.getFacetQuery().get(searchFacet.getFacetName()), SearchFacetCounts.FacetSortType.CUSTOM);
        }

        @Override
        public SearchFacetCounts visitDynamicEntityAttribute(EntityDynamicAttributeSearchFacet searchFacet) {
            if (CollectionUtil.isEmpty(this._response.getFacetFields())) {
                return null;
            }
            Optional<DynamicAttributeConfig> optionalConfig = this._facetDataAccessor.getEntityDynamicAttributeConfig(searchFacet.getEntityType(), searchFacet.getDynamicAttributeId());
            if (optionalConfig.isPresent()) {
                DynamicAttributeConfig config = (DynamicAttributeConfig)optionalConfig.get();
                ImmutableSet<String> selectedSubfilterValues = this._subfilter.getMultiSelectValuesAsStrings(EntityDynamicAttributeSubFilter.class, EntityDynamicAttributeSubFilter.attributeIdEqualsPredicate(searchFacet.getDynamicAttributeId()), String::toLowerCase);
                SimpleSearchFacetCounts counts = SearchResultFacetCountsExtractor.createSimpleSearchFacetCountsFor(this._response, searchFacet.getFacetName(), selectedSubfilterValues, this._highlightingFacetString);
                return config.getInput().accept(new EntityDynamicAttributeFacetCountsExtractor(counts, this._facetDataAccessor));
            }
            return null;
        }

        @Override
        public SearchFacetCounts visitEntityStatus(EntityStatusSearchFacet searchFacet) {
            if (CollectionUtil.isEmpty(this._response.getFacetFields())) {
                return null;
            }
            SimpleSearchFacetCounts facetCounts = SearchResultFacetCountsExtractor.createSimpleSearchFacetCountsFor(this._response, searchFacet.getFacetName(), (Iterable<String>)ImmutableSet.of(), this._highlightingFacetString);
            ImmutableList.Builder result = ImmutableList.builder();
            for (EntityStatus status : this._facetDataAccessor.getEntityStatus(searchFacet.getEntityType())) {
                result.add(new ModelBasedSearchFacetCounts.SearchFacetCountEntry<EntityStatusClientModel>((EntityStatusClientModel)EntityStatusClientModel.TO_CLIENT_MODEL.apply((Object)status), (Long)MoreObjects.firstNonNull((Object)((Long)facetCounts.getFacetCounts().get((Object)String.valueOf(((EntityStatusId)status.getId()).getId()))), (Object)0L)));
            }
            return new EntityStatusSearchFacetCounts((ImmutableList<ModelBasedSearchFacetCounts.SearchFacetCountEntry<EntityStatusClientModel>>)result.build());
        }

        @Override
        public SearchFacetCounts visitEntityContext(SearchContextFacet.EntityBasedSearchContextFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitMySubscriptions(SearchContextFacet.MySubscriptionsSearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitMyContent(SearchContextFacet.MyContentSearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitMemberRole(SearchContextFacet.MemberRoleSearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitAdminRole(SearchContextFacet.AdminRoleSearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitAllContent(SearchContextFacet.AllContentSearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitPersonRole(SearchFacet searchFacet) {
            if (CollectionUtil.isEmpty(this._response.getFacetFields())) {
                return null;
            }
            ImmutableSet subfilterValues = this._subfilter.getMultiSelectValues(PersonRoleSubFilter.class);
            return SearchResultFacetCountsExtractor.createSimpleSearchFacetCountsFor(this._response, searchFacet.getFacetName(), subfilterValues, this._highlightingFacetString);
        }

        @Override
        public SearchFacetCounts visitTag(StaticSearchFacet searchFacet) {
            if (CollectionUtil.isEmpty(this._response.getFacetFields())) {
                return null;
            }
            ImmutableSet<String> subfilterValues = this._subfilter.getMultiSelectValuesAsStrings(TagSubFilter.class, String::toLowerCase);
            return SearchResultFacetCountsExtractor.createSimpleSearchFacetCountsFor(this._response, searchFacet.getFacetName(), subfilterValues, this._highlightingFacetString);
        }

        @Override
        public SearchFacetCounts visitDriveFileType(StaticSearchFacet searchFacet) {
            if (CollectionUtil.isEmpty(this._response.getFacetFields())) {
                return null;
            }
            ImmutableSet<String> subfilterValues = this._subfilter.getMultiSelectValuesAsStrings(DriveFileTypeSubFilter.class, String::toLowerCase);
            return SearchResultFacetCountsExtractor.createSimpleSearchFacetCountsFor(this._response, searchFacet.getFacetName(), subfilterValues, this._highlightingFacetString);
        }

        @Override
        public SearchFacetCounts visitFilterTypeSearchFacet(FilterTypeSearchFacet searchFacet) {
            return this.getSingleFacetCountFromFacetQuery(searchFacet);
        }

        @Override
        public SearchFacetCounts visitProfileAttribute(final ProfileAttributeSearchFacet searchFacet) {
            if (CollectionUtil.isEmpty(this._response.getFacetFields())) {
                return null;
            }
            ImmutableSet subfilterValues = this._subfilter.getMultiSelectValues(ProfileAttributeSubFilter.class, new NullIsFalsePredicate<ProfileAttributeSubFilter>(){

                @Override
                protected boolean applySafe(ProfileAttributeSubFilter input) {
                    return input.getName().equals(searchFacet.getName());
                }
            });
            return SearchResultFacetCountsExtractor.createSimpleSearchFacetCountsFor(this._response, searchFacet.getFacetName(), subfilterValues, this._highlightingFacetString);
        }

        @Override
        public SearchFacetCounts visitDriveDocumentType(SearchFacet searchFacet) {
            if (CollectionUtil.isEmpty(this._response.getFacetFields())) {
                return null;
            }
            ImmutableSet subfilterValues = FluentIterable.from((Object[])DriveDocumentSearchResultBadgeModel.DocumentType.values()).transform(Enum::name).toSet();
            return SearchResultFacetCountsExtractor.createSimpleSearchFacetCountsFor(this._response, searchFacet.getFacetName(), (Iterable<String>)subfilterValues, this._highlightingFacetString);
        }
    }

    @ParametersAreNonnullByDefault
    static interface FacetDataAccessor {
        @Nonnull
        public ImmutableMap<PersonId, PersonTeaserModel> getPersonTeaserByIds(Set<PersonId> var1);

        @Nonnull
        public ImmutableSet<EntityStatus> getEntityStatus(EntityType var1);

        @Nonnull
        public Optional<DynamicAttributeConfig> getEntityDynamicAttributeConfig(EntityType var1, DynamicAttributeId var2);
    }
}

