/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.searchnew.business.SearchService;
import de.justsoftware.onx.searchnew.business.impl.SolrRequestException;
import de.justsoftware.onx.searchnew.business.model.SearchIndexType;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class SearchIndexConsumer
extends AbstractKafkaConsumer<String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(SearchIndexConsumer.class);
    private static final String TOPIC_PREFIX = "just.search.index.";
    static final String SUBSCRIBERS_TOPIC = "just.search.index.subscribers";
    static final String PARENTS_TOPIC = "just.search.index.parents";
    static final String VISIBILITIES_TOPIC = "just.search.index.visibilities";
    private static final ImmutableSetMultimap<String, SearchIndexType> SEARCH_INDEX_TYPES_PER_TOPIC = ImmutableSetMultimap.of((Object)"just.search.index.subscribers", (Object)((Object)SearchIndexType.SUBSCRIBERS), (Object)"just.search.index.parents", (Object)((Object)SearchIndexType.PARENTS), (Object)"just.search.index.parents", (Object)((Object)SearchIndexType.PATH), (Object)"just.search.index.visibilities", (Object)((Object)SearchIndexType.VISIBILITIES));
    private final SearchService _searchService;

    @Autowired
    public SearchIndexConsumer(KafkaConfigurationProvider configProvider, TransactionHelper transactionHelper, SearchService searchService) {
        this(configProvider.stringConsumer("just.toro.SearchIndexConsumer"), transactionHelper, searchService);
    }

    @VisibleForTesting
    SearchIndexConsumer(@Nullable Consumer<String, String> consumer, TransactionHelper transactionHelper, SearchService searchService) {
        super(consumer, transactionHelper, SUBSCRIBERS_TOPIC, PARENTS_TOPIC, VISIBILITIES_TOPIC);
        this._searchService = searchService;
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        ImmutableSetMultimap.Builder indexTypesPerId = ImmutableSetMultimap.builder();
        for (ConsumerRecord record : records) {
            SearchableId id = SearchableId.parse((String)record.key());
            if (id == null) continue;
            indexTypesPerId.putAll((Object)id, (Iterable)SEARCH_INDEX_TYPES_PER_TOPIC.get((Object)record.topic()));
        }
        try {
            this._searchService.updateIndexOf((SetMultimap<SearchableId, SearchIndexType>)indexTypesPerId.build(), false);
        }
        catch (SolrRequestException e) {
            throw new ServiceException(e);
        }
    }
}

