/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import de.justsoftware.onx.common.shared.model.attributes.ArithmeticOperationInput;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.NumberInput;
import de.justsoftware.onx.common.shared.model.attributes.PersonSuggestInput;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.model.attributes.TextAreaInput;
import de.justsoftware.onx.common.shared.model.attributes.TextInput;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributeSearchType;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchContextFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacet;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchFacetContainsIsApplicableVisitor
implements SearchFacet.SearchFacetVisitor<Boolean> {
    private final FacetDataAccessor _facetDataAccessor;

    public SearchFacetContainsIsApplicableVisitor(FacetDataAccessor facetDataAccessor) {
        this._facetDataAccessor = facetDataAccessor;
    }

    @Override
    public Boolean visitDateFuture(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitDatePast(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitDateAll(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitDocumentFileType(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitModifyDateAll(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitModifyDateLastHour(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitModifyDateLast24Hours(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitModifyDateLastWeek(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitModifyDateLastMonth(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitModifyDateLastYear(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitDynamicEntityAttribute(EntityDynamicAttributeSearchFacet searchFacet) {
        Optional<DynamicAttributeConfig> config = this._facetDataAccessor.getEntityDynamicAttributeConfig(searchFacet.getEntityType(), searchFacet.getDynamicAttributeId());
        return (Boolean)config.transform((Function)new NullPermeableFunction<DynamicAttributeConfig, Boolean>(){

            @Override
            protected Boolean applySafe(DynamicAttributeConfig attributeConfig) {
                return attributeConfig.getInput().accept(new Input.InputVisitor<Boolean>(){

                    @Override
                    public Boolean visit(SelectionInput input) {
                        return Boolean.FALSE;
                    }

                    @Override
                    public Boolean visit(TextInput input) {
                        return Boolean.TRUE;
                    }

                    @Override
                    public Boolean visit(TextAreaInput input) {
                        return Boolean.TRUE;
                    }

                    @Override
                    public Boolean visit(PersonSuggestInput suggestInput) {
                        return Boolean.FALSE;
                    }

                    @Override
                    public Boolean visit(NumberInput numberInput) {
                        return Boolean.TRUE;
                    }

                    @Override
                    public Boolean visit(ArithmeticOperationInput input) {
                        return Boolean.TRUE;
                    }
                });
            }
        }).or((Object)Boolean.FALSE);
    }

    @Override
    public Boolean visitArchiveAll(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitArchiveNonArchived(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitArchiveArchived(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitBlockAll(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitBlockNonBlocked(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitBlockBlocked(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitEntityStatus(EntityStatusSearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitAllContent(SearchContextFacet.AllContentSearchFacet allContentSearchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitEntityContext(SearchContextFacet.EntityBasedSearchContextFacet entityBasedSearchContextFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitMyContent(SearchContextFacet.MyContentSearchFacet myContentSearchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitMySubscriptions(SearchContextFacet.MySubscriptionsSearchFacet mySubscriptionsSearchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitMemberRole(SearchContextFacet.MemberRoleSearchFacet memberRoleSearchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitAdminRole(SearchContextFacet.AdminRoleSearchFacet adminRoleSearchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitPersonRole(SearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitTag(StaticSearchFacet staticSearchFacet) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitDriveFileType(StaticSearchFacet staticSearchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitFilterTypeSearchFacet(FilterTypeSearchFacet searchFacet) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitProfileAttribute(ProfileAttributeSearchFacet searchFacet) {
        ProfileAttributeConfiguration config = (ProfileAttributeConfiguration)this._facetDataAccessor.getProfileAttributeConfig(searchFacet.getName()).orNull();
        if (config == null) {
            return Boolean.FALSE;
        }
        boolean searchFacetContainsIsApplicable = this.isSearchFacetContainsApplicableForProfileAttribute(config);
        return searchFacetContainsIsApplicable;
    }

    @Override
    public Boolean visitDriveDocumentType(SearchFacet searchFacet) {
        return Boolean.TRUE;
    }

    private boolean isSearchFacetContainsApplicableForProfileAttribute(ProfileAttributeConfiguration config) {
        switch (config.getType()) {
            case TEXT: 
            case TEXTAREA: 
            case TEXT_PHONE: {
                return ProfileAttributeSearchType.isFacetable(config);
            }
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    static interface FacetDataAccessor {
        @Nonnull
        public Optional<DynamicAttributeConfig> getEntityDynamicAttributeConfig(EntityType var1, DynamicAttributeId var2);

        @Nonnull
        public Optional<ProfileAttributeConfiguration> getProfileAttributeConfig(String var1);
    }
}

