/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.PersonType;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.searchnew.business.AdditionalData;
import de.justsoftware.onx.searchnew.business.AdditionalSuggestData;
import de.justsoftware.onx.searchnew.business.PersonSearchHandler;
import de.justsoftware.onx.searchnew.business.impl.AbstractSearchHandler;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import de.justsoftware.onx.searchnew.shared.model.PersonSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.PersonSearchResultEntityMemberInformation;
import de.justsoftware.onx.searchnew.shared.model.PersonSuggest;
import de.justsoftware.onx.searchnew.shared.model.SearchContextModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonSearchHandlerImpl
extends AbstractSearchHandler<PersonId, PersonType>
implements PersonSearchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PersonSearchHandlerImpl.class);
    private static final String DELIMETER = ", ";
    @Autowired
    private EntityService _entityService;
    @Autowired
    private PersonService _personService;
    @Autowired
    private PersonRoleService _personRoleService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private EntityMemberService _entityMemberService;

    @Override
    protected PersonId createId(String stringId) {
        return new PersonId(CompoundId.parseLongId(stringId));
    }

    @Override
    public ImmutableMap<CompoundId, PersonSearchResultBadgeModel> createSearchResultBadgeModel(Iterable<? extends CommonSearchResultModel> searchResultModel, SearchContextModel searchContextModel, AuthorizationCheckContextWithUserId authorizationContext) {
        if (Iterables.isEmpty(searchResultModel)) {
            return ImmutableMap.of();
        }
        AdditionalData.PersonAdditionalData additionalData = this.loadBadgeData(searchResultModel, searchContextModel, authorizationContext);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultModel) {
            PersonSearchResultBadgeModel badge = this.createSearchResultBadgeModel(commonSearchResultModel, additionalData);
            if (badge == null) continue;
            result.put((Object)CompoundId.of(badge.getId()), (Object)badge);
        }
        return result.build();
    }

    @CheckForNull
    private PersonSearchResultBadgeModel createSearchResultBadgeModel(@Nonnull CommonSearchResultModel searchResultModel, @Nonnull AdditionalData.PersonAdditionalData personAdditionalData) {
        DBPerson dbBadge = (DBPerson)personAdditionalData.getDBBeans().get(CompoundId.of(searchResultModel));
        if (dbBadge == null || dbBadge.isDeleted()) {
            LOG.warn("No db data found or person is mark as deleted for " + searchResultModel.getId() + ". Skip it!");
            return null;
        }
        PersonSearchResultBadgeModel searchBadge = new PersonSearchResultBadgeModel();
        searchBadge.setType(PersonType.PERSON);
        PersonId personId = dbBadge.getId();
        searchBadge.setId(personId);
        searchBadge.setFirstname(dbBadge.getFirstName());
        searchBadge.setSurname(dbBadge.getLastName());
        searchBadge.setLogo(dbBadge.getImage());
        searchBadge.setRoleNames(AuthorityUtil.names((Iterable<? extends Role>)personAdditionalData.getVisibleRoles().get((Object)personId)));
        searchBadge.setBlocked(dbBadge.isBlocked());
        searchBadge.setActive(dbBadge.isActive());
        searchBadge.setModifyDate(searchResultModel.getModifyDate());
        searchBadge.setPublicationDate(searchResultModel.getPublicationDate());
        searchBadge.setFirstname(searchResultModel.getFirstName());
        searchBadge.setSurname(searchResultModel.getLastName());
        searchBadge.setName(searchResultModel.getNameSubstring());
        searchBadge.setFullName(searchResultModel.getNameSubstring());
        this.addFoundIn(searchBadge, searchResultModel, personAdditionalData, personId);
        EntityInfo searchContextEntity = personAdditionalData.getSearchContextEntity();
        EntityMemberWithPerson entityMember = personAdditionalData.getEntityMembers().get(personId);
        if (searchContextEntity != null && entityMember != null) {
            searchBadge.setEntityMemberInformation(new PersonSearchResultEntityMemberInformation((EntityId)searchContextEntity.getId(), (EntityType)searchContextEntity.getType(), entityMember.getRoles()));
        }
        return searchBadge;
    }

    private void addFoundIn(@Nonnull PersonSearchResultBadgeModel searchBadge, @Nonnull CommonSearchResultModel searchResultModel, @Nonnull AdditionalData.PersonAdditionalData personAdditionalData, @Nonnull PersonId personId) {
        PersonSearchHandlerImpl.addFoundInField("tags", searchBadge, searchResultModel, DELIMETER);
        PersonSearchHandlerImpl.addFoundInDynamicFields(searchResultModel.getDynamicProfileAttributes(), searchBadge, searchResultModel, DELIMETER);
        searchBadge.setVisibleFields((List<BadgeField>)personAdditionalData.getVisibleProfileBadgeFields().get((Object)personId));
    }

    private static void addFoundInDynamicFields(@Nullable Map<String, Collection<String>> dynamicAttributes, @Nonnull PersonSearchResultBadgeModel badge, @Nonnull CommonSearchResultModel searchResult, @Nonnull String delimiter) {
        if (dynamicAttributes != null) {
            Map<String, List<String>> highlightedFields = searchResult.getHighlightedFields();
            if (highlightedFields == null) {
                return;
            }
            for (String dynamicFieldName : dynamicAttributes.keySet()) {
                List<String> values = highlightedFields.get(dynamicFieldName);
                if (CollectionUtil.isEmpty(values)) continue;
                PersonSearchHandlerImpl.addFoundInField(dynamicFieldName.substring("profile_dynamic_".length(), dynamicFieldName.length()), Joiner.on((String)delimiter).join(values), badge, true);
            }
        }
    }

    @Nonnull
    private AdditionalData.PersonAdditionalData loadBadgeData(@Nonnull Iterable<? extends CommonSearchResultModel> searchResultList, @Nullable SearchContextModel searchContextModel, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) {
        AdditionalSuggestData.PersonAdditionalSuggestData suggestData = this.loadSuggestData(searchResultList, authorizationContext);
        Map dbBeans = suggestData.getDBBeans();
        if (dbBeans.isEmpty()) {
            return AdditionalData.PersonAdditionalData.EMPTY;
        }
        ImmutableSet personIds = FluentIterable.from(dbBeans.values()).transform(DBPerson::getId).toSet();
        ImmutableSetMultimap<PersonId, PersonRole> visibleRoles = this._personRoleService.getVisibleRolesFor((Set<PersonId>)personIds, authorizationContext);
        EntityInfo entityInfo = this.loadSearchContextEntity(searchContextModel, authorizationContext);
        ImmutableMap entityMembers = entityInfo != null ? this._entityMemberService.getMemberByEntityIdAndPersonIds((EntityId)entityInfo.getId(), (Set<PersonId>)personIds) : ImmutableMap.of();
        return new AdditionalData.PersonAdditionalData(suggestData, visibleRoles, suggestData.getVisibleFields(), (Map<PersonId, EntityMemberWithPerson>)entityMembers, entityInfo);
    }

    @CheckForNull
    private EntityInfo loadSearchContextEntity(@Nullable SearchContextModel searchContextModel, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) {
        EntityId selectedEntityId = searchContextModel != null ? searchContextModel.getContextEntityId() : null;
        return selectedEntityId != null ? this._entityService.getInfoById(selectedEntityId, authorizationContext) : null;
    }

    @Override
    protected boolean canHandle(Type type) {
        return PersonType.PERSON.equals(type);
    }

    @Override
    public ImmutableMap<CompoundId, PersonSuggest> createSearchResultSuggestModel(Iterable<? extends CommonSearchResultModel> searchResultModel, AuthorizationCheckContextWithUserId authorizationContext) {
        if (Iterables.isEmpty(searchResultModel)) {
            return ImmutableMap.of();
        }
        AdditionalSuggestData.PersonAdditionalSuggestData additionalData = this.loadSuggestData(searchResultModel, authorizationContext);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultModel) {
            PersonSuggest badge = this.createSearchResultSuggestModel(commonSearchResultModel, additionalData);
            if (badge == null) continue;
            result.put((Object)CompoundId.of((PersonId)badge.getId()), (Object)badge);
        }
        return result.build();
    }

    @CheckForNull
    private PersonSuggest createSearchResultSuggestModel(@Nonnull CommonSearchResultModel searchResultModel, @Nonnull AdditionalSuggestData.PersonAdditionalSuggestData personAdditionalData) {
        DBPerson dbPerson = (DBPerson)personAdditionalData.getDBBeans().get(CompoundId.of(searchResultModel));
        if (dbPerson == null || dbPerson.isDeleted()) {
            LOG.warn("No db data found or person is mark as deleted for " + searchResultModel.getId() + ". Skip it!");
            return null;
        }
        PersonSuggest suggest = new PersonSuggest();
        this.applySearchData(searchResultModel, PersonType.PERSON, suggest);
        suggest.setBlocked(dbPerson.isBlocked());
        suggest.setActive(dbPerson.isActive());
        suggest.setLogo(dbPerson.getImage());
        suggest.setName(dbPerson.getFullName());
        suggest.setModifyDate(dbPerson.getModifyDate());
        suggest.setVisibleFields((ImmutableList<BadgeField>)personAdditionalData.getVisibleFields().get((Object)dbPerson.getId()));
        return suggest;
    }

    @Nonnull
    private AdditionalSuggestData.PersonAdditionalSuggestData loadSuggestData(@Nonnull Iterable<? extends CommonSearchResultModel> searchResultList, @Nonnull AuthorizationCheckContextWithUserId authCtx) {
        ImmutableSet ids = ImmutableSet.copyOf((Iterable)Iterables.transform(searchResultList, (Function)this._getId));
        if (Iterables.isEmpty((Iterable)ids)) {
            return AdditionalSuggestData.PersonAdditionalSuggestData.EMPTY;
        }
        ImmutableMap<PersonId, DBPerson> persons = this._personService.getPersonsByIds((Set<PersonId>)ids);
        if (persons.isEmpty()) {
            return AdditionalSuggestData.PersonAdditionalSuggestData.EMPTY;
        }
        HashMap<CompoundId, DBPerson> dbBeans = new HashMap<CompoundId, DBPerson>();
        for (Map.Entry entityEntry : persons.entrySet()) {
            DBPerson person = (DBPerson)entityEntry.getValue();
            dbBeans.put(CompoundId.of(person.getId()), person);
        }
        return new AdditionalSuggestData.PersonAdditionalSuggestData(dbBeans, this._profileTeaserService.getVisibleProfileBadgeFields((Set<PersonId>)ids, authCtx));
    }
}

