/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.server.util.StringUtil;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.integration.business.ExternalSystemAuthenticator;
import de.justsoftware.onx.searchnew.business.BasicSearchService;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.OpenSearchResultEntryBean;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderCapabilities;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderType;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.util.server.EncodingUtil;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class OpenSearchSearchService
implements BasicSearchService {
    public static final String OS_SEARCH_TERMS_PLACEHOLDER = "{searchTerms}";
    public static final String OS_COUNT_PLACEHOLDER = "{count}";
    public static final String OS_START_INDEX = "{startIndex}";
    public static final String OS_START_PAGE = "{startPage}";
    private static final String EMPTY_PARAM_VALUE = "";
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchSearchService.class);
    private final Function<SyndEntry, FederatedSearchResultEntry> _feedEntryToSearchResultEntryFunction = new Function<SyndEntry, FederatedSearchResultEntry>(){

        public FederatedSearchResultEntry apply(SyndEntry input) {
            if (input == null) {
                return null;
            }
            return OpenSearchSearchService.this.createResult(input.getTitle(), input.getLink(), input.getDescription().getValue());
        }
    };
    private String _username;
    private String _password;
    private int _maxDescriptionLength = 300;
    private String _urlTemplateString;
    private boolean _simulatePaging = false;
    private boolean _trustedProvider = false;
    private SearchProvider _searchProvider;
    @Autowired
    private ExternalSystemAuthenticator _externalSystemAuthenticator;

    @Override
    public SearchResult<FederatedSearchResultEntry> search(SearchParameters searchParameters, int offset, int numberOfResults, String searchTrackingId, SearchAuthorizationCheckContext authorizationContext) {
        if (authorizationContext.getUserId() == null) {
            throw new NotLoggedInException();
        }
        String searchString = searchParameters.getText();
        if (Strings.isNullOrEmpty((String)searchString)) {
            return new SearchResult<FederatedSearchResultEntry>(0, ImmutableList.of(), this.getSearchProvider());
        }
        try {
            SyndFeed feed = new SyndFeedInput().build((Reader)new XmlReader(this.getFeedConnection(searchParameters, offset, numberOfResults, authorizationContext)));
            List entries = feed.getEntries();
            int resultCount = entries.size();
            if (resultCount >= numberOfResults) {
                resultCount = this.extractResultCount(offset, feed);
            }
            ImmutableList<FederatedSearchResultEntry> resultEntries = this.transformResults(offset, entries);
            SearchResult<FederatedSearchResultEntry> result = new SearchResult<FederatedSearchResultEntry>(resultCount, resultEntries, this.getSearchProvider());
            result.setHasMoreResults(resultCount >= numberOfResults);
            return result;
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (FeedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return new SearchResult<FederatedSearchResultEntry>(0, ImmutableList.of(), this.getSearchProvider());
    }

    @Nonnull
    protected ImmutableList<FederatedSearchResultEntry> transformResults(int offset, @Nonnull List<SyndEntry> entries) {
        ImmutableList resultEntries = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Lists.transform(entries, this._feedEntryToSearchResultEntryFunction), (Predicate)Predicates.notNull()));
        if (this._simulatePaging && offset > 0 && resultEntries.size() >= offset) {
            return ImmutableList.copyOf((Collection)resultEntries.subList(offset, resultEntries.size()));
        }
        return resultEntries;
    }

    protected int extractResultCount(int offset, @Nonnull SyndFeed feed) {
        int numberOfResults = feed.getEntries().size();
        return numberOfResults += offset;
    }

    @Nonnull
    protected URLConnection getFeedConnection(@Nonnull SearchParameters params, int offset, int numberOfResults, @Nonnull SearchAuthorizationCheckContext authorizationContext) throws IOException {
        URL url = new URL(this.getFeedUrl(params, offset, numberOfResults, authorizationContext));
        URLConnection uc = url.openConnection();
        return uc;
    }

    @Nonnull
    protected String getFeedUrl(@Nonnull SearchParameters params, int offset, int numberOfResults, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        String replaceString = this._urlTemplateString;
        ImmutableMap<String, String> paramsMap = this.getParameterValues(params, offset, numberOfResults);
        for (Map.Entry paramEntry : paramsMap.entrySet()) {
            replaceString = this.replaceIfPresent(replaceString, (String)paramEntry.getKey(), (String)paramEntry.getValue());
        }
        return replaceString;
    }

    @Nonnull
    protected ImmutableMap<String, String> getParameterValues(@Nonnull SearchParameters params, int offset, int numberOfResults) {
        int count;
        ImmutableMap.Builder paramBuilder = ImmutableMap.builder();
        int paramsCount = numberOfResults;
        if (this._simulatePaging && offset > 0) {
            paramsCount += offset;
        }
        paramBuilder.put((Object)OS_SEARCH_TERMS_PLACEHOLDER, (Object)EncodingUtil.encodeURL(Strings.nullToEmpty((String)params.getText())));
        paramBuilder.put((Object)OS_COUNT_PLACEHOLDER, (Object)String.valueOf(paramsCount));
        paramBuilder.put((Object)OS_START_INDEX, (Object)String.valueOf(offset));
        String startPageString = EMPTY_PARAM_VALUE;
        if (offset > 0 && (count = paramsCount + 1) > 0) {
            startPageString = String.valueOf(offset / count);
        }
        paramBuilder.put((Object)OS_START_PAGE, (Object)startPageString);
        return paramBuilder.build();
    }

    @Nonnull
    protected String replaceIfPresent(@Nonnull String replaceString, @Nonnull String placeHolder, @Nonnull String value) {
        return replaceString.replace(placeHolder, value);
    }

    @CheckForNull
    protected FederatedSearchResultEntry createResult(@Nullable String title, @Nullable String link, @Nullable String description) {
        if (title == null || link == null) {
            return null;
        }
        if (!this._trustedProvider) {
            return this.createCleanResult(title, link, description);
        }
        return new OpenSearchResultEntryBean(title, link, description);
    }

    @CheckForNull
    protected FederatedSearchResultEntry createCleanResult(@Nullable String title, @Nullable String link, @Nullable String description) {
        if (title == null || link == null) {
            return null;
        }
        return new OpenSearchResultEntryBean(title, link, this.getShortDescription(description));
    }

    @CheckForNull
    private final String getShortDescription(@Nullable String description) {
        if (Strings.isNullOrEmpty((String)description)) {
            return null;
        }
        String cleanDescription = StringUtil.stripHTML(description);
        if (cleanDescription.length() <= this._maxDescriptionLength) {
            return cleanDescription;
        }
        return StringUtils.left((String)cleanDescription, (int)this._maxDescriptionLength) + "...";
    }

    @Override
    public SearchProvider getSearchProvider() {
        return this._searchProvider;
    }

    @Nonnull
    protected SearchProviderCapabilities getCapabilities() {
        return SearchProviderType.OPEN_SEARCH;
    }

    @Required
    public void setSearchProviderId(@Nonnull String providerIdString) {
        this._searchProvider = new SearchProvider(new SearchProviderId(providerIdString), this.getCapabilities());
    }

    @Required
    public void setUrlTemplateString(@Nonnull String templateUrl) {
        this._urlTemplateString = templateUrl;
    }

    public void setUsername(@Nonnull String username) {
        this._username = username;
    }

    public void setPassword(@Nonnull String password) {
        this._password = password;
    }

    public void setSimulatePaging(boolean simulatePaging) {
        this._simulatePaging = simulatePaging;
    }

    public void setTrustedSearchProvider(boolean trusted) {
        this._trustedProvider = trusted;
    }

    public boolean isTrustedProvider() {
        return this._trustedProvider;
    }

    public void setMaxDescriptionLength(int maxLength) {
        this._maxDescriptionLength = maxLength;
    }

    @PostConstruct
    protected void configureCredentials() {
        if (this._username != null && this._password != null) {
            try {
                URL templateUrl = new URL(this._urlTemplateString);
                URL baseUrl = new URL(templateUrl.getProtocol(), templateUrl.getHost(), templateUrl.getPort(), templateUrl.getPath());
                this._externalSystemAuthenticator.addExternalSystemCredentials(baseUrl, this._username, this._password);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("templateUrl for searchProvider " + this.getSearchProvider().getId() + " is invalid", e);
            }
        }
    }
}

