/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.configfile.ConfigFileChangeEvent;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.business.FilterConfiguration;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FilterConfigurationImpl
implements ServerEventHandler,
FilterConfiguration,
InitializingBean {
    private final Settings _settings;
    private final EntityConfigService _entityConfigService;
    private volatile Supplier<ImmutableSet<FilterType>> _orderedFilterTypes;
    private final FilterTypeVisitor.FilterTypeVisitorPredicate _onlyActiveEntityFilterTypesPredicate = new FilterTypeVisitor.FilterTypeVisitorPredicate(){

        @Override
        public Boolean visitDefault() {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visitEntity(EntityType entityType) {
            return FilterConfigurationImpl.this._entityConfigService.getOrderedActivatedEntityTypes().contains((Object)entityType);
        }
    };

    @Autowired
    public FilterConfigurationImpl(Settings settings, EntityConfigService entityConfigService) {
        this._settings = settings;
        this._entityConfigService = entityConfigService;
        this.initCaches();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onConfigFileChanged(ConfigFileChangeEvent e) {
        this.initCaches();
    }

    private void initCaches() {
        this._orderedFilterTypes = Suppliers.memoize(() -> {
            Iterable allActiveEntityTypes = Iterables.transform(this._entityConfigService.getOrderedActivatedEntityTypes(), FilterTypes.GET_BY_TYPE);
            return FluentIterable.from(this.getActiveFilterTypes()).append((Object[])new FilterType[]{StaticFilterType.DOCUMENTS}).append(allActiveEntityTypes).toSet();
        });
    }

    @Override
    public ImmutableSet<FilterType> getOrderedFilterTypes() {
        return (ImmutableSet)this._orderedFilterTypes.get();
    }

    @Nonnull
    private ImmutableSet<FilterType> getActiveFilterTypes() {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this._settings.getActiveFilterTypes(), (Predicate)this._onlyActiveEntityFilterTypesPredicate));
    }

    public void afterPropertiesSet() {
        this._settings.registerActiveFilterTypesChangedListener(event -> this.initCaches());
    }
}

