/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.drive.shared.model.DriveShareId;
import de.justsoftware.onx.message.business.MessageService;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.searchnew.business.ConversationSearchUtils;
import de.justsoftware.onx.searchnew.business.DriveDocumentSearchHandler;
import de.justsoftware.onx.searchnew.business.impl.AbstractSearchHandler;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchModel;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import de.justsoftware.onx.searchnew.shared.model.CompoundIdStringUtil;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSuggest;
import de.justsoftware.onx.searchnew.shared.model.ParentItemInfo;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class DriveDocumentSearchHandlerImpl
extends AbstractSearchHandler<DriveDocumentId, ItemType>
implements DriveDocumentSearchHandler {
    private static final String FOUND_IN_FIELD_DELIMITER = "... ";
    protected final EntityService _entityService;
    private final MessageService _messageService;
    private final PersonService _personService;

    @Autowired
    public DriveDocumentSearchHandlerImpl(EntityService entityService, MessageService messageService, PersonService personService) {
        this._entityService = entityService;
        this._messageService = messageService;
        this._personService = personService;
    }

    @Override
    public ImmutableMap<CompoundId, DriveDocumentSearchResultBadgeModel> createSearchResultBadgeModel(Iterable<? extends CommonSearchResultModel> searchResults, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableMap<ItemId, ParentItemInfo> parentInfos = this.loadParentInfo(searchResults, authorizationContext);
        ImmutableMap driveResult = FluentIterable.from(searchResults).transform(sr -> this.createSearchResultBadgeModel((CommonSearchResultModel)sr, parentInfos)).filter(Predicates.notNull()).uniqueIndex(result -> CompoundId.of((DriveDocumentId)result.getId()));
        return driveResult;
    }

    @Nonnull
    private ImmutableMap<ItemId, ParentItemInfo> loadParentInfo(Iterable<? extends CommonSearchResultModel> searchResults, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableMap.Builder infoBuilder = ImmutableMap.builder();
        FluentIterable parentIds = FluentIterable.from(searchResults).transform(DriveDocumentSearchHandlerImpl::getParentItemId).filter(Objects::nonNull);
        this._entityService.getInfoMapByIds((Set<EntityId>)parentIds.filter(EntityId.class).toSet(), authorizationContext).forEach((entityId, entityInfo) -> infoBuilder.put(entityId, (Object)new ParentItemInfo((ItemId)entityId, entityInfo.getName())));
        FluentIterable.from((Iterable)parentIds.filter(DriveShareId.class).toSet()).transform(shareId -> new ParentItemInfo((ItemId)shareId, String.valueOf(shareId))).forEach(info -> infoBuilder.put((Object)info.getItemId(), info));
        ImmutableSet chatIds = parentIds.filter(ConversationId.class).toSet();
        if (!chatIds.isEmpty()) {
            ImmutableMap<ConversationId, Conversation> chatMap = this._messageService.getConversationsByIds((ImmutableCollection<ConversationId>)chatIds, authorizationContext);
            ImmutableSet.Builder personIdBuilder = ImmutableSet.builder();
            chatMap.values().stream().filter(c -> !c.getType().equals(ConversationType.MULTI_USER_CHAT)).forEach(c -> personIdBuilder.addAll(c.getParticipants()));
            ImmutableMap<PersonId, DBPerson> personMap = this._personService.getPersonsByIds((Set<PersonId>)personIdBuilder.build());
            chatMap.forEach((chatId, conversation) -> infoBuilder.put(chatId, (Object)this.getChatInfo((Conversation)conversation, personMap)));
        }
        return infoBuilder.build();
    }

    @Nonnull
    private ParentItemInfo getChatInfo(Conversation c, ImmutableMap<PersonId, DBPerson> allPersons) {
        Map chatParticipantsMap = Maps.filterKeys(allPersons, p -> c.getParticipants().contains(p));
        return new ParentItemInfo(c.getId(), ConversationSearchUtils.getConversationName(c, chatParticipantsMap));
    }

    @Override
    public ImmutableMap<CompoundId, DriveDocumentSuggest> createSearchResultSuggestModel(Iterable<? extends CommonSearchResultModel> searchResults, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableMap driveResult = FluentIterable.from(searchResults).transform(this::createSearchResultSuggestModel).filter(Predicates.notNull()).uniqueIndex(result -> CompoundId.of((DriveDocumentId)result.getId()));
        return driveResult;
    }

    @CheckForNull
    private DriveDocumentSuggest createSearchResultSuggestModel(CommonSearchResultModel searchResult) {
        DriveDocumentSearchResultBadgeModel.DocumentType docType = this.getDriveDocType(searchResult);
        DriveDocumentSuggest suggest = new DriveDocumentSuggest(docType);
        this.applySearchData(searchResult, ItemType.DRIVE_DOCUMENT, suggest);
        suggest.setMimeType(this.getDriveMimeType(searchResult));
        suggest.setExpirationDate(searchResult.getExpirationDate());
        suggest.setModifyDate(searchResult.getModifyDate());
        suggest.setFileSize(searchResult.getDriveFileSize());
        ItemId parentId = DriveDocumentSearchHandlerImpl.getParentItemId(searchResult);
        if (parentId != null) {
            suggest.setParentId(parentId);
        }
        return suggest;
    }

    @CheckForNull
    private static ItemId getParentItemId(CommonSearchResultModel searchResult) {
        Iterable<String> directParentIds = searchResult.getDirectParentIds();
        if (CollectionUtil.isEmpty(directParentIds)) {
            return null;
        }
        return (ItemId)FluentIterable.from(directParentIds).transform(ItemId::parse).filter(Objects::nonNull).first().orNull();
    }

    @CheckForNull
    private DriveDocumentSearchResultBadgeModel createSearchResultBadgeModel(CommonSearchResultModel searchResult, ImmutableMap<ItemId, ParentItemInfo> parentInfos) {
        DriveDocumentSearchResultBadgeModel.DocumentType docType = this.getDriveDocType(searchResult);
        DriveDocumentSearchResultBadgeModel result = new DriveDocumentSearchResultBadgeModel(docType);
        result.setId(new DriveDocumentId(CompoundIdStringUtil.parseStringId(searchResult.getId())));
        result.setType(ItemType.DRIVE_DOCUMENT);
        result.setName(searchResult.getNameSubstring());
        result.setMimeType(this.getDriveMimeType(searchResult));
        result.setFileSize(searchResult.getDriveFileSize());
        result.setCommonFields(searchResult);
        ItemId parentId = DriveDocumentSearchHandlerImpl.getParentItemId(searchResult);
        if (parentId != null) {
            result.setParentItemInfo((ParentItemInfo)parentInfos.get((Object)parentId));
        }
        DriveDocumentSearchHandlerImpl.addFoundInData(result, searchResult, FOUND_IN_FIELD_DELIMITER);
        return result;
    }

    @Nonnull
    private DriveDocumentSearchResultBadgeModel.DocumentType getDriveDocType(CommonSearchResultModel searchResult) {
        String docType = DriveDocumentSearchHandlerImpl.getDriveValue(searchResult, "drive_document_type");
        if (docType != null) {
            return DriveDocumentSearchResultBadgeModel.DocumentType.valueOf(docType);
        }
        return DriveDocumentSearchResultBadgeModel.DocumentType.FILE;
    }

    @CheckForNull
    private String getDriveMimeType(CommonSearchModel searchResult) {
        return DriveDocumentSearchHandlerImpl.getDriveValue(searchResult, "drive_mime_type");
    }

    @CheckForNull
    private static String getDriveValue(CommonSearchModel searchModel, String fieldName) {
        Collection<String> values;
        Map<String, Collection<String>> driveFields = searchModel.getDriveSpecificFields();
        if (driveFields != null && !CollectionUtil.isEmpty(values = driveFields.get(fieldName))) {
            return (String)Iterables.getOnlyElement(values);
        }
        return null;
    }

    private static void addFoundInData(DriveDocumentSearchResultBadgeModel searchResultBadgeModel, CommonSearchResultModel searchResultModel, String delimiter) {
        DriveDocumentSearchHandlerImpl.addFoundInField("description", searchResultBadgeModel, searchResultModel, delimiter);
        DriveDocumentSearchHandlerImpl.addFoundInField("tags", searchResultBadgeModel, searchResultModel, delimiter);
        DriveDocumentSearchHandlerImpl.addFoundInField("content", searchResultBadgeModel, searchResultModel, delimiter);
        DriveDocumentSearchHandlerImpl.addFoundInField("author", searchResultBadgeModel, searchResultModel, delimiter);
    }

    @Override
    protected DriveDocumentId createId(String stringId) {
        return new DriveDocumentId(CompoundIdStringUtil.parseStringId(stringId));
    }

    @Override
    protected boolean canHandle(Type type) {
        return ItemType.DRIVE_DOCUMENT == type;
    }
}

