/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.events.business.UpdateEventProcessor;
import de.justsoftware.onx.events.shared.server.model.UpdateEventType;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.searchnew.business.ConversationSearchIndexService;
import de.justsoftware.onx.searchnew.business.model.ConversationIndexType;
import de.justsoftware.onx.searchnew.shared.server.model.DBConversationSearchIndexQueueEntry;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="conversationSearchIndexUpdateEventProcessor")
@ParametersAreNonnullByDefault
public class ConversationSearchIndexUpdateEventProcessor
implements UpdateEventProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ConversationSearchIndexUpdateEventProcessor.class);
    @Autowired
    private ConversationSearchIndexService _searchIndexService;
    @Autowired
    private Clock _clock;

    @Override
    public void processEventsOfType(UpdateEventType eventType, Set<ItemId> itemIds) {
        LOG.info("Processing events...");
        switch (eventType) {
            case CONVERSATION_UPDATED: 
            case CONVERSATION_DELETED: {
                this.index(itemIds, ConversationId.class, ConversationIndexType.CONVERSATION);
                return;
            }
            case CHAT_MESSAGE_UPDATED: {
                this.index(itemIds, ChatMessageId.class, ConversationIndexType.MESSAGE);
                return;
            }
        }
    }

    private void index(Set<ItemId> itemIds, Class<? extends AbstractUUIDBasedItemId> desiredClass, ConversationIndexType indexType) {
        ImmutableSet indexingItems = FluentIterable.from(itemIds).filter(desiredClass).transform(id -> new DBConversationSearchIndexQueueEntry((AbstractUUIDBasedItemId)id, this._clock.now(), indexType)).toSet();
        if (!CollectionUtil.isEmpty(indexingItems)) {
            this._searchIndexService.queueItemsForIndex((Set<DBConversationSearchIndexQueueEntry>)indexingItems);
        }
        LOG.info("Processing events done!");
    }
}

