/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.chat.model.AttachmentChatMessage;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.chat.model.TextChatMessage;
import de.justsoftware.onx.common.server.model.HasMoreList;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.message.business.MessageReadDataService;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.model.MessageLoadDirection;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.monitoring.business.QueueStatisticsService;
import de.justsoftware.onx.monitoring.business.model.QueueName;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.ConversationSearchIndexService;
import de.justsoftware.onx.searchnew.business.ConversationSearchUtils;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.business.model.ConversationIndexType;
import de.justsoftware.onx.searchnew.integration.persistence.ConversationSearchIndexQueueDAO;
import de.justsoftware.onx.searchnew.shared.server.model.ConversationSearchIndexQueueEntryId;
import de.justsoftware.onx.searchnew.shared.server.model.DBConversationSearchIndexQueueEntry;
import de.justsoftware.permission.client.model.Role;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="conversationSearchIndexService")
@ParametersAreNonnullByDefault
public class ConversationSearchIndexServiceImpl
implements ConversationSearchIndexService {
    private static final long UNLOCK_EVENT_TIME = 300000L;
    private static final int QUEUE_PROCESS_BATCH_SIZE = 100;
    private static final Logger LOG = LoggerFactory.getLogger(ConversationSearchIndexServiceImpl.class);
    @Autowired
    private ConversationSearchIndexQueueDAO _conversationSearchIndexQueueDAO;
    @Autowired
    private QueueStatisticsService _queueStatisticsService;
    @Autowired
    private ItemService _itemService;
    @Autowired
    private PersonService _personService;
    @Autowired
    @Qualifier(value="writeSolrServer")
    private SolrClient _writeSolrServer;
    @Autowired
    private MessageReadDataService _messageReadDataService;

    @Override
    public void queueItemsForIndex(Set<DBConversationSearchIndexQueueEntry> items) {
        this._conversationSearchIndexQueueDAO.create(items);
    }

    @Override
    public void processQueue() {
        this._conversationSearchIndexQueueDAO.unlockStuckIds(300000L);
        ImmutableList<DBConversationSearchIndexQueueEntry> queueEntries = this._conversationSearchIndexQueueDAO.fetchNext(100);
        while (!queueEntries.isEmpty()) {
            this.reportStatistics(queueEntries);
            this.processQueueEntries(queueEntries);
            queueEntries = this._conversationSearchIndexQueueDAO.fetchNext(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueueEntries(ImmutableList<DBConversationSearchIndexQueueEntry> queueEntries) {
        if (queueEntries.isEmpty()) {
            return;
        }
        try {
            ImmutableMap<AbstractUUIDBasedItemId, Item<? extends AbstractUUIDBasedItemId>> itemsByIds = this.getAllItemsByIds(queueEntries);
            Predicate<DBConversationSearchIndexQueueEntry> isDeletedConversationEntry = entry -> entry.getIndexType() == ConversationIndexType.CONVERSATION && !itemsByIds.containsKey((Object)entry.toItemId());
            ImmutableList entriesToIndex = (ImmutableList)queueEntries.stream().filter(isDeletedConversationEntry.negate()).collect(ImmutableList.toImmutableList());
            this.handleEntriesToIndex((ImmutableList<DBConversationSearchIndexQueueEntry>)entriesToIndex, itemsByIds);
            List<String> conversationsToDelete = queueEntries.stream().filter(isDeletedConversationEntry).map(entry -> entry.toItemId().toString()).collect(Collectors.toList());
            this.handleDeletedConversations(conversationsToDelete);
            LOG.info("Indexing conversations successfully finished.");
        }
        catch (IOException | RuntimeException | SolrServerException e) {
            LOG.error("Error while indexing conversation messages", e);
        }
        finally {
            this._conversationSearchIndexQueueDAO.deleteByIds((Iterable<ConversationSearchIndexQueueEntryId>)FluentIterable.from(queueEntries).transform(DBConversationSearchIndexQueueEntry.TO_ID));
        }
    }

    private void handleEntriesToIndex(ImmutableList<DBConversationSearchIndexQueueEntry> entriesToIndex, ImmutableMap<AbstractUUIDBasedItemId, Item<? extends AbstractUUIDBasedItemId>> itemsByIds) throws IOException {
        if (entriesToIndex.isEmpty()) {
            return;
        }
        ImmutableList<DBConversationSearchIndexQueueEntry> transformedQueueEntries = this.handleDeleteMessageUpdateEvents(entriesToIndex, itemsByIds);
        ImmutableListMultimap<DBConversationSearchIndexQueueEntry, JucoSolrInputDocument> documents = this.createSolrInputDocuments(transformedQueueEntries, itemsByIds);
        this.addDocumentsToSolr(documents);
    }

    private void handleDeletedConversations(List<String> conversationsToDelete) throws IOException, SolrServerException {
        if (conversationsToDelete.isEmpty()) {
            return;
        }
        this._writeSolrServer.deleteById(conversationsToDelete);
        LOG.info("Indexing conversations will delete {} conversations from index.", (Object)conversationsToDelete.size());
    }

    @Nonnull
    private ImmutableList<DBConversationSearchIndexQueueEntry> handleDeleteMessageUpdateEvents(ImmutableList<DBConversationSearchIndexQueueEntry> queueEntries, ImmutableMap<AbstractUUIDBasedItemId, Item<? extends AbstractUUIDBasedItemId>> itemsByIds) {
        ImmutableSet<ConversationId> conversationIdsWithDeletedMessages = this.getConversationIdsWithDeletedMessages(queueEntries, itemsByIds);
        if (conversationIdsWithDeletedMessages.isEmpty()) {
            return queueEntries;
        }
        this._conversationSearchIndexQueueDAO.deleteByConversationId(conversationIdsWithDeletedMessages);
        Stream<DBConversationSearchIndexQueueEntry> nonDeleteMessageQueueEntries = queueEntries.stream().filter(queueEntry -> {
            Item item = (Item)itemsByIds.get((Object)queueEntry.getId());
            if (item instanceof Conversation) {
                return !conversationIdsWithDeletedMessages.contains((Object)((Conversation)item).getId());
            }
            if (item instanceof ChatMessage) {
                return !conversationIdsWithDeletedMessages.contains((Object)((ChatMessage)item).getConversationId());
            }
            return false;
        });
        Stream<DBConversationSearchIndexQueueEntry> fullIndexQueueEntries = conversationIdsWithDeletedMessages.stream().map(conversationId -> new DBConversationSearchIndexQueueEntry((AbstractUUIDBasedItemId)conversationId, DateTime.now(), ConversationIndexType.CONVERSATION_AND_MESSAGES));
        return (ImmutableList)Stream.concat(nonDeleteMessageQueueEntries, fullIndexQueueEntries).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private ImmutableSet<ConversationId> getConversationIdsWithDeletedMessages(ImmutableList<DBConversationSearchIndexQueueEntry> queueEntries, ImmutableMap<AbstractUUIDBasedItemId, Item<? extends AbstractUUIDBasedItemId>> itemsByIds) {
        return (ImmutableSet)queueEntries.stream().map(DBConversationSearchIndexQueueEntry::toItemId).filter(itemId -> itemId.getType() == ItemType.CHAT_MESSAGE).map(arg_0 -> itemsByIds.get(arg_0)).filter(ChatMessage.class::isInstance).map(ChatMessage.class::cast).filter(msg -> msg.getType() == ChatMessageType.DELETED_CHAT_MESSAGE).map(ChatMessage::getConversationId).collect(ImmutableSet.toImmutableSet());
    }

    private void addDocumentsToSolr(ImmutableListMultimap<DBConversationSearchIndexQueueEntry, JucoSolrInputDocument> documents) throws IOException {
        int conversationsUpdated;
        try {
            this._writeSolrServer.add(Collections2.transform((Collection)documents.values(), JucoSolrInputDocument.TO_SOLR_INPUT_DOCUMENT));
            conversationsUpdated = documents.size();
        }
        catch (SolrServerException | SolrException collectionTry) {
            conversationsUpdated = 0;
            for (Map.Entry entry : documents.entries()) {
                try {
                    this._writeSolrServer.add(((JucoSolrInputDocument)entry.getValue()).getDoc());
                    ++conversationsUpdated;
                }
                catch (SolrServerException | SolrException singleTry) {
                    AbstractUUIDBasedItemId id = ((DBConversationSearchIndexQueueEntry)entry.getKey()).toItemId();
                    ConversationIndexType indexType = ((DBConversationSearchIndexQueueEntry)entry.getKey()).getIndexType();
                    LOG.error("Failed indexing item with id " + id + " and with index type " + indexType, singleTry);
                }
            }
        }
        LOG.info("Indexing conversations will update {} conversations and/or messages.", (Object)conversationsUpdated);
    }

    @Nonnull
    private ImmutableListMultimap<DBConversationSearchIndexQueueEntry, JucoSolrInputDocument> createSolrInputDocuments(ImmutableList<DBConversationSearchIndexQueueEntry> queueEntries, ImmutableMap<AbstractUUIDBasedItemId, Item<? extends AbstractUUIDBasedItemId>> itemsByIds) {
        ImmutableSet conversations = FluentIterable.from((Iterable)itemsByIds.values()).filter(Conversation.class).toSet();
        ImmutableSet participantIds = FluentIterable.from((Iterable)conversations).transformAndConcat(Conversation.TO_PARTICIPANTS).toSet();
        ImmutableMap<PersonId, DBPerson> participants = this._personService.getPersonsByIds((Set<PersonId>)participantIds);
        ImmutableListMultimap.Builder solrInputDocuments = ImmutableListMultimap.builder();
        for (DBConversationSearchIndexQueueEntry queueEntry : queueEntries) {
            AbstractUUIDBasedItemId itemId = queueEntry.toItemId();
            try {
                switch (queueEntry.getIndexType()) {
                    case CONVERSATION: {
                        solrInputDocuments.put((Object)queueEntry, (Object)this.indexConversation(itemId, (Item)itemsByIds.get((Object)itemId), participants, false));
                        break;
                    }
                    case CONVERSATION_AND_MESSAGES: {
                        JucoSolrInputDocument inputDocument = this.indexConversation(itemId, (Item)itemsByIds.get((Object)itemId), participants, true);
                        this.indexAllConversationMessages(itemId, inputDocument);
                        solrInputDocuments.put((Object)queueEntry, (Object)inputDocument);
                        break;
                    }
                    case MESSAGE: {
                        JucoSolrInputDocument solrInputDocument = this.indexConversationForMessage(itemId, itemsByIds, participants);
                        this.indexMessage((Item)itemsByIds.get((Object)itemId), solrInputDocument);
                        solrInputDocuments.put((Object)queueEntry, (Object)solrInputDocument);
                        break;
                    }
                }
            }
            catch (RuntimeException e) {
                LOG.error("Failed to create JucoSolrInputDocument for item with id " + itemId + " and with index type " + queueEntry.getIndexType(), (Throwable)e);
            }
        }
        return solrInputDocuments.build();
    }

    private void indexAllConversationMessages(AbstractUUIDBasedItemId itemId, JucoSolrInputDocument solrInputDocument) {
        if (!(itemId instanceof ConversationId)) {
            throw new IllegalStateException("Expected conversationId for indexing all messages");
        }
        ConversationId conversationId = (ConversationId)itemId;
        HasMoreList<ChatMessage> messages = null;
        DateTime offset = null;
        ArrayList<String> conversationMessages = new ArrayList<String>(1000);
        do {
            messages = this._messageReadDataService.getMessagesByConversation(conversationId, offset, 1000, MessageLoadDirection.LOAD_OLDER_MESSAGES);
            for (ChatMessage msg : messages.getSubList()) {
                if (msg instanceof TextChatMessage) {
                    TextChatMessage textChatMessage = (TextChatMessage)msg;
                    conversationMessages.add(textChatMessage.getMessage());
                } else if (msg instanceof AttachmentChatMessage) {
                    AttachmentChatMessage attachmentChatMessage = (AttachmentChatMessage)msg;
                    conversationMessages.add(attachmentChatMessage.getAttachment().getFilename());
                }
                offset = msg.getCreateDate();
            }
        } while (messages.isHasMore());
        solrInputDocument.addField((SearchField)CommonSearchFields.CONTENT, conversationMessages);
    }

    @Nonnull
    private ImmutableMap<AbstractUUIDBasedItemId, Item<? extends AbstractUUIDBasedItemId>> getAllItemsByIds(ImmutableList<DBConversationSearchIndexQueueEntry> queueEntries) {
        ImmutableMap itemsByIds = this._itemService.getByIds(Iterables.transform(queueEntries, DBConversationSearchIndexQueueEntry.TO_ITEM_ID));
        ImmutableSet messageConversationIds = FluentIterable.from((Iterable)itemsByIds.values()).filter(ChatMessage.class).transform(ChatMessage.TO_CONVERSATION_ID).filter(input -> !itemsByIds.containsKey(input)).toSet();
        ImmutableMap moreItemsByIds = this._itemService.getByIds(messageConversationIds);
        HashMap result = Maps.newHashMap(itemsByIds);
        result.putAll(moreItemsByIds);
        return ImmutableMap.copyOf((Map)result);
    }

    @Nonnull
    private JucoSolrInputDocument indexConversation(AbstractUUIDBasedItemId itemId, @Nullable Item<? extends AbstractUUIDBasedItemId> item, ImmutableMap<PersonId, DBPerson> allParticipants, boolean fullIndex) {
        if (!(itemId instanceof ConversationId) || !(item instanceof Conversation)) {
            throw new IllegalStateException("Expected conversation for index type CONVERSATION");
        }
        ConversationId conversationId = (ConversationId)itemId;
        JucoSolrInputDocument doc = fullIndex ? JucoSolrInputDocument.full(conversationId) : JucoSolrInputDocument.atomic(conversationId);
        Conversation conversation = (Conversation)item;
        String name = ConversationSearchUtils.getConversationName(conversation, allParticipants);
        doc.addField((SearchField)CommonSearchFields.NAME, name);
        doc.addField((SearchField)CommonSearchFields.NAME_SORT, name);
        doc.addField((SearchField)CommonSearchFields.TYPE, ItemType.CONVERSATION.name());
        doc.addField((SearchField)CommonSearchFields.CONVERSATION_TYPE, conversation.getType().name());
        doc.addField((SearchField)CommonSearchFields.VISIBLE_FOR_PERSONS, (Iterable<?>)FluentIterable.from(conversation.getParticipants()).transform(LongId.TO_LONG).toList());
        doc.addField((SearchField)CommonSearchFields.VISIBLE_FOR_ROLES, (Iterable)conversation.getUserGroups().stream().map(userGroupId -> Role.userGroupRole((UUID)userGroupId.getId()).asString()).collect(ImmutableSet.toImmutableSet()));
        doc.addField((SearchField)CommonSearchFields.MODIFY_DATE, Optional.fromNullable((Object)conversation.getLastMessageDate().toDate()));
        doc.addField((SearchField)CommonSearchFields.PARTICIPANTS, (Iterable<?>)ConversationSearchUtils.getParticipantNames(conversation, allParticipants));
        doc.addField((SearchField)CommonSearchFields.DIRECT_MEMBER_IDS, (Iterable<?>)FluentIterable.from(conversation.getParticipants()).transform(CompoundId.FROM_PERSON_ID_TO_SEARCH_STRING).toList());
        return doc;
    }

    @Nonnull
    private JucoSolrInputDocument indexConversationForMessage(AbstractUUIDBasedItemId itemId, ImmutableMap<AbstractUUIDBasedItemId, Item<? extends AbstractUUIDBasedItemId>> itemsByIds, ImmutableMap<PersonId, DBPerson> allParticipants) {
        Item msgItem = (Item)itemsByIds.get((Object)itemId);
        if (!(msgItem instanceof ChatMessage)) {
            throw new IllegalStateException("Expected ChatMessages for index type MESSAGE");
        }
        ChatMessage chatMessage = (ChatMessage)msgItem;
        ConversationId conversationId = chatMessage.getConversationId();
        return this.indexConversation(conversationId, (Item)itemsByIds.get((Object)conversationId), allParticipants, false);
    }

    @Nonnull
    private JucoSolrInputDocument indexMessage(@Nullable Item<? extends AbstractUUIDBasedItemId> item, JucoSolrInputDocument doc) {
        if (!(item instanceof ChatMessage)) {
            throw new IllegalStateException("Expected ChatMessages for index type MESSAGE");
        }
        ChatMessage message = (ChatMessage)item;
        if (message instanceof TextChatMessage) {
            TextChatMessage textChatMessage = (TextChatMessage)message;
            doc.atomicAddField(CommonSearchFields.CONTENT, textChatMessage.getMessage());
        } else if (message instanceof AttachmentChatMessage) {
            AttachmentChatMessage attachmentChatMessage = (AttachmentChatMessage)message;
            doc.atomicAddField(CommonSearchFields.CONTENT, attachmentChatMessage.getAttachment().getFilename());
        }
        return doc;
    }

    private void reportStatistics(ImmutableList<DBConversationSearchIndexQueueEntry> queueEntries) {
        ImmutableList timestamps = FluentIterable.from(queueEntries).transform((Function)new Function<DBConversationSearchIndexQueueEntry, DateTime>(){

            public DateTime apply(DBConversationSearchIndexQueueEntry input) {
                return input.getCreatedAt();
            }
        }).toList();
        this._queueStatisticsService.itemsDequeued(QueueName.CONVERSATION_SEARCH, (Iterable<DateTime>)timestamps);
    }

    @Override
    public long getQueueSize() {
        return this._conversationSearchIndexQueueDAO.getQueueSize();
    }
}

