/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.model.BadgeFieldType;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.server.util.HtmlUtil;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.message.business.MessageService;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.searchnew.business.ConversationSearchHandler;
import de.justsoftware.onx.searchnew.business.impl.AbstractSearchHandler;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import de.justsoftware.onx.searchnew.shared.model.ConversationSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.ConversationSuggest;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ConversationSearchHandlerImpl
extends AbstractSearchHandler<ConversationId, ItemType>
implements ConversationSearchHandler {
    private static final Function<CommonSearchResultModel, ConversationId> TO_CONVERSATION_ID = new Function<CommonSearchResultModel, ConversationId>(){

        public ConversationId apply(CommonSearchResultModel input) {
            UUID id = CompoundId.parseUUID(input.getId());
            return new ConversationId(id);
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(ConversationSearchHandlerImpl.class);
    private final MessageService _messageService;

    @Autowired
    public ConversationSearchHandlerImpl(MessageService messageService) {
        this._messageService = messageService;
    }

    @Override
    public ImmutableMap<CompoundId, ConversationSearchResultBadgeModel> createSearchResultBadgeModel(Iterable<? extends CommonSearchResultModel> searchResultModels, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        ImmutableMap<ConversationId, Conversation> conversations = this.loadConversations(searchResultModels);
        for (CommonSearchResultModel commonSearchResultModel : searchResultModels) {
            ConversationSearchResultBadgeModel badgeModel = this.createSearchResultBadgeModel(commonSearchResultModel, (Conversation)conversations.get(TO_CONVERSATION_ID.apply((Object)commonSearchResultModel)));
            if (badgeModel == null) continue;
            result.put((Object)CompoundId.of((AbstractUUIDBasedItemId)badgeModel.getId()), (Object)badgeModel);
        }
        return result.build();
    }

    @Nonnull
    private ImmutableMap<ConversationId, Conversation> loadConversations(Iterable<? extends CommonSearchResultModel> searchResultModel) {
        return this._messageService.getConversationsByIdsWithoutAuthorizationCheck((ImmutableCollection<ConversationId>)FluentIterable.from(searchResultModel).transform(TO_CONVERSATION_ID).toList());
    }

    @CheckForNull
    private ConversationSearchResultBadgeModel createSearchResultBadgeModel(CommonSearchResultModel searchResultModel, @Nullable Conversation conversation) {
        if (conversation == null) {
            LOG.warn("No db data found for " + searchResultModel.getId() + ". Skip it!");
            return null;
        }
        ConversationSearchResultBadgeModel result = new ConversationSearchResultBadgeModel();
        result.setId(conversation.getId());
        result.setType(ItemType.CONVERSATION);
        result.setConversationType(conversation.getType());
        result.setParticipants(conversation.getParticipants());
        result.setDeletedParticipants(conversation.getDeletedParticipants());
        result.setCommonFields(searchResultModel);
        result.setName(searchResultModel.getNameSubstring());
        this.addFoundInField("content", result, searchResultModel);
        this.addFoundInField("participants", result, searchResultModel);
        return result;
    }

    private void addFoundInField(String fieldName, ConversationSearchResultBadgeModel badge, CommonSearchResultModel searchResult) {
        Map<String, List<String>> highlightedFields = searchResult.getHighlightedFields();
        if (highlightedFields == null) {
            return;
        }
        List<String> list = highlightedFields.get(fieldName);
        if (list == null || list.isEmpty()) {
            return;
        }
        badge.addFoundInField(new BadgeField(fieldName, BadgeFieldType.VALUES, (ImmutableList<String>)ImmutableList.copyOf(list)));
    }

    @CheckForNull
    private ConversationSuggest createSearchResultSuggestModel(CommonSearchResultModel searchResultModel, @Nullable Conversation conversation) {
        if (conversation == null) {
            LOG.warn("No db data found for " + searchResultModel.getId() + ". Skip it!");
            return null;
        }
        ConversationSuggest suggest = new ConversationSuggest();
        this.applySearchData(searchResultModel, ItemType.CONVERSATION, suggest);
        suggest.setName(HtmlUtil.removeHighlightTag(searchResultModel.getName()));
        return suggest;
    }

    @Override
    public ImmutableMap<CompoundId, ConversationSuggest> createSearchResultSuggestModel(Iterable<? extends CommonSearchResultModel> searchResultModel, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        ImmutableMap<ConversationId, Conversation> conversations = this.loadConversations(searchResultModel);
        for (CommonSearchResultModel commonSearchResultModel : searchResultModel) {
            ConversationSuggest suggest = this.createSearchResultSuggestModel(commonSearchResultModel, (Conversation)conversations.get(TO_CONVERSATION_ID.apply((Object)commonSearchResultModel)));
            if (suggest == null) continue;
            result.put((Object)CompoundId.of((AbstractUUIDBasedItemId)suggest.getId()), (Object)suggest);
        }
        return result.build();
    }

    @Override
    protected ConversationId createId(String stringId) {
        return new ConversationId(CompoundId.parseUUID(stringId));
    }

    @Override
    protected boolean canHandle(Type type) {
        return ItemType.CONVERSATION == type;
    }
}

