/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.sun.syndication.feed.synd.SyndFeed;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.integration.business.PersonExternalIdService;
import de.justsoftware.onx.integration.shared.model.ExternalPersonId;
import de.justsoftware.onx.integration.shared.model.ExternalSystemId;
import de.justsoftware.onx.searchnew.business.impl.OpenSearchSearchService;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderCapabilities;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfluenceOpenSearchServiceImpl
extends OpenSearchSearchService {
    private static final Pattern COUNT_PATTERN = Pattern.compile(".*returned\\s(\\d+)\\s.*results.*");
    private boolean _impersonate = false;
    private ExternalSystemId _systemId;
    @Autowired
    private PersonExternalIdService _personExternalIdService;

    public ConfluenceOpenSearchServiceImpl() {
        this.setSimulatePaging(true);
    }

    @Override
    public String getFeedUrl(SearchParameters params, int offset, int numberOfResults, SearchAuthorizationCheckContext authorizationContext) {
        String feedUrl = super.getFeedUrl(params, offset, numberOfResults, authorizationContext);
        if (this._impersonate) {
            return this.getFeedUrlWithUserImpersonation(feedUrl, authorizationContext);
        }
        return feedUrl;
    }

    @Override
    protected int extractResultCount(int offset, SyndFeed feed) {
        String countString;
        Matcher matcher;
        String description = feed.getDescription();
        if (description != null && (matcher = COUNT_PATTERN.matcher(description)).matches() && NumberUtils.isNumber((String)(countString = matcher.group(1)))) {
            return NumberUtils.toInt((String)countString);
        }
        return super.extractResultCount(offset, feed);
    }

    @Nonnull
    private String getFeedUrlWithUserImpersonation(@Nonnull String feedUrl, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        PersonId personId = authorizationContext.getUserId();
        return feedUrl + "&impersonation=true&user=" + this.getConfluenceUserName(personId);
    }

    @Nonnull
    private String getConfluenceUserName(@Nonnull PersonId personId) {
        ExternalPersonId externalUserId = this._personExternalIdService.getExternalPersonId(personId, this._systemId);
        return externalUserId != null ? externalUserId.getId() : "";
    }

    public void setImpersonate(boolean impersonate) {
        this._impersonate = impersonate;
    }

    @Override
    protected SearchProviderCapabilities getCapabilities() {
        return SearchProviderType.CONFLUENCE;
    }

    @Override
    public SearchProvider getSearchProvider() {
        return super.getSearchProvider();
    }

    public void setSystemId(@Nonnull String systemIdString) {
        this._systemId = new ExternalSystemId(systemIdString);
    }

    @PostConstruct
    public void validateConfig() {
        if (this._impersonate && this._systemId == null) {
            throw new IllegalStateException("No systemId configured for searchProvider " + this + " although impersonate is set to true. Please specify the systemId in the applicationContext");
        }
    }
}

