/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.PersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.business.EntityParentsServiceForTest;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.profile.business.ProfileReadDataService;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributeSearchType;
import de.justsoftware.onx.profile.model.ProfileAttributesConfiguration;
import de.justsoftware.onx.searchnew.business.ArticleSearchHandler;
import de.justsoftware.onx.searchnew.business.ChapterSearchHandler;
import de.justsoftware.onx.searchnew.business.ChatSearchHandler;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.CommonSearchTestService;
import de.justsoftware.onx.searchnew.business.ConversationSearchHandler;
import de.justsoftware.onx.searchnew.business.DriveDocumentSearchHandler;
import de.justsoftware.onx.searchnew.business.EntitySearchHandler;
import de.justsoftware.onx.searchnew.business.FilterConfiguration;
import de.justsoftware.onx.searchnew.business.LearnToRankService;
import de.justsoftware.onx.searchnew.business.PersonSearchHandler;
import de.justsoftware.onx.searchnew.business.SearchDataService;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.WikiSearchHandler;
import de.justsoftware.onx.searchnew.business.WorkstreamSearchHandler;
import de.justsoftware.onx.searchnew.business.criteria.AndExpression;
import de.justsoftware.onx.searchnew.business.criteria.Criterion;
import de.justsoftware.onx.searchnew.business.criteria.FilterQueryCriteria;
import de.justsoftware.onx.searchnew.business.criteria.LocalParam;
import de.justsoftware.onx.searchnew.business.criteria.LocalParamCriterion;
import de.justsoftware.onx.searchnew.business.criteria.OrExpression;
import de.justsoftware.onx.searchnew.business.criteria.Restrictions;
import de.justsoftware.onx.searchnew.business.criteria.UnaryNotExpression;
import de.justsoftware.onx.searchnew.business.data.IsFullIndexable;
import de.justsoftware.onx.searchnew.business.impl.AbstractSearchService;
import de.justsoftware.onx.searchnew.business.impl.ExtractHighlightingSearchStringVisitor;
import de.justsoftware.onx.searchnew.business.impl.ItemTypeToFilterTypesMapper;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.searchnew.business.impl.NewsChannelSearchHandler;
import de.justsoftware.onx.searchnew.business.impl.NewsPostSearchHandler;
import de.justsoftware.onx.searchnew.business.impl.SearchFacetContainsIsApplicableVisitor;
import de.justsoftware.onx.searchnew.business.impl.SearchResultFacetCountsExtractor;
import de.justsoftware.onx.searchnew.business.impl.SearchTermParser;
import de.justsoftware.onx.searchnew.business.impl.SolrQueryBuilder;
import de.justsoftware.onx.searchnew.business.impl.SolrRequestException;
import de.justsoftware.onx.searchnew.business.impl.ToSolrFacetVisitor;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.business.model.SearchIndexType;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import de.justsoftware.onx.searchnew.shared.model.CompoundIdStringUtil;
import de.justsoftware.onx.searchnew.shared.model.CustomSearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.DelegatingSearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.EntityFilterType;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeCountType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.InvalidSearchFieldException;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchContextModel;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetContainsParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.SimpleSearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SuggestModel;
import de.justsoftware.onx.searchnew.shared.model.SupportsSuggestFilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.server.model.DynamicEntityAttributeSearchFieldModel;
import de.justsoftware.onx.searchnew.shared.server.model.DynamicSearchFieldModel;
import de.justsoftware.onx.searchnew.shared.server.model.MultiWikiSearchFieldModel;
import de.justsoftware.onx.searchnew.shared.server.model.SearchTermModel;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonSearchServiceImpl
extends AbstractSearchService
implements CommonSearchTestService,
EntityParentsServiceForTest {
    private static final Logger LOG = LoggerFactory.getLogger(CommonSearchServiceImpl.class);
    private static final ImmutableList<SubFilter> NO_SUB_FILTER = ImmutableList.of();
    private int _suggestFacetCount = 100;
    @Autowired
    private PersonSearchHandler _personSearchHandler;
    @Autowired
    private EntitySearchHandler _entitySearchHandler;
    @Autowired
    private WorkstreamSearchHandler _workstreamSearchHandler;
    @Autowired
    private NewsPostSearchHandler _newsPostSearchHandler;
    @Autowired
    private NewsChannelSearchHandler _newsChannelSearchHandler;
    @Autowired
    private ConversationSearchHandler _conversationSearchHandler;
    @Autowired
    private ChatSearchHandler _chatSearchHandler;
    @Autowired
    private DriveDocumentSearchHandler _driveDocumentSearchHandler;
    @Autowired
    private AuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private ProfileReadDataService _profileReadDataService;
    @Autowired
    private SearchDataService _searchDataService;
    @Autowired
    private LearnToRankService _learnToRankService;
    @Autowired
    private WikiSearchHandler _wikiSearchHandler;
    @Autowired
    private ChapterSearchHandler _chapterSearchHandler;
    @Autowired
    private ArticleSearchHandler _articleSearchHandler;

    private void appendVisibilitiesFilter(@Nonnull SolrQuery query, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        query.add("jucoRoles", new String[]{Joiner.on((String)" ").skipNulls().join(authorizationContext.getStaticUserRolesForSearchQuery())});
        PersonId personId = authorizationContext.getUserId();
        Criterion roleFQ = this.createVisibiltiyCriterion("visible_for_roles", "jucoRoles");
        query.add("jucoPersonIds", new String[]{personId.toString()});
        query.addFilterQuery(new String[]{Restrictions.or(roleFQ, this.createVisibiltiyCriterion("visible_for_persons", "jucoPersonIds")).toSolrQuery()});
    }

    private void appendFieldList(@Nonnull SolrQuery query, @Nullable String searchString, @Nullable String featureStoreName, boolean extractLTRFeatures, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        StringBuilder ltrFeaturesBuilder = new StringBuilder();
        PersonId userId = authorizationContext.getUserId();
        if (extractLTRFeatures && featureStoreName != null) {
            ImmutableMap<String, String> efi = this._learnToRankService.getExternalFeatureInformation(userId, (String)MoreObjects.firstNonNull((Object)((String)SolrQueryBuilder.ESCAPE_QUERY_CHARS.apply((Object)searchString)), (Object)""));
            ltrFeaturesBuilder.append(" [features store=").append(featureStoreName);
            for (Map.Entry e : efi.entrySet()) {
                ltrFeaturesBuilder.append(" efi.").append((String)e.getKey()).append("=\"").append((String)e.getValue()).append("\"");
            }
            ltrFeaturesBuilder.append("]");
        }
        query.add("fl", new String[]{"* score" + ltrFeaturesBuilder.toString()});
    }

    private void appendLTRRerankQuery(@Nonnull SolrQuery query, @Nullable String searchString, @Nullable String modelName, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        PersonId userId = authorizationContext.getUserId();
        if (modelName == null) {
            return;
        }
        ImmutableMap<String, String> efi = this._learnToRankService.getExternalFeatureInformation(userId, (String)MoreObjects.firstNonNull((Object)((String)SolrQueryBuilder.ESCAPE_QUERY_CHARS.apply((Object)searchString)), (Object)""));
        StringBuilder rqParams = new StringBuilder();
        rqParams.append("{!ltr model=\"").append(modelName).append("\" reRankDocs=").append(this._settings.getLearnToRankReRankDocCount());
        for (Map.Entry e : efi.entrySet()) {
            rqParams.append(" efi.").append((String)e.getKey()).append("=\"").append((String)e.getValue()).append("\"");
        }
        rqParams.append("}");
        query.add("rq", new String[]{rqParams.toString()});
    }

    private Criterion createVisibiltiyCriterion(@Nonnull String visibiltityField, @Nonnull String valueParam) {
        LocalParamCriterion localParamCriterion = new LocalParamCriterion("edismax", "$" + valueParam, true);
        localParamCriterion.addLocalParam(new LocalParam("q.op", "OR"));
        localParamCriterion.addLocalParam(new LocalParam("qf", visibiltityField));
        localParamCriterion.addLocalParam(new LocalParam("mm", "1"));
        return Restrictions.eq("_query_", "\"" + localParamCriterion.toSolrQuery() + "\"");
    }

    protected static void appendFilterTypeFilter(@Nonnull SolrQuery params, @Nullable Iterable<? extends FilterType> selectedFilter) {
        FilterQueryCriteria filterTypeFilterQuery = SolrQueryBuilder.createFilterTypeFilterQuery(selectedFilter, "type");
        if (filterTypeFilterQuery != null) {
            params.addFilterQuery(new String[]{filterTypeFilterQuery.toSolrQuery()});
        }
    }

    protected void appendSortCriteria(@Nonnull SolrQuery query, @Nullable SortType sortType) {
        if (sortType != null) {
            query.add("sort", new String[]{sortType.getSortCriteria()});
        }
    }

    @Override
    protected SearchResult<CommonSearchResultModel> jucoSearch(String searchString, Set<? extends FilterType> selectedFilter, SortType sortType, SearchContextModel searchContext, Iterable<? extends SubFilter> additionalFilter, SearchFacetParameters searchFacetParameters, int offset, int numberOfResults, SearchAuthorizationCheckContext authorizationContext, boolean isNavigatorSearch, EntityType navigatorRootEntityType, AbstractSearchService.LTRParams ltrParams) {
        if (this.checkContextInvalid(searchContext, authorizationContext)) {
            return SearchResult.empty();
        }
        String escapedSearchString = this.escapeRegExSearchString(searchString);
        this.checkSearchString(escapedSearchString, authorizationContext);
        SolrQuery query = new SolrQuery();
        if (!StringUtils.isBlank((String)escapedSearchString)) {
            this.setHighlightedAndQueryFields(escapedSearchString, query, authorizationContext);
            query.setQuery(escapedSearchString);
        } else {
            query.setHighlight(false);
        }
        query.setRequestHandler("jucoSearch");
        this.appendSortCriteria(query, sortType);
        this.appendSearchContextFilter(query, searchContext, authorizationContext);
        Set<? extends FilterType> availableSelectedFilter = this.getAvailableFilterTypes(selectedFilter, isNavigatorSearch, navigatorRootEntityType);
        if (availableSelectedFilter.isEmpty() && !selectedFilter.isEmpty()) {
            return SearchResult.empty();
        }
        this.appendSubFilterQuery(query, additionalFilter);
        CommonSearchServiceImpl.appendFilterTypeFilter(query, availableSelectedFilter);
        this.appendVisibilitiesFilter(query, authorizationContext);
        this.appendFieldList(query, escapedSearchString, ltrParams.getFeatureStoreName(), ltrParams.isExtractLTRFeatures(), authorizationContext);
        if (ltrParams.isUseLTRReRank()) {
            String modelName = this._ltrSearchConfiguration.getJustSearchModelStoreName();
            this.appendLTRRerankQuery(query, escapedSearchString, modelName, authorizationContext);
        }
        ImmutableSet<SearchFacet> searchFacets = this.addFacets(query, searchFacetParameters, searchContext, additionalFilter, availableSelectedFilter, authorizationContext.getUserId(), isNavigatorSearch, this.getAllowedFilterTypes(isNavigatorSearch, navigatorRootEntityType), new DelegatingSearchConfigurationProvider(this._searchConfigurationProvider));
        return this.toSearchResult(this.executePagingQuery((ModifiableSolrParams)query, offset, numberOfResults), true, searchFacets, additionalFilter, searchFacetParameters.accept(ExtractHighlightingSearchStringVisitor.INSTANCE), authorizationContext);
    }

    private void checkSearchString(@Nullable String searchString, @Nonnull SearchAuthorizationCheckContext authContext) throws InvalidSearchFieldException {
        if (!StringUtil.isBlank(searchString)) {
            Collection<SearchTermModel> searchTerms = SearchTermParser.parseSearchTerm(searchString, this._entityConfigService.getSearchableDynamicAttributes());
            if (searchTerms == null) {
                return;
            }
            FluentIterable searchFields = FluentIterable.from(searchTerms).transform(SearchTermModel.TO_SEARCH_FIELD).filter(Predicates.notNull()).transform(SearchField.TO_FIELD_NAME);
            if (searchFields.isEmpty()) {
                ImmutableSet allowedSearchableFieldsByUser = FluentIterable.from(this.getVisibleSearchFieldForCurrentUser(authContext)).filter(SearchField.FILTER_SEARCHABLE_FIELD).transform(SearchField.TO_FIELD_NAME).toSet();
                for (String searchField : searchFields) {
                    if (allowedSearchableFieldsByUser.contains((Object)searchField)) continue;
                    throw new InvalidSearchFieldException(searchField);
                }
            }
        }
    }

    @Nonnull
    private ImmutableSet<SearchFacet> addFacets(@Nonnull SolrQuery query, @Nonnull SearchFacetParameters searchFacetParameters, @Nullable SearchContextModel searchContext, @Nullable Iterable<? extends SubFilter> subfilter, @Nonnull Set<? extends FilterType> availableSelectedFilterTypes, @Nullable PersonId currentUserId, boolean isNavigatorSearch, @Nullable Set<? extends FilterType> navigatorAllowedFilterTypes, @Nonnull SearchConfigurationProvider searchConfigurationProvider) {
        return searchFacetParameters.accept(new SearchFacetParametersToFacetsVisitor(availableSelectedFilterTypes, query, subfilter, currentUserId, searchContext, searchConfigurationProvider, isNavigatorSearch, navigatorAllowedFilterTypes));
    }

    @Nonnull
    private ImmutableList<SearchField> getVisibleSearchFieldForCurrentUser(@Nonnull SearchAuthorizationCheckContext authorizationContext) {
        ImmutableList.Builder result = ImmutableList.builder();
        result.add((Object[])CommonSearchFields.values());
        result.addAll(MultiWikiSearchFieldModel.createMultiwikiSearchFields(authorizationContext.getStaticUserRolesForSearchQuery()));
        ImmutableSetMultimap<EntityType, DynamicAttributeConfig> searchableEntityAttributes = this._entityConfigService.getSearchableDynamicAttributes();
        if (searchableEntityAttributes != null) {
            for (Map.Entry entityAttribute : searchableEntityAttributes.entries()) {
                result.add((Object)new DynamicEntityAttributeSearchFieldModel(((DynamicAttributeConfig)entityAttribute.getValue()).getId(), (EntityType)entityAttribute.getKey()));
            }
        }
        ProfileAttributesConfiguration config = this._profileReadDataService.getAttributesConfiguration();
        for (ProfileAttributeConfiguration attribute : config.getAllAttributeConfigurations()) {
            if (!ProfileAttributeSearchType.isSearchable(attribute)) continue;
            result.add((Object)new DynamicSearchFieldModel(attribute.getName()));
        }
        return result.build();
    }

    private void setHighlightedAndQueryFields(@Nonnull String searchQuery, @Nonnull SolrQuery query, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        Collection<SearchTermModel> searchTerms = SearchTermParser.parseSearchTerm(searchQuery, this._entityConfigService.getSearchableDynamicAttributes());
        boolean searchOverAllFields = false;
        HashSet<String> searchFields = new HashSet<String>();
        if (searchTerms != null) {
            for (SearchTermModel term : searchTerms) {
                SearchField fieldName = term.getFieldName();
                if (fieldName == null) {
                    searchOverAllFields = true;
                    break;
                }
                searchFields.add(fieldName.getFieldName());
                if (!CommonSearchFields.NAME.equals(fieldName)) continue;
                searchFields.add(CommonSearchFields.NAME_SUBSTRING.getFieldName());
            }
        }
        ImmutableList.Builder queryField = ImmutableList.builder();
        for (SearchField visibleSearchField : this.getVisibleSearchFieldForCurrentUser(authorizationContext)) {
            if (!visibleSearchField.isQueryField()) continue;
            queryField.add((Object)(visibleSearchField.getFieldName() + "^" + visibleSearchField.getBoostFactor()));
            if (!searchOverAllFields && !searchFields.contains(visibleSearchField.getFieldName())) continue;
            query.addHighlightField(visibleSearchField.getFieldName());
        }
        query.add("qf", new String[]{Joiner.on((char)' ').join((Iterable)queryField.build())});
    }

    private boolean checkContextInvalid(@Nullable SearchContextModel context, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        return context != null && context.getSelectedContext().equals((Object)SearchContext.SUBSCRIPTION) && !this.isContextProfileOwnProfile(context, authorizationContext);
    }

    private boolean isContextProfileOwnProfile(@Nonnull SearchContextModel context, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        ProfileId contextProfileId = context.getContextProfileId();
        return contextProfileId == null || contextProfileId.asPersonId().equals(authorizationContext.getUserId());
    }

    private void appendSearchContextFilter(@Nonnull SolrQuery query, @Nullable SearchContextModel searchContextModel, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        if (searchContextModel == null) {
            return;
        }
        SearchContext selectedContext = searchContextModel.getSelectedContext();
        String searchContextExcludeName = "context";
        switch (selectedContext) {
            case ENTIRE_PLATFORM: {
                return;
            }
            case ENTITY: {
                this.appendFilterForEntitiesWithParentField(query, searchContextModel.getContextEntityId(), true, false, "context");
                return;
            }
            case ENTITY_AND_SUBENTITIES: {
                this.appendFilterForEntitiesWithParentField(query, searchContextModel.getContextEntityId(), false, false, "context");
                return;
            }
            case MY_CONTENT: {
                this.appendFilterForMyContent((ModifiableSolrParams)query, this.isContextProfileOwnProfile(searchContextModel, authorizationContext) ? "my_content_person_ids" : "user_content_person_ids", searchContextModel, authorizationContext, "context");
                return;
            }
            case ADMIN: {
                this.appendFilterForMyContent((ModifiableSolrParams)query, "admin_ids", searchContextModel, authorizationContext, "context");
                return;
            }
            case MEMBER: {
                this.appendFilterForMyContent((ModifiableSolrParams)query, "member_ids", searchContextModel, authorizationContext, "context");
                return;
            }
            case SUBSCRIPTION: {
                if (this.checkContextInvalid(searchContextModel, authorizationContext)) {
                    throw new PermissionDeniedException("You are not allowed to search subscriptions of another user.");
                }
                this.appendFilterForMyContent((ModifiableSolrParams)query, "subscriber_ids", searchContextModel, authorizationContext, "context");
                return;
            }
        }
        throw new UnsupportedOperationException("no behavior for " + selectedContext + " defined!");
    }

    private void appendFilterForMyContent(@Nonnull ModifiableSolrParams params, @Nonnull String field, @Nonnull SearchContextModel searchContextModel, @Nonnull SearchAuthorizationCheckContext authorizationContext, @Nullable String searchContextExcludeName) {
        ProfileId profileContextId = searchContextModel.getContextProfileId();
        PersonId personId = profileContextId != null ? profileContextId.asPersonId() : authorizationContext.getUserId();
        FilterQueryCriteria fq = new FilterQueryCriteria();
        if (searchContextExcludeName != null) {
            fq.addLocalParam(new LocalParam("tag", searchContextExcludeName));
        }
        fq.add(Restrictions.eq(field, CompoundId.of(personId).toSearchString()));
        params.add(fq.getParameterName(), new String[]{fq.toSolrQuery()});
    }

    private void appendFilterForEntitiesWithParentField(@Nonnull SolrQuery query, @Nullable EntityId selectedEntity, boolean returnDirectChildren, boolean includeSelectedEntityId, @Nullable String searchContextExcludeName) {
        this.appendFilterForEntitiesWithParentField(query, (Iterable<EntityId>)(selectedEntity != null ? ImmutableSet.of((Object)selectedEntity) : ImmutableSet.of()), returnDirectChildren, includeSelectedEntityId, searchContextExcludeName);
    }

    private void appendFilterForEntitiesWithParentField(@Nonnull SolrQuery query, @Nonnull Iterable<EntityId> entityIds, boolean returnDirectChildren, boolean includeSelectedEntityId, @Nullable String searchContextExcludeName) {
        if (CollectionUtil.isEmpty(entityIds)) {
            return;
        }
        FilterQueryCriteria fq = this.createFilterForEntitiesWithParentField(entityIds, returnDirectChildren, includeSelectedEntityId, searchContextExcludeName);
        query.addFilterQuery(new String[]{fq.toSolrQuery()});
    }

    @Nonnull
    private FilterQueryCriteria createFilterForEntitiesWithParentField(@Nonnull Iterable<EntityId> entityIds, boolean returnDirectChildren, boolean includeSelectedEntityId, @Nullable String searchContextExcludeName) {
        Preconditions.checkArgument((!CollectionUtil.isEmpty(entityIds) ? 1 : 0) != 0, (Object)"Parameter entityIds must not be empty");
        FilterQueryCriteria fq = new FilterQueryCriteria();
        if (searchContextExcludeName != null) {
            fq.addLocalParam(new LocalParam("tag", searchContextExcludeName));
        }
        String parentIdFieldName = returnDirectChildren ? "direct_parent_ids" : "parent_ids";
        OrExpression or = Restrictions.or(new Criterion[0]);
        for (EntityId selectedEntity : entityIds) {
            or.add(Restrictions.eq(parentIdFieldName, selectedEntity.asString()));
            if (!includeSelectedEntityId) continue;
            or.add(Restrictions.eq("id", selectedEntity.asString()));
        }
        fq.add(or);
        return fq;
    }

    @Override
    protected SearchResult<FederatedSearchResultEntry> convert(SearchResult<CommonSearchResultModel> searchResult, SearchContextModel searchContextModel, boolean isNavigatorSearch, @Nullable EntityType navigatorRootEntityType, SearchAuthorizationCheckContext authorizationContext) {
        if (searchResult == null) {
            return SearchResult.empty();
        }
        ImmutableList<FederatedSearchResultEntry> results = this.createSearchResultBadges((Collection<CommonSearchResultModel>)searchResult.getResults(), searchContextModel, isNavigatorSearch, navigatorRootEntityType, authorizationContext);
        return new SearchResult<FederatedSearchResultEntry>(searchResult.getNumberOfResults(), results, searchResult.getFilterCount(), searchResult.getFacetCounts());
    }

    @Override
    protected SearchResult<FederatedSearchResultEntry> convertFederated(SearchResult<CommonSearchResultModel> searchResult, SearchContextModel searchContextModel, boolean isNavigatorSearch, @Nullable EntityType navigatorRootEntityType, SearchAuthorizationCheckContext authorizationContext) {
        return this.convert(searchResult, searchContextModel, isNavigatorSearch, navigatorRootEntityType, authorizationContext);
    }

    @Nonnull
    protected ImmutableList<FederatedSearchResultEntry> createSearchResultBadges(@Nullable Collection<CommonSearchResultModel> searchResult, @Nullable SearchContextModel searchContextModel, boolean isNavigatorSearch, @Nullable EntityType navigatorRootEntityType, @Nonnull SearchAuthorizationCheckContext authCtx) {
        if (CollectionUtils.isEmpty(searchResult)) {
            return ImmutableList.of();
        }
        CommonSearchResultModelByTypeCollector collector = new CommonSearchResultModelByTypeCollector(searchResult);
        ImmutableMap.Builder resultsBuilder = ImmutableMap.builder();
        resultsBuilder.putAll(this._personSearchHandler.createSearchResultBadgeModel(collector._profiles, searchContextModel, authCtx));
        resultsBuilder.putAll(this._entitySearchHandler.createSearchResultBadgeModel(collector._entities, isNavigatorSearch, navigatorRootEntityType, authCtx));
        resultsBuilder.putAll(this._newsPostSearchHandler.createSearchResultBadgeModel(collector._newsPosts));
        resultsBuilder.putAll(this._newsChannelSearchHandler.createSearchResultBadgeModel(collector._newsChannels));
        resultsBuilder.putAll(this._workstreamSearchHandler.createSearchResultBadgeModel(collector._workstreamMessages, authCtx));
        resultsBuilder.putAll(this._conversationSearchHandler.createSearchResultBadgeModel(collector._conversations, authCtx));
        resultsBuilder.putAll(this._chatSearchHandler.createSearchResultBadgeModel(collector._chats, authCtx));
        resultsBuilder.putAll(this._driveDocumentSearchHandler.createSearchResultBadgeModel(collector._driveDocuments, authCtx));
        resultsBuilder.putAll(this._wikiSearchHandler.createSearchResultBadgeModel(collector._wikis, authCtx));
        resultsBuilder.putAll(this._chapterSearchHandler.createSearchResultBadgeModel(collector._chapters, authCtx));
        resultsBuilder.putAll(this._articleSearchHandler.createSearchResultBadgeModel(collector._articles, authCtx));
        Function byCompoundId = Functions.forMap((Map)resultsBuilder.build(), null);
        Iterable unfilteredResult = Iterables.transform(searchResult, (Function)Functions.compose((Function)byCompoundId, CompoundId.FROM_COMMON_SEARCH_MODEL));
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)unfilteredResult, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    private ImmutableList<SuggestModel<?, ?>> createSearchSuggestModel(@Nullable Collection<CommonSearchResultModel> searchResult, @Nonnull AuthorizationCheckContextWithUserId authCtx) {
        if (CollectionUtils.isEmpty(searchResult)) {
            return ImmutableList.of();
        }
        CommonSearchResultModelByTypeCollector collector = new CommonSearchResultModelByTypeCollector(searchResult);
        ImmutableMap.Builder resultsBuilder = ImmutableMap.builder();
        resultsBuilder.putAll(this._personSearchHandler.createSearchResultSuggestModel(collector._profiles, authCtx));
        resultsBuilder.putAll(this._entitySearchHandler.createSearchResultSuggestModel(collector._entities, authCtx));
        resultsBuilder.putAll(this._newsPostSearchHandler.createSearchResultSuggestModel(collector._newsPosts));
        resultsBuilder.putAll(this._newsChannelSearchHandler.createSearchResultSuggestModel(collector._newsChannels));
        resultsBuilder.putAll(this._workstreamSearchHandler.createSearchResultSuggestModel(collector._workstreamMessages, authCtx));
        resultsBuilder.putAll(this._conversationSearchHandler.createSearchResultSuggestModel(collector._conversations, authCtx));
        resultsBuilder.putAll(this._chatSearchHandler.createSearchResultSuggestModel(collector._chats, authCtx));
        resultsBuilder.putAll(this._driveDocumentSearchHandler.createSearchResultSuggestModel(collector._driveDocuments, authCtx));
        resultsBuilder.putAll(this._wikiSearchHandler.createSearchResultSuggestModel(collector._wikis, authCtx));
        resultsBuilder.putAll(this._chapterSearchHandler.createSearchResultSuggestModel(collector._chapters, authCtx));
        resultsBuilder.putAll(this._articleSearchHandler.createSearchResultSuggestModel(collector._articles, authCtx));
        Function byCompoundId = Functions.forMap((Map)resultsBuilder.build(), null);
        Iterable unfilteredResult = Iterables.transform(searchResult, (Function)Functions.compose((Function)byCompoundId, CompoundId.FROM_COMMON_SEARCH_MODEL));
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)unfilteredResult, (Predicate)Predicates.notNull()));
    }

    @Override
    public Collection<EntityId> getChildrenIds(EntityId entityId, Iterable<EntityType> entityTypes, boolean returnDirectChildren, SortType sortType) {
        if (Iterables.isEmpty(entityTypes)) {
            return ImmutableSet.of();
        }
        CommonSearchFields idField = CommonSearchFields.ID;
        SolrQuery params = this.createChildrenIdQuery((Iterable<EntityId>)ImmutableSet.of((Object)entityId), entityTypes, returnDirectChildren, sortType, null, idField);
        QueryResponse response = this.executePagingQuery((ModifiableSolrParams)params, 0, Integer.MAX_VALUE);
        return this.convertQueryResponseToListAndCount(response, idField, new CompoundIdExtractor());
    }

    @Override
    public ListAndCount<EntityId> getVisibleChildrenIds(SearchAuthorizationCheckContext authorizationContext, EntityId entityId, Iterable<EntityType> entityTypes, int offset, int numberOfResults, SortType sortType, Iterable<? extends SubFilter> subFilter) {
        if (Iterables.isEmpty(entityTypes)) {
            return new ListAndCount<EntityId>();
        }
        CommonSearchFields idField = CommonSearchFields.ID;
        SolrQuery query = this.createChildrenIdQuery((Iterable<EntityId>)ImmutableSet.of((Object)entityId), entityTypes, true, sortType, subFilter, idField);
        this.appendVisibilitiesFilter(query, authorizationContext);
        QueryResponse response = this.executePagingQuery((ModifiableSolrParams)query, offset, numberOfResults);
        return this.convertQueryResponseToListAndCount(response, idField, new CompoundIdExtractor());
    }

    @Override
    public boolean isSearchFacetContainsSupported(SearchFacet facet) {
        Boolean facetContainsSupported = facet.accept(new SearchFacetContainsIsApplicableVisitor(new SearchFacetContainsIsApplicableVisitor.FacetDataAccessor(){

            @Override
            public Optional<DynamicAttributeConfig> getEntityDynamicAttributeConfig(EntityType entityType, DynamicAttributeId entityAttributeId) {
                return FluentIterable.from(CommonSearchServiceImpl.this._entityConfigService.getFacettableDynamicAttributesForType(entityType)).firstMatch(Identifiables.idEquals(entityAttributeId));
            }

            @Override
            public Optional<ProfileAttributeConfiguration> getProfileAttributeConfig(String attributeName) {
                return Optional.fromNullable((Object)CommonSearchServiceImpl.this._profileReadDataService.getAttributesConfiguration().getAttributeByName(attributeName));
            }
        }));
        return BooleanUtils.isTrue((Boolean)facetContainsSupported);
    }

    @Nonnull
    protected ListAndCount<EntityId> convertQueryResponseToListAndCount(@Nullable QueryResponse response, @Nonnull SearchField idField, @Nonnull Function<Object, Long> getValueFunction) {
        if (response == null || response.getResults() == null) {
            return ListAndCount.emptyListAndCount();
        }
        ListAndCount<EntityId> result = new ListAndCount<EntityId>();
        result.setMaxCount(Long.valueOf(response.getResults().getNumFound()).intValue());
        result.addAll(this.convertToIds(response, idField, getValueFunction));
        return result;
    }

    @Nonnull
    private ImmutableSet<EntityId> convertToIds(@Nonnull QueryResponse response, @Nonnull SearchField idField, @Nonnull Function<Object, Long> getValueFunction) {
        SolrDocumentList documentList = response.getResults();
        if (documentList == null || documentList.getNumFound() <= 0L) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (SolrDocument document : documentList) {
            Long id = (Long)getValueFunction.apply(document.getFieldValue(idField.getFieldName()));
            EntityId entityId = EntityId.valueOf(id);
            if (entityId == null) continue;
            result.add((Object)entityId);
        }
        return result.build();
    }

    private SolrQuery createChildrenIdQuery(@Nonnull Iterable<EntityId> entityId, @Nonnull Iterable<EntityType> entityTypes, boolean returnDirectChildren, @Nullable SortType sortType, @Nullable Iterable<? extends SubFilter> subFilter, SearchField ... returnFields) {
        SolrQuery params = new SolrQuery();
        this.addReturnFields(params, returnFields);
        params.add("qt", new String[]{"jucoSearch"});
        this.appendFilterForEntitiesWithParentField(params, entityId, returnDirectChildren, false, null);
        this.appendSortCriteria(params, sortType);
        params.add("fq", new String[]{Restrictions.eq("type", entityTypes, Type.TO_NAME).toSolrQuery()});
        this.appendSubFilterQuery(params, subFilter);
        return params;
    }

    private void addReturnFields(@Nonnull SolrQuery query, SearchField ... returnFields) {
        if (returnFields.length > 0) {
            query.setFields((String[])Iterators.toArray((Iterator)Iterators.transform((Iterator)Iterators.forArray((Object[])returnFields), SearchField.TO_FIELD_NAME), String.class));
        } else {
            LOG.warn("No return fields specified!");
        }
    }

    @Nonnull
    private String escapeSuggestQuery(@Nonnull String query) {
        return FluentIterable.from((Object[])query.split(" ")).transform(SolrQueryBuilder.ESCAPE_QUERY_CHARS).filter(Predicates.notNull()).join(Joiner.on((String)" "));
    }

    @Nullable
    private String escapeRegExSearchString(@Nullable String searchString) {
        if (searchString == null) {
            return null;
        }
        return searchString.replaceAll("\\/", " ");
    }

    @Override
    protected QueryResponse querySuggestedElements(String searchString, @Nullable SearchContextModel searchContext, ImmutableSet<? extends FilterType> selectedFilters, @Nullable SortType sortType, @Nullable Collection<SubFilter> additionalFilter, int offset, int numberOfResults, boolean useLTRReRank, SearchAuthorizationCheckContext authorizationContext) {
        if (this.checkContextInvalid(searchContext, authorizationContext)) {
            return this.createEmptyQueryResponse();
        }
        SolrQuery query = new SolrQuery();
        if (!StringUtils.isBlank((String)searchString)) {
            query.setQuery(this.escapeSuggestQuery(searchString));
        }
        query.setRequestHandler("suggest");
        query.add("qf", new String[]{this._settings.getSuggestSearchQueryFields()});
        this.appendSearchContextFilter(query, searchContext, authorizationContext);
        this.appendVisibilitiesFilter(query, authorizationContext);
        this.appendSortCriteria(query, sortType);
        this.appendSubFilterQuery(query, additionalFilter);
        Set<? extends FilterType> filterTypes = this.getAvailableSuggestFilterTypes((Set<? extends FilterType>)selectedFilters);
        if (!CollectionUtil.isEmpty(selectedFilters) && filterTypes.isEmpty()) {
            return this.createEmptyQueryResponse();
        }
        CommonSearchServiceImpl.appendFilterTypeFilter(query, filterTypes);
        if (useLTRReRank) {
            String modelName = this._ltrSearchConfiguration.getJustSearchModelStoreName();
            this.appendLTRRerankQuery(query, searchString, modelName, authorizationContext);
        }
        query.setHighlight(true);
        return this.executePagingQuery((ModifiableSolrParams)query, offset, numberOfResults);
    }

    @Nonnull
    private Set<? extends FilterType> getAvailableSuggestFilterTypes(@Nullable Set<? extends FilterType> selectedFilters) {
        if (selectedFilters == null) {
            return ImmutableSet.of();
        }
        return Sets.filter(this.replaceFilterTypeALL(selectedFilters), (Predicate)SupportsSuggestFilterTypeVisitor.INSTANCE);
    }

    @Nonnull
    private Set<? extends FilterType> replaceFilterTypeALL(@Nonnull Set<? extends FilterType> filterTypes) {
        if (!filterTypes.contains(StaticFilterType.ALL)) {
            return filterTypes;
        }
        HashSet<? extends FilterType> result = new HashSet<FilterType>(filterTypes);
        result.addAll((Collection<? extends FilterType>)this._filterConfiguration.getOrderedFilterTypes());
        result.remove(StaticFilterType.ALL);
        return result;
    }

    @Override
    protected ImmutableList<SuggestModel<?, ?>> getSuggestModels(Collection<CommonSearchResultModel> searchResultBeans, AuthorizationCheckContextWithUserId authContext) {
        if (searchResultBeans == null) {
            return ImmutableList.of();
        }
        return this.createSearchSuggestModel(searchResultBeans, authContext);
    }

    @Override
    public ImmutableSet<ItemId> getChildrenOfEntities(boolean directChildren, Iterable<ItemType> itemTypes, Set<EntityId> parentIds, Criterion additionalCriterion) {
        if (parentIds.isEmpty()) {
            return ImmutableSet.of();
        }
        HashSet filterTypes = Sets.newHashSet();
        for (ItemType type : itemTypes) {
            if (type == null) continue;
            filterTypes.addAll((Collection)type.accept(new ItemTypeToFilterTypesMapper(this)));
        }
        if (filterTypes.isEmpty()) {
            return ImmutableSet.of();
        }
        return this.getChildrenOfEntities(directChildren, filterTypes, parentIds, additionalCriterion);
    }

    @Nonnull
    private ImmutableSet<ItemId> getChildrenOfEntities(boolean directChildren, @Nonnull Set<FilterType> filterTypes, @Nonnull Set<EntityId> parentIds, @Nullable Criterion additionalCriterion) {
        OrExpression childTypeExpression = Restrictions.or(new Criterion[0]);
        for (FilterType filterType : filterTypes) {
            childTypeExpression.add(Restrictions.eq("type", filterType.getType().name()));
        }
        String parentIdsField = directChildren ? CommonSearchFields.DIRECT_PARENT_IDS.getFieldName() : CommonSearchFields.PARENT_IDS.getFieldName();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (List chunk : Iterables.partition(parentIds, (int)100)) {
            SolrQuery query = new SolrQuery();
            query.setRequestHandler("standard");
            OrExpression parentsIdExpression = Restrictions.or(new Criterion[0]);
            AndExpression expression = Restrictions.and(childTypeExpression, parentsIdExpression);
            for (EntityId parentId : chunk) {
                parentsIdExpression.add(Restrictions.eq(parentIdsField, parentId.asString()));
            }
            if (additionalCriterion != null) {
                expression.add(additionalCriterion);
            }
            query.setQuery(expression.toSolrQuery());
            QueryResponse response = this.executePagingQuery((ModifiableSolrParams)query, 0, Integer.MAX_VALUE);
            if (response.getResponse() == null) continue;
            List children = response.getBeans(CommonSearchResultModel.class);
            for (CommonSearchResultModel child : children) {
                builder.add((Object)CompoundId.of(child).toItemId());
            }
        }
        return builder.build();
    }

    @Override
    public ImmutableList<CommonSearchResultModel> queryByIds(Set<? extends GlobalId> ids) {
        if (ids.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (Iterable partition : Iterables.partition(ids, (int)100)) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("qt", new String[]{"standard"});
            OrExpression query = Restrictions.or(new Criterion[0]);
            for (GlobalId id : partition) {
                query.add(Restrictions.eq("id", CompoundId.of(id).toSearchString()));
            }
            params.add("q", new String[]{query.toSolrQuery()});
            QueryResponse response = this.executeQuery(params);
            if (response.getResults() == null) continue;
            result.addAll((Iterable)response.getBeans(CommonSearchResultModel.class));
        }
        return result.build();
    }

    protected void addSortingForChildrenIds(ModifiableSolrParams params) {
        params.add("sort", new String[]{CommonSearchFields.START_DATE.getFieldName() + " asc"});
    }

    @Override
    public void updateIndexOf(SetMultimap<SearchableId, SearchIndexType> ids, boolean commit) throws SolrRequestException {
        ImmutableSetMultimap errors;
        ImmutableMap<SearchableId, JucoSolrInputDocument> documents;
        if (ids.isEmpty()) {
            return;
        }
        ImmutableSetMultimap.Builder errorCollector = ImmutableSetMultimap.builder();
        PersonIndependentAuthorizationContext authorizationContext = this._authorizationContextProvider.getPersonIndependentAuthorizationContext();
        try {
            documents = this.addDocuments(ids, (ImmutableSetMultimap.Builder<SearchableId, Exception>)errorCollector, authorizationContext);
        }
        catch (IOException e) {
            throw new SolrRequestException(e);
        }
        try {
            this.delete((Set<? extends SearchableId>)Sets.difference((Set)ids.keySet(), (Set)documents.keySet()), (ImmutableSetMultimap.Builder<SearchableId, Exception>)errorCollector);
        }
        catch (IOException e) {
            throw new SolrRequestException(e);
        }
        if (commit) {
            try {
                this._writeSolrServer.commit(false, true, this._useSoftCommit);
            }
            catch (IOException | SolrServerException | SolrException e) {
                throw new SolrRequestException(e);
            }
        }
        if (!(errors = errorCollector.build()).isEmpty()) {
            throw new SolrRequestException((ImmutableSetMultimap<SearchableId, Exception>)errors);
        }
    }

    @Nonnull
    private ImmutableMap<SearchableId, JucoSolrInputDocument> addDocuments(@Nonnull SetMultimap<SearchableId, SearchIndexType> ids, @Nonnull ImmutableSetMultimap.Builder<SearchableId, Exception> errorCollector, @Nonnull PersonIndependentAuthorizationContext authorizationContext) throws IOException {
        ImmutableMap<SearchableId, JucoSolrInputDocument> documents;
        block7: {
            documents = this._searchDataService.load((Multimap<? extends SearchableId, SearchIndexType>)ids, authorizationContext);
            if (documents.isEmpty()) {
                return ImmutableMap.of();
            }
            try {
                this._writeSolrServer.add(Collections2.transform((Collection)documents.values(), JucoSolrInputDocument.TO_SOLR_INPUT_DOCUMENT));
            }
            catch (SolrServerException | SolrException collectionTry) {
                ImmutableSetMultimap.Builder retryFullIndexBuilder = ImmutableSetMultimap.builder();
                for (Map.Entry document : documents.entrySet()) {
                    SearchableId id = (SearchableId)document.getKey();
                    try {
                        this._writeSolrServer.add(((JucoSolrInputDocument)document.getValue()).getDoc());
                    }
                    catch (SolrServerException | SolrException singleTry) {
                        if (!ids.get((Object)id).contains((Object)SearchIndexType.ALL) && IsFullIndexable.isFullIndexable(id)) {
                            retryFullIndexBuilder.put((Object)id, (Object)SearchIndexType.ALL);
                            continue;
                        }
                        errorCollector.put((Object)id, (Object)singleTry);
                    }
                }
                ImmutableSetMultimap retryFullIndex = retryFullIndexBuilder.build();
                if (retryFullIndex.isEmpty()) break block7;
                this.addDocuments((SetMultimap<SearchableId, SearchIndexType>)retryFullIndex, errorCollector, authorizationContext);
            }
        }
        return documents;
    }

    private void delete(@Nonnull Set<? extends SearchableId> idsToDelete, @Nonnull ImmutableSetMultimap.Builder<SearchableId, Exception> errorCollector) throws IOException {
        FluentIterable deletableIds = FluentIterable.from(idsToDelete).filter(IsFullIndexable::isFullIndexable);
        if (deletableIds.isEmpty()) {
            return;
        }
        try {
            this._writeSolrServer.deleteById((List)deletableIds.transform(CompoundId::ofSearchableId).transform(CompoundId::toSearchString).toList());
        }
        catch (SolrServerException | SolrException e) {
            for (SearchableId delete : deletableIds) {
                try {
                    this._writeSolrServer.deleteById(CompoundId.ofSearchableId(delete).toSearchString());
                }
                catch (SolrServerException e1) {
                    errorCollector.put((Object)delete, (Object)e1);
                }
            }
        }
    }

    @Override
    public ImmutableSet<FilterType> getAllEntityFilterTypes() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this._entityConfigService.getOrderedEntityTypes(), FilterTypes.GET_BY_TYPE));
    }

    @Override
    public ImmutableSet<FilterType> getAllFilterTypes() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        result.add((Object[])StaticFilterType.values());
        result.addAll(this.getAllEntityFilterTypes());
        return result.build();
    }

    @Override
    public void setFilterConfiguration(FilterConfiguration filterConfiguration) {
        this._filterConfiguration = filterConfiguration;
    }

    @Override
    public ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> getVisibleChildrenCounts(SearchAuthorizationCheckContext authorizationContext, Iterable<EntityId> parentIds) {
        SolrQuery query = new SolrQuery();
        query.setFields(new String[]{CommonSearchFields.ID.getFieldName()});
        query.setRequestHandler("jucoSearch");
        this.appendFilterForEntitiesWithParentField(query, parentIds, true, false, null);
        this.appendSubFilterQuery(query, (Iterable<? extends SubFilter>)ImmutableSet.of((Object)ArchiveSubFilter.NON_ARCHIVED));
        this.appendVisibilitiesFilter(query, authorizationContext);
        SolrQueryBuilder.addFacetFields(query, CommonSearchFields.TYPE.getFieldName());
        ImmutableSet<FilterType> filterTypes = this._filterConfiguration.getOrderedFilterTypes();
        ImmutableSet<SearchFacet> searchFacets = this.toSearchFacets((Set<FilterType>)filterTypes, null);
        this.addFacets(query, new CustomSearchFacetParameters(searchFacets), null, (Iterable<? extends SubFilter>)ImmutableSet.of(), (Set<? extends FilterType>)filterTypes, authorizationContext.getUserId(), false, null, new DelegatingSearchConfigurationProvider(this._searchConfigurationProvider){

            @Override
            public boolean useDefaultArchivedFilterForDocuments() {
                return false;
            }
        });
        return this.getFilterCount(this.extractFacets(this.executePagingQuery((ModifiableSolrParams)query, 0, 0), searchFacets, null, (Optional<String>)Optional.absent(), authorizationContext));
    }

    @Override
    @VisibleForTesting
    public void clearAllData() {
        try {
            this._writeSolrServer.deleteByQuery("*:*");
            this._writeSolrServer.commit(false, true, this._useSoftCommit);
        }
        catch (SolrServerException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ImmutableSet<EntityId> findMyContentChildEntities(EntityId entityId, ImmutableSet<EntityType> entityTypes, SearchAuthorizationCheckContext authorizationContext) {
        if (entityTypes.isEmpty()) {
            return ImmutableSet.of();
        }
        OrExpression filterTypes = Restrictions.or(new Criterion[0]);
        for (EntityType type : entityTypes) {
            filterTypes.add(Restrictions.eq(CommonSearchFields.TYPE.getFieldName(), FilterTypes.getByEntityType(type).getType().name()));
        }
        AndExpression and = Restrictions.and();
        and.add(filterTypes);
        and.add(Restrictions.eq("my_content_person_ids", CompoundId.of(authorizationContext.getUserId()).toSearchString()));
        if (entityId != null) {
            and.add(Restrictions.eq(CommonSearchFields.PARENT_IDS.getFieldName(), CompoundId.of(entityId).toSearchString()));
        }
        SolrQuery query = new SolrQuery();
        query.setRequestHandler("jucoSearch");
        query.setFields(new String[]{CommonSearchFields.ID.getFieldName()});
        query.addFilterQuery(new String[]{and.toSolrQuery()});
        this.appendVisibilitiesFilter(query, authorizationContext);
        QueryResponse children = this.executePagingQuery((ModifiableSolrParams)query, 0, Integer.MAX_VALUE);
        return this.convertToIds(children, CommonSearchFields.ID, new CompoundIdExtractor());
    }

    @Override
    public ImmutableMap<EntityId, Long> getVisibleChildrenCountsMappedByEntityId(SearchAuthorizationCheckContext authorizationContext, Set<EntityType> entityTypes, Set<EntityId> parentIds, boolean direct) {
        ImmutableSet filterTypes = FluentIterable.from(entityTypes).transform(EntityFilterType.FROM_ENTITY_TYPE).toSet();
        return this.getVisibleChildrenCountsMappedByEntityId(authorizationContext, parentIds, direct, (Set<FilterType>)filterTypes, (Iterable<? extends SubFilter>)NO_SUB_FILTER);
    }

    @Override
    public ImmutableMap<EntityId, Long> getVisibleChildrenCountsMappedByEntityId(SearchAuthorizationCheckContext authorizationContext, Set<EntityId> parentIds, boolean direct, Set<FilterType> filterTypes, Iterable<? extends SubFilter> subFilter) {
        SolrQuery query = new SolrQuery();
        query.setFields(new String[]{CommonSearchFields.ID.getFieldName()});
        query.setRequestHandler("jucoSearch");
        this.appendFilterForEntitiesWithParentField(query, parentIds, direct, false, null);
        this.appendVisibilitiesFilter(query, authorizationContext);
        CommonSearchServiceImpl.appendFilterTypeFilter(query, filterTypes);
        this.appendSubFilterQuery(query, subFilter);
        SolrQueryBuilder.setUnlimitedFacet(query);
        CommonSearchFields facetField = direct ? CommonSearchFields.DIRECT_PARENT_IDS : CommonSearchFields.PARENT_IDS;
        SolrQueryBuilder.addFacetFields(query, facetField.getFieldName());
        QueryResponse response = this.executePagingQuery((ModifiableSolrParams)query, 0, 0);
        FacetField facet = response.getFacetField(facetField.getFieldName());
        if (facet == null) {
            return ImmutableMap.of();
        }
        List values = facet.getValues();
        if (values == null) {
            return ImmutableMap.of();
        }
        HashSet missing = Sets.newHashSet(parentIds);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (FacetField.Count count : values) {
            EntityId entityId;
            ItemId itemId;
            String name = count.getName();
            if (!StringUtils.isNotBlank((String)name) || !((itemId = ItemId.parse(name)) instanceof EntityId) || !missing.remove(entityId = (EntityId)itemId)) continue;
            result.put((Object)entityId, (Object)count.getCount());
        }
        for (EntityId entityId : missing) {
            result.put((Object)entityId, (Object)0L);
        }
        return result.build();
    }

    @Override
    public void setSuggestFacetCount(int suggestFacetCount) {
        this._suggestFacetCount = suggestFacetCount;
    }

    @Nonnull
    private SimpleSearchFacetCounts queryParentIdFacet(@Nonnull Set<EntityType> parentTypes, @Nonnull Set<EntityId> selectedParents) {
        SolrQuery query = new SolrQuery();
        query.setFields(new String[]{CommonSearchFields.ID.getFieldName()});
        query.setRequestHandler("jucoSearch");
        this.appendFilterForEntitiesWithParentField(query, selectedParents, true, false, null);
        CommonSearchServiceImpl.appendFilterTypeFilter(query, Iterables.filter(this._filterConfiguration.getOrderedFilterTypes(), FilterType.IS_ENTITY_TYPE));
        FilterQueryCriteria parentTypeJoinQuery = new FilterQueryCriteria(Restrictions.eq("type", parentTypes, Type.TO_NAME));
        SolrQueryBuilder.addJoinQuery(parentTypeJoinQuery, CommonSearchFields.ID, CommonSearchFields.DIRECT_PARENT_IDS);
        query.addFilterQuery(new String[]{parentTypeJoinQuery.toSolrQuery()});
        query.setFacetLimit(this._suggestFacetCount);
        query.setFacetMinCount(1);
        SolrQueryBuilder.addFacetFields(query, CommonSearchFields.DIRECT_PARENT_IDS.getFieldName());
        query.setFacetSort("count");
        QueryResponse response = this.executePagingQuery((ModifiableSolrParams)query, 0, 0);
        return SearchResultFacetCountsExtractor.createSimpleSearchFacetCountsFor(response, CommonSearchFields.DIRECT_PARENT_IDS.getFieldName(), (Iterable<String>)ImmutableSet.of(), (Optional<String>)Optional.absent());
    }

    @Override
    public SearchResult<SuggestModel<?, ?>> suggestConversations(String searchString, SortType sortType, int offset, int numberOfResults, SearchAuthorizationCheckContext authorizationContext) {
        ImmutableSet selectedFilters = ImmutableSet.of((Object)StaticFilterType.CONVERSATIONS, (Object)StaticFilterType.PROFILES);
        if (Strings.isNullOrEmpty((String)searchString)) {
            return SearchResult.empty();
        }
        SolrQuery query = new SolrQuery();
        query.setQuery(this.escapeSuggestQuery(searchString));
        query.setRequestHandler("suggest");
        query.setHighlight(true);
        Set<? extends FilterType> filterTypes = this.getAvailableSuggestFilterTypes((Set<? extends FilterType>)selectedFilters);
        if (filterTypes.isEmpty()) {
            return SearchResult.empty();
        }
        CommonSearchServiceImpl.appendFilterTypeFilter(query, filterTypes);
        this.appendVisibilitiesFilter(query, authorizationContext);
        this.appendSortCriteria(query, sortType);
        UnaryNotExpression chatTypeFilter = Restrictions.not(Restrictions.eq("conversation_type", ConversationType.ONE_ON_ONE.name()));
        query.addFilterQuery(new String[]{new FilterQueryCriteria(chatTypeFilter).toSolrQuery()});
        UnaryNotExpression chatUserFilter = Restrictions.not(Restrictions.eq("chat_user", Boolean.FALSE));
        query.addFilterQuery(new String[]{new FilterQueryCriteria(chatUserFilter).toSolrQuery()});
        QueryResponse response = this.executePagingQuery((ModifiableSolrParams)query, offset, numberOfResults);
        return this.convertToSuggestModelSearchResult(response, authorizationContext);
    }

    @Override
    public ListAndCount<EntityId> suggestEntityParents(EntityId childId, Set<EntityType> parentTypes, Set<EntityId> selectedParents, int offset, int numberOfResults, SearchAuthorizationCheckContext authorizationCheckContext) {
        if (parentTypes.isEmpty() || selectedParents.isEmpty()) {
            return ListAndCount.emptyListAndCount();
        }
        SimpleSearchFacetCounts facetCounts = this.queryParentIdFacet(parentTypes, selectedParents);
        if (facetCounts.getFacetCounts().isEmpty()) {
            return ListAndCount.emptyListAndCount();
        }
        SolrQuery query = new SolrQuery();
        query.setFields(new String[]{CommonSearchFields.ID.getFieldName()});
        ArrayList sortByFacetQuery = Lists.newArrayList();
        for (Map.Entry entry : facetCounts.getFacetCounts().entrySet()) {
            sortByFacetQuery.add(Restrictions.eq(CommonSearchFields.ID.getFieldName(), (String)entry.getKey(), Float.valueOf(((Long)entry.getValue()).floatValue())));
        }
        ImmutableSet excludedEntitiesAsSearchStrings = FluentIterable.from(selectedParents).append((Object[])new EntityId[]{childId}).filter(Predicates.notNull()).transform(ItemId::asString).toSet();
        sortByFacetQuery.add(Restrictions.eq(CommonSearchFields.ID.getFieldName(), "*"));
        query.setQuery(Restrictions.and(Restrictions.or(sortByFacetQuery), Restrictions.not(CommonSearchFields.ID.getFieldName(), (Set<String>)excludedEntitiesAsSearchStrings)).toSolrQuery());
        Criterion selectedParentIdsCriterion = Restrictions.eq("direct_parent_ids", selectedParents, ItemId::asString);
        Criterion entityTypeCriterion = Restrictions.eq("type", Iterables.filter(this._filterConfiguration.getOrderedFilterTypes(), FilterType.IS_ENTITY_TYPE), new NullPermeableFunction<FilterType, String>(){

            @Override
            public String applySafe(FilterType input) {
                return input.getType().name();
            }
        });
        FilterQueryCriteria parentJoinFilterQuery = new FilterQueryCriteria(Restrictions.and(selectedParentIdsCriterion, entityTypeCriterion));
        SolrQueryBuilder.addJoinQuery(parentJoinFilterQuery, CommonSearchFields.DIRECT_PARENT_IDS, CommonSearchFields.ID);
        query.addFilterQuery(new String[]{parentJoinFilterQuery.toSolrQuery()});
        query.addFilterQuery(new String[]{new FilterQueryCriteria(Restrictions.eq("type", parentTypes, Type.TO_NAME)).toSolrQuery()});
        this.appendVisibilitiesFilter(query, authorizationCheckContext);
        QueryResponse response = this.executePagingQuery((ModifiableSolrParams)query, offset, numberOfResults);
        List result = response.getBeans(CommonSearchResultModel.class);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (CommonSearchResultModel commonSearchResultModel : result) {
            EntityId entityId = CompoundId.parseToGlobalIdWithExpectedType(commonSearchResultModel.getId(), EntityId.class);
            if (entityId == null) continue;
            builder.add((Object)entityId);
        }
        return new ListAndCount<EntityId>((int)response.getResults().getNumFound(), (Collection<EntityId>)builder.build());
    }

    @Override
    public SearchResult<SuggestModel<?, ?>> findVisibleDirectChildren(EntityId parentEntityId, ImmutableSet<FilterType> filterTypes, Iterable<? extends SubFilter> subFilter, SortType sortType, int offset, int numberOfResults, SearchAuthorizationCheckContext authorizationContext) {
        SolrQuery query = new SolrQuery();
        query.setRequestHandler("suggest");
        Set<? extends FilterType> availableFilterType = this.getAvailableSuggestFilterTypes((Set<? extends FilterType>)filterTypes);
        if (!CollectionUtil.isEmpty(filterTypes) && availableFilterType.isEmpty()) {
            return SearchResult.empty();
        }
        CommonSearchServiceImpl.appendFilterTypeFilter(query, filterTypes);
        this.appendVisibilitiesFilter(query, authorizationContext);
        this.appendSortCriteria(query, sortType);
        this.appendSubFilterQuery(query, subFilter);
        this.appendFilterForEntitiesWithParentField(query, parentEntityId, true, false, null);
        return this.convertToSuggestModelSearchResult(this.executePagingQuery((ModifiableSolrParams)query, offset, numberOfResults), authorizationContext);
    }

    @ParametersAreNonnullByDefault
    private final class SearchFacetParametersToFacetsVisitor
    implements SearchFacetParameters.Visitor<ImmutableSet<SearchFacet>> {
        private final Set<? extends FilterType> _availableSelectedFilterTypes;
        private final SolrQuery _query;
        private final Iterable<? extends SubFilter> _subfilter;
        private final PersonId _currentUserId;
        private final SearchContextModel _searchContext;
        private final SearchConfigurationProvider _searchConfigProvider;
        private final boolean _isNavigatorSearch;
        private final Set<? extends FilterType> _navigatorAllowedFilterTypes;

        private SearchFacetParametersToFacetsVisitor(Set<? extends FilterType> availableSelectedFilterTypes, @Nullable SolrQuery query, @Nullable Iterable<? extends SubFilter> subfilter, @Nullable PersonId currentUserId, SearchContextModel searchContext, SearchConfigurationProvider searchConfigurationProvider, @Nullable boolean isNavigatorSearch, Set<? extends FilterType> navigatorAllowedFilterTypes) {
            this._availableSelectedFilterTypes = availableSelectedFilterTypes;
            this._query = query;
            this._subfilter = subfilter;
            this._currentUserId = currentUserId;
            this._searchContext = searchContext;
            this._searchConfigProvider = searchConfigurationProvider;
            this._isNavigatorSearch = isNavigatorSearch;
            this._navigatorAllowedFilterTypes = navigatorAllowedFilterTypes;
        }

        @Override
        public ImmutableSet<SearchFacet> visitSearchFacetContains(SearchFacetContainsParameters searchFacetContainsParameters) {
            if (!CommonSearchServiceImpl.this.isSearchFacetContainsSupported(searchFacetContainsParameters.getSearchFacet())) {
                throw new ServiceException("facet contains search is not supported for this facet");
            }
            return this.addFacetsToQuery((ImmutableSet<SearchFacet>)ImmutableSet.of((Object)searchFacetContainsParameters.getSearchFacet()), new ToSolrFacetVisitor(this._query, this._searchConfigProvider, searchFacetContainsParameters.getFacetContainsString(), (Iterable<? extends SubFilter>)ImmutableSet.of(), CommonSearchServiceImpl.this._entityConfigService.getSearchableDynamicAttributes(), this._currentUserId, this._searchContext, this._isNavigatorSearch, this._navigatorAllowedFilterTypes));
        }

        @Override
        public ImmutableSet<SearchFacet> visitDefaultFacets() {
            ImmutableSet defaultSearchFacets = FluentIterable.from(CommonSearchServiceImpl.this.getSearchFacetsForFilter(this._availableSelectedFilterTypes, this._searchConfigProvider)).append(AbstractSearchService.getSearchContextSearchFacets(this._searchContext, this._currentUserId)).append(CommonSearchServiceImpl.this.getFilterTypeSearchFacets(CommonSearchServiceImpl.this._filterConfiguration.getOrderedFilterTypes(), this._searchContext, this._currentUserId)).toSet();
            return this.addFacetsToQuery((ImmutableSet<SearchFacet>)defaultSearchFacets, new ToSolrFacetVisitor(this._query, this._searchConfigProvider, null, (Iterable<? extends SubFilter>)(this._subfilter != null ? this._subfilter : ImmutableSet.of()), CommonSearchServiceImpl.this._entityConfigService.getSearchableDynamicAttributes(), this._currentUserId, this._searchContext, this._isNavigatorSearch, this._navigatorAllowedFilterTypes));
        }

        @Override
        public ImmutableSet<SearchFacet> visitNoFacets() {
            return ImmutableSet.of();
        }

        @Override
        public ImmutableSet<SearchFacet> visitCustomFacets(CustomSearchFacetParameters customSearchFacetParameters) {
            return this.addFacetsToQuery(customSearchFacetParameters.getSearchFacets(), new ToSolrFacetVisitor(this._query, this._searchConfigProvider, null, (Iterable<? extends SubFilter>)ImmutableSet.of(), CommonSearchServiceImpl.this._entityConfigService.getSearchableDynamicAttributes(), this._currentUserId, this._searchContext, this._isNavigatorSearch, this._navigatorAllowedFilterTypes));
        }

        @Nonnull
        private ImmutableSet<SearchFacet> addFacetsToQuery(ImmutableSet<SearchFacet> searchFacets, ToSolrFacetVisitor toSolrFacetVisitor) {
            for (SearchFacet facet : searchFacets) {
                facet.accept(toSolrFacetVisitor);
            }
            SolrQueryBuilder.setUnlimitedFacet(this._query);
            return searchFacets;
        }
    }

    private static class CompoundIdExtractor
    implements Function<Object, Long> {
        private CompoundIdExtractor() {
        }

        public Long apply(Object input) {
            return input != null ? Long.valueOf(CompoundIdStringUtil.parseStringId((String)input)) : null;
        }
    }

    private static final class CommonSearchResultModelByTypeCollector
    implements FilterTypeVisitor<LinkedList<CommonSearchResultModel>> {
        final LinkedList<CommonSearchResultModel> _newsPosts = Lists.newLinkedList();
        final LinkedList<CommonSearchResultModel> _newsChannels = Lists.newLinkedList();
        final LinkedList<CommonSearchResultModel> _profiles = Lists.newLinkedList();
        final LinkedList<CommonSearchResultModel> _entities = Lists.newLinkedList();
        final LinkedList<CommonSearchResultModel> _workstreamMessages = Lists.newLinkedList();
        final LinkedList<CommonSearchResultModel> _conversations = Lists.newLinkedList();
        final LinkedList<CommonSearchResultModel> _chats = Lists.newLinkedList();
        final LinkedList<CommonSearchResultModel> _driveDocuments = Lists.newLinkedList();
        final LinkedList<CommonSearchResultModel> _wikis = Lists.newLinkedList();
        final LinkedList<CommonSearchResultModel> _chapters = Lists.newLinkedList();
        final LinkedList<CommonSearchResultModel> _articles = Lists.newLinkedList();

        public CommonSearchResultModelByTypeCollector(@Nonnull Iterable<? extends CommonSearchResultModel> searchResult) {
            for (CommonSearchResultModel commonSearchResultModel : searchResult) {
                FilterType byTypeName = FilterTypes.getByTypeName(commonSearchResultModel.getType());
                if (byTypeName == null) continue;
                byTypeName.accept(this).add(commonSearchResultModel);
            }
        }

        @Override
        @Nonnull
        public LinkedList<CommonSearchResultModel> visitDefault() {
            throw new IllegalStateException("missing implementation for filterType");
        }

        @Override
        public LinkedList<CommonSearchResultModel> visitAll() {
            throw new IllegalStateException("the type all is a pseudo type so it is not allowed to have a searchresult of that type");
        }

        @Override
        public LinkedList<CommonSearchResultModel> visitNewsPosts() {
            return this._newsPosts;
        }

        @Override
        public LinkedList<CommonSearchResultModel> visitNewsChannels() {
            return this._newsChannels;
        }

        @Override
        public LinkedList<CommonSearchResultModel> visitProfiles() {
            return this._profiles;
        }

        @Override
        public LinkedList<CommonSearchResultModel> visitEntity(EntityType entityType) {
            return this._entities;
        }

        @Override
        public LinkedList<CommonSearchResultModel> visitMicroblogs() {
            return this._workstreamMessages;
        }

        @Override
        public LinkedList<CommonSearchResultModel> visitConversations() {
            return this._conversations;
        }

        @Override
        public LinkedList<CommonSearchResultModel> visitChats() {
            return this._chats;
        }

        @Override
        public LinkedList<CommonSearchResultModel> visitDocuments() {
            return this._driveDocuments;
        }

        @Override
        public LinkedList<CommonSearchResultModel> visitWiki() {
            return this._wikis;
        }

        @Override
        public LinkedList<CommonSearchResultModel> visitChapter() {
            return this._chapters;
        }

        @Override
        public LinkedList<CommonSearchResultModel> visitArticle() {
            return this._articles;
        }
    }
}

