/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.chat.shared.model.ChatId;
import de.justsoftware.onx.chat.shared.model.ChatType;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.server.util.HtmlUtil;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.searchnew.business.ChatSearchHandler;
import de.justsoftware.onx.searchnew.business.impl.AbstractSearchHandler;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.shared.model.ChatSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.ChatSuggest;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ChatSearchHandlerImpl
extends AbstractSearchHandler<ChatId, ItemType>
implements ChatSearchHandler {
    @Override
    public ImmutableMap<CompoundId, ChatSearchResultBadgeModel> createSearchResultBadgeModel(Iterable<? extends CommonSearchResultModel> searchResultModels, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultModels) {
            ChatSearchResultBadgeModel badgeModel = this.createSearchResultBadgeModel(commonSearchResultModel);
            result.put((Object)CompoundId.of((AbstractUUIDBasedItemId)badgeModel.getId()), (Object)badgeModel);
        }
        return result.build();
    }

    @Override
    public ImmutableMap<CompoundId, ChatSuggest> createSearchResultSuggestModel(Iterable<? extends CommonSearchResultModel> searchResultModel, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultModel) {
            ChatSuggest suggest = this.createSearchResultSuggestModel(commonSearchResultModel);
            result.put((Object)CompoundId.of((AbstractUUIDBasedItemId)suggest.getId()), (Object)suggest);
        }
        return result.build();
    }

    @Override
    protected ChatId createId(String stringId) {
        return new ChatId(CompoundId.parseUUID(stringId));
    }

    @Override
    protected boolean canHandle(Type type) {
        return ItemType.CHAT == type;
    }

    @Nonnull
    private ChatSearchResultBadgeModel createSearchResultBadgeModel(CommonSearchResultModel searchResultModel) {
        ChatSearchResultBadgeModel result = new ChatSearchResultBadgeModel();
        result.setId(this.createId(searchResultModel.getId()));
        result.setType(ItemType.CHAT);
        result.setChatType(ChatType.valueOf(searchResultModel.getChatType()));
        result.setCommonFields(searchResultModel);
        result.setName(searchResultModel.getNameSubstring());
        return result;
    }

    @Nonnull
    private ChatSuggest createSearchResultSuggestModel(CommonSearchResultModel searchResultModel) {
        ChatSuggest suggest = new ChatSuggest();
        this.applySearchData(searchResultModel, ItemType.CHAT, suggest);
        suggest.setName(HtmlUtil.removeHighlightTag(searchResultModel.getName()));
        return suggest;
    }
}

