/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.searchnew.business.ChapterSearchHandler;
import de.justsoftware.onx.searchnew.business.impl.AbstractSearchHandler;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.shared.model.ChapterSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.ChapterSuggest;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import de.justsoftware.onx.searchnew.shared.model.CompoundIdStringUtil;
import de.justsoftware.onx.searchnew.shared.model.WikiInfo;
import de.justsoftware.onx.wiki.business.WikiInternalApiConnector;
import de.justsoftware.onx.wiki.shared.model.ChapterId;
import de.justsoftware.onx.wiki.shared.model.WikiId;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class ChapterSearchHandlerImpl
extends AbstractSearchHandler<ChapterId, ItemType>
implements ChapterSearchHandler {
    private final WikiInternalApiConnector _wikiApi;

    @Autowired
    public ChapterSearchHandlerImpl(WikiInternalApiConnector wikiApi) {
        this._wikiApi = wikiApi;
    }

    @Override
    public ImmutableMap<CompoundId, ChapterSearchResultBadgeModel> createSearchResultBadgeModel(Iterable<? extends CommonSearchResultModel> searchResults, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableMap<WikiId, WikiInfo> wikiNames = this.getWikiNamesFromSearchResults(searchResults);
        return FluentIterable.from(searchResults).transform(model -> {
            WikiId wikiId = this.getWikiIdFromParentIds(model.getParentIds());
            if (wikiId == null) {
                return this.createSearchResultBadgeModel((CommonSearchResultModel)model, null);
            }
            return this.createSearchResultBadgeModel((CommonSearchResultModel)model, (WikiInfo)wikiNames.get((Object)wikiId));
        }).filter(Objects::nonNull).uniqueIndex(result -> CompoundId.of((ChapterId)result.getId()));
    }

    @Nonnull
    private ImmutableMap<WikiId, WikiInfo> getWikiNamesFromSearchResults(Iterable<? extends CommonSearchResultModel> searchResults) {
        Set<WikiId> wikiIds = StreamSupport.stream(searchResults.spliterator(), false).map(model -> this.getWikiIdFromParentIds(model.getParentIds())).filter(Objects::nonNull).collect(Collectors.toSet());
        try {
            return this._wikiApi.wikiInfosByIds(wikiIds);
        }
        catch (ServiceException e) {
            return ImmutableMap.of();
        }
    }

    @CheckForNull
    private WikiId getWikiIdFromParentIds(@Nullable List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return new WikiId(CompoundIdStringUtil.parseStringId(ids.get(0)));
    }

    @Override
    public ImmutableMap<CompoundId, ChapterSuggest> createSearchResultSuggestModel(Iterable<? extends CommonSearchResultModel> searchResults, AuthorizationCheckContextWithUserId authorizationContext) {
        return FluentIterable.from(searchResults).transform(this::createSearchResultSuggestModel).filter(Objects::nonNull).uniqueIndex(result -> CompoundId.of((ChapterId)result.getId()));
    }

    @CheckForNull
    private ChapterSuggest createSearchResultSuggestModel(CommonSearchResultModel searchResult) {
        ChapterSuggest suggest = new ChapterSuggest();
        this.applySearchData(searchResult, ItemType.WIKI_CHAPTER, suggest);
        return suggest;
    }

    @CheckForNull
    private ChapterSearchResultBadgeModel createSearchResultBadgeModel(CommonSearchResultModel searchResult, @Nullable WikiInfo wikiInfo) {
        ChapterSearchResultBadgeModel result = new ChapterSearchResultBadgeModel();
        result.setId(new ChapterId(CompoundIdStringUtil.parseStringId(searchResult.getId())));
        result.setType(ItemType.WIKI_CHAPTER);
        result.setName(searchResult.getNameSubstring());
        result.setCommonFields(searchResult);
        result.setWikiInfo(wikiInfo);
        return result;
    }

    @Override
    protected ChapterId createId(String stringId) {
        return new ChapterId(CompoundIdStringUtil.parseStringId(stringId));
    }

    @Override
    protected boolean canHandle(Type type) {
        return ItemType.WIKI_CHAPTER == type;
    }
}

