/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.searchnew.business.impl.AbstractSearchHandler;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

public abstract class AbstractModuleSearchHandler<I extends SearchableId>
extends AbstractSearchHandler<I, ComponentType> {
    protected final EntityService _entityService;
    private final ComponentType _componentType;

    @ParametersAreNonnullByDefault
    protected AbstractModuleSearchHandler(ComponentType componentType, EntityService entityService) {
        this._componentType = componentType;
        this._entityService = entityService;
    }

    @CheckForNull
    protected static EntityId getIdOfNextEntityParent(@Nonnull CommonSearchResultModel searchResult) {
        Iterable<String> directParentIds = searchResult.getDirectParentIds();
        if (!CollectionUtil.isEmpty(directParentIds)) {
            return (EntityId)FluentIterable.from(directParentIds).transform(ItemId::parse).filter(EntityId.class).first().orNull();
        }
        return null;
    }

    @Nonnull
    protected Map<EntityId, EntityInfo> loadParents(@Nonnull Iterable<? extends CommonSearchResultModel> searchResultList, @Nonnull AuthorizationCheckContextWithLocale authorizationContext) {
        HashSet parentIds = Sets.newHashSet();
        for (CommonSearchResultModel commonSearchResultModel : searchResultList) {
            EntityId parentId;
            if (!this.canHandle(commonSearchResultModel.getType()) || (parentId = AbstractModuleSearchHandler.getIdOfNextEntityParent(commonSearchResultModel)) == null) continue;
            parentIds.add(parentId);
        }
        if (!parentIds.isEmpty()) {
            return this._entityService.getInfoMapByIds(parentIds, authorizationContext);
        }
        return ImmutableMap.of();
    }

    @Override
    protected boolean canHandle(Type type) {
        return this._componentType.equals(type);
    }

    @Nonnull
    public ComponentType getComponentType() {
        return this._componentType;
    }
}

