/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.person.shared.model.PersonType;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;

final class TypeLoader
extends AbstractItemBasedSolrDataLoader<Type> {
    static final TypeLoader INSTANCE = new TypeLoader();

    private TypeLoader() {
    }

    @Override
    protected Type visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        return item.getEntity().getType();
    }

    @Override
    protected Type visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, ProfileItem item) {
        return PersonType.PERSON;
    }

    @Override
    protected Type visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, WorkstreamItem item) {
        return StaticComponentType.WORKSTREAM;
    }

    @Override
    protected Type visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, DriveDocumentItem driveDocumentItem) {
        return ItemType.DRIVE_DOCUMENT;
    }

    @Override
    protected boolean indexDriveAllowed() {
        return true;
    }

    @Override
    protected Type visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        throw new UnsupportedOperationException("you have to define an implementation for " + item);
    }

    @Override
    protected void set(JucoSolrInputDocument doc, Type value) {
        doc.addField((SearchField)CommonSearchFields.TYPE, value.name());
    }
}

