/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.data.SolrDataLoader;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

final class TagsLoader
extends AbstractItemBasedSolrDataLoader<ImmutableSet<String>> {
    static final SolrDataLoader INSTANCE = new TagsLoader();

    private TagsLoader() {
    }

    @Override
    protected ImmutableSet<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        DBEntity entity = item.getEntity();
        if (!preloadedData.getEntityConfigService().tagsEnabled(entity.getType())) {
            return ImmutableSet.of();
        }
        return TagsLoader.asSet(entity.getTags());
    }

    @Override
    protected ImmutableSet<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, ProfileItem item) {
        return TagsLoader.asSet(Strings.nullToEmpty((String)item.getPerson().getTags()));
    }

    @Override
    protected ImmutableSet<String> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return ImmutableSet.of();
    }

    @Nonnull
    private static ImmutableSet<String> asSet(@Nullable String value) {
        if (StringUtils.isBlank((String)value)) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)value));
    }

    @Override
    protected void set(JucoSolrInputDocument doc, ImmutableSet<String> value) {
        doc.addField((SearchField)CommonSearchFields.TAGS, (Iterable<?>)value);
    }
}

