/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Optional;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import java.util.Date;

final class StartDateLoader
extends AbstractItemBasedSolrDataLoader<Optional<Date>> {
    static final StartDateLoader INSTANCE = new StartDateLoader();

    private StartDateLoader() {
    }

    @Override
    protected Optional<Date> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        DBEntity entity = item.getEntity();
        if (preloadedData.getEntityConfigService().getDurationTimeOption(entity.getType()) == EntityDurationTimeOption.OFF) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)entity.getStartAt());
    }

    @Override
    protected Optional<Date> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return Optional.absent();
    }

    @Override
    protected void set(JucoSolrInputDocument doc, Optional<Date> value) {
        doc.addField((SearchField)CommonSearchFields.START_DATE, value);
    }
}

