/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.business.LanguageService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationKey;
import de.justsoftware.onx.authorization.business.EverythingAllowedAuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.EverythingAllowedAuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.PersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.authorization.business.StaticRole;
import de.justsoftware.onx.comments.business.CommentsService;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.I18nextService;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.common.shared.util.Maps2;
import de.justsoftware.onx.common.shared.util.Optionals;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityComponent;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.container.shared.server.model.NewsPostItem;
import de.justsoftware.onx.like.business.LikeReadDataService;
import de.justsoftware.onx.like.business.model.SubscriptionModel;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionSectionId;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersionSection;
import de.justsoftware.onx.person.business.PersonReadDataService;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.profile.business.ProfileAttributeTranslationService;
import de.justsoftware.onx.profile.business.ProfileReadDataService;
import de.justsoftware.onx.profile.business.ProfileService;
import de.justsoftware.onx.profile.model.ProfileAttribute;
import de.justsoftware.onx.profile.model.ProfileAttributeBlock;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributeSearchType;
import de.justsoftware.onx.profile.model.ProfileAttributeTreeValues;
import de.justsoftware.onx.profile.model.ProfileAttributeType;
import de.justsoftware.onx.profile.model.ProfileAttributes;
import de.justsoftware.onx.profile.model.ProfileAttributesConfiguration;
import de.justsoftware.onx.profile.model.ProfileSection;
import de.justsoftware.onx.searchnew.business.RolesSearchService;
import de.justsoftware.onx.searchnew.business.SearchDataService;
import de.justsoftware.onx.searchnew.business.data.AllParentEntitiesLoader;
import de.justsoftware.onx.searchnew.business.data.AttachmentUrlsLoader;
import de.justsoftware.onx.searchnew.business.data.AuthorLoader;
import de.justsoftware.onx.searchnew.business.data.BirthdayLoader;
import de.justsoftware.onx.searchnew.business.data.BlockedLoader;
import de.justsoftware.onx.searchnew.business.data.ChatUserLoader;
import de.justsoftware.onx.searchnew.business.data.CommentVisitor;
import de.justsoftware.onx.searchnew.business.data.CommentsLoader;
import de.justsoftware.onx.searchnew.business.data.ContentLoader;
import de.justsoftware.onx.searchnew.business.data.DescriptionLoader;
import de.justsoftware.onx.searchnew.business.data.DirectAdminsLoader;
import de.justsoftware.onx.searchnew.business.data.DirectMemberLoader;
import de.justsoftware.onx.searchnew.business.data.DirectParentEntitiesLoader;
import de.justsoftware.onx.searchnew.business.data.DynamicEntityAttributesLoader;
import de.justsoftware.onx.searchnew.business.data.DynamicProfileAttributesLoader;
import de.justsoftware.onx.searchnew.business.data.EndDateLoader;
import de.justsoftware.onx.searchnew.business.data.EntityFacetAssigneeLoader;
import de.justsoftware.onx.searchnew.business.data.EntityFacetStatusLoader;
import de.justsoftware.onx.searchnew.business.data.ExpirationDateLoader;
import de.justsoftware.onx.searchnew.business.data.FirstnameLoader;
import de.justsoftware.onx.searchnew.business.data.IndexableItemPredicate;
import de.justsoftware.onx.searchnew.business.data.InheritAdminsLoader;
import de.justsoftware.onx.searchnew.business.data.InheritMembersLoader;
import de.justsoftware.onx.searchnew.business.data.IsFullIndexable;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.JustAppIdLoader;
import de.justsoftware.onx.searchnew.business.data.LastnameLoader;
import de.justsoftware.onx.searchnew.business.data.LocationLoader;
import de.justsoftware.onx.searchnew.business.data.ModifyDateLoader;
import de.justsoftware.onx.searchnew.business.data.MultiWikiLoader;
import de.justsoftware.onx.searchnew.business.data.NameLoader;
import de.justsoftware.onx.searchnew.business.data.NameSortLoader;
import de.justsoftware.onx.searchnew.business.data.PathLoader;
import de.justsoftware.onx.searchnew.business.data.PublicationDateLoader;
import de.justsoftware.onx.searchnew.business.data.RolesLoader;
import de.justsoftware.onx.searchnew.business.data.RolesNotHiddenLoader;
import de.justsoftware.onx.searchnew.business.data.SolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.StartDateLoader;
import de.justsoftware.onx.searchnew.business.data.SubscriberLoader;
import de.justsoftware.onx.searchnew.business.data.TagsLoader;
import de.justsoftware.onx.searchnew.business.data.TypeLoader;
import de.justsoftware.onx.searchnew.business.data.VisibilitiesLoader;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.searchnew.business.model.SearchIndexType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.wikieditor.business.WikiEditorService;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersion;
import de.justsoftware.onx.workstream.business.WorkstreamDataService;
import de.justsoftware.onx.workstream.business.impl.AttachmentCreatorService;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import de.justsoftware.polls.model.pollid.item.PollItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchDataServiceImpl
implements SearchDataService {
    static final ImmutableSet<Action> ENTITY_NEEDED_ROLES_ACTIONS = ImmutableSet.of((Object)StaticEntityAction.ENTITY_READ_DETAILS);
    static final ImmutableSet<StaticAction> MULTI_WIKI_SECTION_NEEDED_ROLES_ACTIONS = ImmutableSet.of((Object)StaticAction.MULTI_WIKI_READ_WITHOUT_ENTITY_CHECK);
    private static final ImmutableSet<SolrDataLoader> SOLR_DATA_LOADERS = ImmutableSet.of((Object)SubscriberLoader.INSTANCE, (Object)InheritMembersLoader.INSTANCE, (Object)InheritAdminsLoader.INSTANCE, (Object)DirectMemberLoader.INSTANCE, (Object)DirectAdminsLoader.INSTANCE, (Object)CommentsLoader.INSTANCE, (Object[])new SolrDataLoader[]{AllParentEntitiesLoader.INSTANCE, DirectParentEntitiesLoader.INSTANCE, PathLoader.INSTANCE, ExpirationDateLoader.INSTANCE, VisibilitiesLoader.INSTANCE, MultiWikiLoader.INSTANCE, ContentLoader.INSTANCE, DescriptionLoader.INSTANCE, TypeLoader.INSTANCE, JustAppIdLoader.INSTANCE, NameLoader.INSTANCE, NameSortLoader.INSTANCE, TagsLoader.INSTANCE, PublicationDateLoader.INSTANCE, ModifyDateLoader.INSTANCE, EntityFacetAssigneeLoader.INSTANCE, EntityFacetStatusLoader.INSTANCE, DynamicEntityAttributesLoader.INSTANCE, EndDateLoader.INSTANCE, StartDateLoader.INSTANCE, LocationLoader.INSTANCE, AuthorLoader.INSTANCE, AttachmentUrlsLoader.INSTANCE, RolesLoader.INSTANCE, RolesNotHiddenLoader.INSTANCE, DynamicProfileAttributesLoader.INSTANCE, BirthdayLoader.INSTANCE, BlockedLoader.INSTANCE, FirstnameLoader.INSTANCE, LastnameLoader.INSTANCE, ChatUserLoader.INSTANCE});
    private static final Logger LOG = LoggerFactory.getLogger(SearchDataServiceImpl.class);
    @Autowired
    private ConfigFileService _configFileService;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private RolesSearchService _rolesSearchService;
    @Autowired
    private EntityMemberService _entityMemberService;
    @Autowired
    private LikeReadDataService _likeReadDataService;
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private MultiWikiService _multiWikiService;
    @Autowired
    private PersonReadDataService _personReadDataService;
    @Autowired
    private LanguageService _languageService;
    @Autowired
    private CommentsService _commentsService;
    @Autowired
    private WikiEditorService _wikiEditorService;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private I18nextService _i18nextService;
    @Autowired
    private InternalLinkService _internalLinkService;
    @Autowired
    private EntityChildrenService _entityChildrenService;
    @Autowired
    private EntityVersionService _entityVersionService;
    @Autowired
    private AttachmentCreatorService _attachmentCreatorService;
    @Autowired
    private WorkstreamDataService _workstreamDataService;
    @Autowired
    private Settings _settings;
    @Autowired
    private ProfileReadDataService _profileReadDataService;
    @Autowired
    private ProfileService _profileService;
    @Autowired
    private ProfileAttributeTranslationService _profileAttributeTranslationService;
    @Autowired
    private PersonRoleService _personRoleService;
    private final PermissionRequestConnector _permissionRequestConnector;

    @Autowired
    public SearchDataServiceImpl(PermissionRequestConnector permissionRequestConnector) {
        this._permissionRequestConnector = permissionRequestConnector;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private static ImmutableMap<ItemId, ImmutableSetMultimap<Action, de.justsoftware.onx.common.shared.model.Role>> loadNeededRolesForActions(Map<ItemId, Item<?>> rootParents, Set<MultiWikiVersionSectionId> sectionIds, PersonIndependentAuthorizationContext authorizationContext) {
        final ImmutableSetMultimap.Builder neededRolesParams = ImmutableSetMultimap.builder();
        for (Item<?> rootParent : rootParents.values()) {
            rootParent.accept(new ItemVisitor.DefaultItemVisitor<Object>(){

                @Override
                protected Object visitDefault(Item<?> item) {
                    return this;
                }

                @Override
                public Object visit(EntityItem item) {
                    neededRolesParams.putAll((Object)item.getId(), ENTITY_NEEDED_ROLES_ACTIONS);
                    return this;
                }

                @Override
                public Object visit(PollItem pollItem) {
                    return this;
                }

                @Override
                public Object visit(NewsPostItem newsPostItem) {
                    return this;
                }
            });
        }
        for (MultiWikiVersionSectionId sectionId : sectionIds) {
            neededRolesParams.putAll((Object)sectionId, MULTI_WIKI_SECTION_NEEDED_ROLES_ACTIONS);
        }
        return authorizationContext.neededRolesForActions((SetMultimap<? extends ItemId, ? extends Action>)neededRolesParams.build());
    }

    @Nonnull
    private static ImmutableMap<ItemId, Item<?>> loadRootParents(@Nonnull Set<? extends ItemId> ids, @Nonnull PersonIndependentAuthorizationContext authorizationContext) {
        ImmutableListMultimap<ItemId, Item<?>> allParents = authorizationContext.getItemPathForIds(ids);
        ImmutableMap s = allParents.asMap();
        return ImmutableMap.copyOf((Map)Maps.filterValues((Map)Maps.transformValues((Map)s, (Function)new Function<Collection<Item<?>>, Item<?>>(){

            public Item<?> apply(@Nullable Collection<Item<?>> input) {
                return CollectionUtils.isEmpty(input) ? null : (Item)Iterables.getLast(input);
            }
        }), (Predicate)Predicates.notNull()));
    }

    @Override
    public ImmutableMap<SearchableId, JucoSolrInputDocument> load(Multimap<? extends SearchableId, SearchIndexType> ids, PersonIndependentAuthorizationContext authCtx) {
        ImmutableSetMultimap.Builder loadOperationsBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry entry : ids.entries()) {
            loadOperationsBuilder.putAll((Object)((SearchableId)entry.getKey()), ((SearchIndexType)((Object)entry.getValue())).accept(SolrDataLoaderForIndexTypeVisitor.INSTANCE));
        }
        for (SearchableId id2 : ids.keySet()) {
            if (IsFullIndexable.isFullIndexable(id2)) continue;
            loadOperationsBuilder.putAll((Object)id2, (Object[])new SolrDataLoader[]{TypeLoader.INSTANCE, JustAppIdLoader.INSTANCE});
        }
        ImmutableSetMultimap loadOperations = loadOperationsBuilder.build();
        SearchPreloadedDataIdCollector idsCollector = new SearchPreloadedDataIdCollector();
        FluentIterable itemIds = FluentIterable.from((Iterable)ids.keySet()).transform(SearchableId::toItemId);
        ImmutableMap items = authCtx.getItemsByIds(itemIds);
        ImmutableMap filteredItems = ImmutableMap.copyOf((Map)Maps.filterValues(items, (Predicate)IndexableItemPredicate.INSTANCE));
        ImmutableMap<ItemId, Item<?>> rootParents = SearchDataServiceImpl.loadRootParents((Set<? extends ItemId>)filteredItems.keySet(), authCtx);
        loadOperations.inverse().asMap().forEach((loadOperation, idsForOperation) -> loadOperation.collectIds(idsCollector, new ItemsAndRootParents((Collection<SearchableId>)idsForOperation, (Map<? extends ItemId, ? extends Item<?>>)filteredItems, rootParents)));
        ImmutableMap.Builder result = ImmutableMap.builder();
        SearchPreloadedData preloaded = new SearchPreloadedData(filteredItems, rootParents, idsCollector, authCtx);
        ids.asMap().forEach((id, searchIndexTypes) -> {
            Item item = (Item)filteredItems.get((Object)id.toItemId());
            if (item != null) {
                HashSet loadOps = new HashSet(loadOperations.get(id));
                JucoSolrInputDocument document = this.createSolrInputDocument((SearchableId)id, (Collection<SearchIndexType>)searchIndexTypes);
                Item rootParent = (Item)MoreObjects.firstNonNull((Object)((Item)preloaded._rootParentsByChildId.get(item.getId())), (Object)item);
                for (SolrDataLoader loader : loadOps) {
                    try {
                        loader.set(preloaded, item, rootParent, document);
                    }
                    catch (RuntimeException e) {
                        LOG.error("unable to set field " + loader.getClass() + " for item " + (ItemId)item.getId(), (Throwable)e);
                    }
                }
                result.put(id, (Object)document);
            }
        });
        return result.build();
    }

    @Nonnull
    private JucoSolrInputDocument createSolrInputDocument(@Nonnull SearchableId id, @Nonnull Collection<SearchIndexType> searchIndexTypes) {
        boolean isFullIndexable = IsFullIndexable.isFullIndexable(id);
        if (searchIndexTypes.contains((Object)SearchIndexType.ALL) && isFullIndexable) {
            return JucoSolrInputDocument.full(id);
        }
        return JucoSolrInputDocument.atomic(id);
    }

    @VisibleForTesting
    static enum SolrDataLoaderForIndexTypeVisitor implements SearchIndexType.Visitor<Iterable<SolrDataLoader>>
    {
        INSTANCE;

        private static final FluentIterable<SolrDataLoader> VISIBILITIES;

        @Override
        public ImmutableSet<SolrDataLoader> visitAll() {
            return SOLR_DATA_LOADERS;
        }

        @Override
        public FluentIterable<SolrDataLoader> visitVisibilities() {
            return VISIBILITIES;
        }

        @Override
        public FluentIterable<SolrDataLoader> visitParents() {
            return VISIBILITIES.append((Object[])new SolrDataLoader[]{DirectParentEntitiesLoader.INSTANCE, AllParentEntitiesLoader.INSTANCE, InheritMembersLoader.INSTANCE, InheritAdminsLoader.INSTANCE});
        }

        @Override
        public FluentIterable<SolrDataLoader> visitEntitiesMembership() {
            return VISIBILITIES.append((Object[])new SolrDataLoader[]{DirectParentEntitiesLoader.INSTANCE, AllParentEntitiesLoader.INSTANCE, DirectMemberLoader.INSTANCE, InheritMembersLoader.INSTANCE});
        }

        @Override
        public FluentIterable<SolrDataLoader> visitEntitiesAdmin() {
            return this.visitEntitiesMembership().append((Object[])new SolrDataLoader[]{DirectAdminsLoader.INSTANCE, InheritAdminsLoader.INSTANCE});
        }

        @Override
        public Iterable<SolrDataLoader> visitComments() {
            return ImmutableSet.of((Object)CommentsLoader.INSTANCE, (Object)SubscriberLoader.INSTANCE, (Object)ModifyDateLoader.INSTANCE);
        }

        @Override
        public Iterable<SolrDataLoader> visitSubscribers() {
            return ImmutableSet.of((Object)SubscriberLoader.INSTANCE);
        }

        @Override
        public Iterable<SolrDataLoader> visitExpiration() {
            return VISIBILITIES.append((Object[])new SolrDataLoader[]{ExpirationDateLoader.INSTANCE});
        }

        @Override
        public Iterable<SolrDataLoader> visitModifyDate() {
            return ImmutableSet.of((Object)ModifyDateLoader.INSTANCE);
        }

        @Override
        public Iterable<SolrDataLoader> visitPath() {
            return ImmutableSet.of((Object)PathLoader.INSTANCE);
        }

        static {
            VISIBILITIES = FluentIterable.of((Object)VisibilitiesLoader.INSTANCE, (Object[])new SolrDataLoader[0]);
        }
    }

    class SearchPreloadedDataIdCollector {
        final ImmutableSet.Builder<PersonId> _personRolesPersonIds = ImmutableSet.builder();
        final ImmutableSet.Builder<EntityId> _entityVersions = ImmutableSet.builder();
        final ImmutableSet.Builder<ItemId> _allCommentsParentIdsItemIds = ImmutableSet.builder();
        final ImmutableSet.Builder<ItemId> _directSubscribersItemIds = ImmutableSet.builder();
        final ImmutableSet.Builder<EntityId> _allEntityParentsRootEntities = ImmutableSet.builder();
        final ImmutableSet.Builder<PersonId> _personMembershipPersonIds = ImmutableSet.builder();
        final ImmutableSet.Builder<EntityId> _entityMemberShipsEntityIds = ImmutableSet.builder();
        final ImmutableSet.Builder<EntityId> _inheritedMembersEntityIds = ImmutableSet.builder();
        final ImmutableSet.Builder<EntityId> _inheritedAdminsEntityIds = ImmutableSet.builder();
        final ImmutableSet.Builder<EntityId> _currentPublishedSectionsEntityIds = ImmutableSet.builder();
        final ImmutableSet.Builder<GlobalId> _visibleWikiEditorsMappedEntities = ImmutableSet.builder();
        final ImmutableSet.Builder<PersonId> _additionalPersons = ImmutableSet.builder();
        final ImmutableSet.Builder<WorkstreamMessageId> _attachmentWorkstreamMessageIds = ImmutableSet.builder();
        final ImmutableSet.Builder<PersonId> _dynamicProfileAttributes = ImmutableSet.builder();
        final ImmutableSet.Builder<EntityId> _itemsWithPathRootEntities = ImmutableSet.builder();

        SearchPreloadedDataIdCollector() {
        }

        @Nonnull
        EntityConfigService entityConfigService() {
            return SearchDataServiceImpl.this._entityConfigService;
        }
    }

    @ParametersAreNonnullByDefault
    class SearchPreloadedData {
        final CheckedMultimap<EntityId, PersonId> _inheritedAdmins;
        final CheckedMultimap<EntityId, PersonId> _inheritedMembers;
        final CheckedMultimap<EntityId, EntityMemberWithPerson> _entityMemberships;
        final CheckedMultimap<EntityId, MultiWikiVersionSection> _currentPublishedSections;
        final ImmutableMap<ItemId, Item<?>> _rootParentsByChildId;
        final ImmutableMap<ItemId, ImmutableSetMultimap<Action, de.justsoftware.onx.common.shared.model.Role>> _neededRolesForActions;
        final CheckedMultimap<ItemId, PersonId> _directSubscribers;
        final CheckedMap<GlobalId, DBWikiEditor> _visibleWikiEditors;
        final ImmutableMap<WikiEditorId, DBWikiVersion> _visibleWikiVersions;
        final CheckedMultimap<EntityId, EntityId> _allEntityParents;
        final CheckedMultimap<EntityId, String> _itemsWithPathEntityParents;
        final CheckedMultimap<PersonId, EntityId> _personMemberships;
        final CheckedMap<EntityId, EntityVersion> _entityVersions;
        final ImmutableMap<StaticRole, ImmutableSetMultimap<ItemId, PersonId>> _personIdsForItemDependantRoles;
        final CheckedMultimap<ItemId, DBComment> _allComments;
        final CommentVisitor _commentVisitor = new CommentVisitor(this);
        final ImmutableMap<?, ? extends Item<?>> _items;
        final CheckedMap<PersonId, DBPerson> _additionalPersons;
        final CheckedMultimap<WorkstreamMessageId, Attachment> _attachments;
        final CheckedMap<PersonId, ImmutableSetMultimap<String, String>> _dynamicProfileAttributes;
        final ImmutableSet<AuthorizationKey<Item<?>, Action>> _chatUsersAuthKeys;
        final CheckedMultimap<PersonId, PersonRole> _personRoles;
        final ImmutableSetMultimap<String, Role> _personVisibilities;

        SearchPreloadedData(ImmutableMap<?, ? extends Item<?>> items, ImmutableMap<ItemId, Item<?>> rootParentsByChildId, SearchPreloadedDataIdCollector collectedIds, PersonIndependentAuthorizationContext authorizationContext) {
            this._items = items;
            this._rootParentsByChildId = rootParentsByChildId;
            this._inheritedAdmins = new CheckedMultimap<EntityId, PersonId>(collectedIds._inheritedAdminsEntityIds.build()){

                @Override
                protected Multimap<EntityId, PersonId> loadMultimap(ImmutableSet<EntityId> keys) {
                    return SearchDataServiceImpl.this._entityMemberService.getInheritedMembers(InheritsRole.INHERIT_ADMINS, (Set<EntityId>)keys);
                }
            };
            this._inheritedMembers = new CheckedMultimap<EntityId, PersonId>(collectedIds._inheritedMembersEntityIds.build()){

                @Override
                protected Multimap<EntityId, PersonId> loadMultimap(ImmutableSet<EntityId> keys) {
                    return SearchDataServiceImpl.this._entityMemberService.getInheritedMembers(InheritsRole.INHERIT_MEMBERS, (Set<EntityId>)keys);
                }
            };
            this._entityMemberships = new CheckedMultimap<EntityId, EntityMemberWithPerson>(collectedIds._entityMemberShipsEntityIds.build()){

                @Override
                protected Multimap<EntityId, EntityMemberWithPerson> loadMultimap(ImmutableSet<EntityId> keys) {
                    return SearchDataServiceImpl.this._entityMemberService.getEntityMembersByEntityIds((Set<EntityId>)keys);
                }
            };
            this._currentPublishedSections = new MultiWikiCurrentPublishedSectionsCheckedMap(collectedIds);
            this._additionalPersons = new AdditionalPersonsMap((ImmutableSet<PersonId>)collectedIds._additionalPersons.build());
            this._neededRolesForActions = SearchDataServiceImpl.loadNeededRolesForActions(this._rootParentsByChildId, (Set<MultiWikiVersionSectionId>)this._currentPublishedSections.values().transform(Identifiables.toId()).toSet(), authorizationContext);
            this._personIdsForItemDependantRoles = this.loadPersonIdsForItemDependantRoles(this._neededRolesForActions);
            this._entityVersions = new CheckedMap<EntityId, EntityVersion>(collectedIds._entityVersions.build()){

                @Override
                protected Map<EntityId, ? extends EntityVersion> loadMap(ImmutableSet<EntityId> keys) {
                    return SearchDataServiceImpl.this._entityVersionService.getNewestVersionsWithStatus((Set<EntityId>)keys, (Set<EntityStatus>)SearchDataServiceImpl.this._entityConfigService.getPublishedEntityStatus());
                }
            };
            this._directSubscribers = new CheckedMultimap<ItemId, PersonId>(collectedIds._directSubscribersItemIds.build()){

                @Override
                protected Multimap<ItemId, PersonId> loadMultimap(ImmutableSet<ItemId> keys) {
                    ImmutableListMultimap directSubscriptions = FluentIterable.from(SearchDataServiceImpl.this._likeReadDataService.getSubscribers((Set<? extends ItemId>)keys)).filter(Predicates.compose((Predicate)Predicates.in(SubscriptionState.SUBSCRIBED_SET), SubscriptionModel.GET_STATE)).index(SubscriptionModel.GET_ITEM_ID);
                    return ImmutableSetMultimap.copyOf((Multimap)Multimaps.transformValues((ListMultimap)directSubscriptions, SubscriptionModel.GET_SUBSCRIBER_ID));
                }
            };
            this._personVisibilities = this.loadProfileVisibilities();
            this._visibleWikiEditors = new WikiEditorCheckedMap(collectedIds);
            this._visibleWikiVersions = SearchDataServiceImpl.this._wikiEditorService.getCurrentWikiVersions((Set<WikiEditorId>)FluentIterable.from(this._visibleWikiEditors._map.values()).transform(Optionals.orNullFunction()).transform(Identifiables.toId()).filter(Predicates.notNull()).toSet());
            this._personMemberships = new PersonMembershipsMultimap((ImmutableSet<PersonId>)collectedIds._personMembershipPersonIds.build());
            ImmutableSet entityParentsAndPersonMemberships = FluentIterable.from((Iterable)collectedIds._allEntityParentsRootEntities.build()).append(this._personMemberships.values()).toSet();
            this._allEntityParents = new AllEntityParentsMultimap((ImmutableSet<EntityId>)entityParentsAndPersonMemberships);
            this._itemsWithPathEntityParents = new ItemsWithPathEntityParentsNameMultimap((ImmutableSet<EntityId>)collectedIds._itemsWithPathRootEntities.build());
            this._allComments = new AllCommentsMap((ImmutableSet<ItemId>)collectedIds._allCommentsParentIdsItemIds.build());
            this._attachments = new AttachmentsMultimap((ImmutableSet<WorkstreamMessageId>)collectedIds._attachmentWorkstreamMessageIds.build());
            this._dynamicProfileAttributes = new ProfileAttributesMap((ImmutableSet<PersonId>)collectedIds._dynamicProfileAttributes.build());
            this._chatUsersAuthKeys = this.loadChatUsersAuthKeys(authorizationContext);
            this._personRoles = new PersonRolesMultimap((ImmutableSet<PersonId>)collectedIds._personRolesPersonIds.build());
        }

        private ImmutableSetMultimap<String, Role> loadProfileVisibilities() {
            ImmutableSet profileIds = (ImmutableSet)this._items.values().stream().filter(item -> item instanceof ProfileItem).map(profile -> ((ProfileItem)profile).getId()).collect(ImmutableSet.toImmutableSet());
            return SearchDataServiceImpl.this._permissionRequestConnector.visibility((Iterable)profileIds.stream().map(ItemId::asString).collect(ImmutableSet.toImmutableSet()));
        }

        @Nonnull
        EntityConfigService getEntityConfigService() {
            return SearchDataServiceImpl.this._entityConfigService;
        }

        boolean isIndexPath() {
            return SearchDataServiceImpl.this._settings.isIndexPathEnabled();
        }

        @Nonnull
        private ImmutableMap<StaticRole, ImmutableSetMultimap<ItemId, PersonId>> loadPersonIdsForItemDependantRoles(ImmutableMap<ItemId, ImmutableSetMultimap<Action, de.justsoftware.onx.common.shared.model.Role>> neededRolesForActions) {
            ImmutableSetMultimap.Builder roles = ImmutableSetMultimap.builder();
            for (Map.Entry entry : neededRolesForActions.entrySet()) {
                roles.putAll((Object)((ItemId)entry.getKey()), (Iterable)((ImmutableSetMultimap)entry.getValue()).values());
            }
            return SearchDataServiceImpl.this._rolesSearchService.getPersonIdsForItemDependantRoles((ImmutableSetMultimap<? extends ItemId, ? extends de.justsoftware.onx.common.shared.model.Role>)roles.build());
        }

        @Nonnull
        ImmutableSet<Long> getPersonLongIdsForItemDependantRoles(final GlobalId itemId, ImmutableSet<StaticRole> itemDependantRoles) {
            return FluentIterable.from(itemDependantRoles).transform(Functions.forMap(this._personIdsForItemDependantRoles, (Object)ImmutableSetMultimap.of())).transformAndConcat((Function)new NullPermeableFunction<ImmutableSetMultimap<ItemId, PersonId>, ImmutableSet<PersonId>>(){

                @Override
                protected ImmutableSet<PersonId> applySafe(ImmutableSetMultimap<ItemId, PersonId> input) {
                    return input.get((Object)itemId);
                }
            }).transform(LongId.TO_LONG).toSet();
        }

        @Nonnull
        private ImmutableSet<AuthorizationKey<Item<?>, Action>> loadChatUsersAuthKeys(PersonIndependentAuthorizationContext authorizationContext) {
            HashSet allAuthKeys = new HashSet();
            for (Map.Entry entry : this._items.entrySet()) {
                Item item = (Item)entry.getValue();
                if (!(item instanceof ProfileItem)) continue;
                ProfileItem profileItem = (ProfileItem)item;
                allAuthKeys.add(new AuthorizationKey<Object, StaticAction>(null, profileItem.getPerson(), StaticAction.CONNECT_USE));
            }
            if (allAuthKeys.isEmpty()) {
                return ImmutableSet.of();
            }
            return authorizationContext.may(allAuthKeys);
        }

        @Nonnull
        ImmutableSet<String> getAvailableLanguageCodes() {
            return SearchDataServiceImpl.this._languageService.getAvailableLanguageCode();
        }

        @Nonnull
        I18nService i18nService() {
            return SearchDataServiceImpl.this._i18nService;
        }

        @Nonnull
        I18nextService i18nextService() {
            return SearchDataServiceImpl.this._i18nextService;
        }

        @Nonnull
        InternalLinkService internalLinkService() {
            return SearchDataServiceImpl.this._internalLinkService;
        }

        @Nonnull
        ImmutableSet<PersonRole> getHiddenPersonRoles() {
            return SearchDataServiceImpl.this._configFileService.getConfigFile().getHiddenPersonRoles();
        }

        private final class MultiWikiCurrentPublishedSectionsCheckedMap
        extends CheckedMultimap<EntityId, MultiWikiVersionSection> {
            private MultiWikiCurrentPublishedSectionsCheckedMap(SearchPreloadedDataIdCollector collectedIds) {
                super(collectedIds._currentPublishedSectionsEntityIds.build());
            }

            @Override
            protected Multimap<EntityId, MultiWikiVersionSection> loadMultimap(ImmutableSet<EntityId> keys) {
                ImmutableMap.Builder entityMap = ImmutableMap.builder();
                for (EntityId entityId : keys) {
                    Item item = (Item)SearchPreloadedData.this._items.get((Object)entityId);
                    if (item == null || !(item instanceof EntityItem)) continue;
                    entityMap.put((Object)entityId, (Object)((EntityItem)item).getEntity());
                }
                final ImmutableTable<EntityId, ComponentType, DBEntityComponent> components = SearchDataServiceImpl.this._entityService.getComponentsByEntities((Map<EntityId, DBEntity>)entityMap.build());
                ImmutableSet entityIdsWithMultiWikiComponent = FluentIterable.from(keys).filter((Predicate)new Predicate<EntityId>(){

                    public boolean apply(EntityId input) {
                        DBEntityComponent multiWikiEditorComponent = (DBEntityComponent)components.get((Object)input, (Object)StaticComponentType.MULTI_WIKI);
                        return multiWikiEditorComponent != null && multiWikiEditorComponent.isVisible();
                    }
                }).toSet();
                return SearchDataServiceImpl.this._multiWikiService.getCurrentPublishedSections((Set<EntityId>)entityIdsWithMultiWikiComponent);
            }
        }

        private final class WikiEditorCheckedMap
        extends CheckedMap<GlobalId, DBWikiEditor> {
            private WikiEditorCheckedMap(SearchPreloadedDataIdCollector collectedIds) {
                super(collectedIds._visibleWikiEditorsMappedEntities.build());
            }

            @Override
            protected Map<GlobalId, ? extends DBWikiEditor> loadMap(ImmutableSet<GlobalId> keys) {
                Map<EntityId, EntityItem> entityItems = Maps2.filterValues(Maps2.filterKeys(SearchPreloadedData.this._items, EntityId.class), EntityItem.class);
                ImmutableMap interesting = ImmutableMap.copyOf((Map)Maps.filterKeys(entityItems, (Predicate)Predicates.in(keys)));
                Map entities = Maps.transformValues((Map)interesting, EntityItem.TO_DBENTITY);
                final ImmutableTable<EntityId, ComponentType, DBEntityComponent> components = SearchDataServiceImpl.this._entityService.getComponentsByEntities(entities);
                ImmutableSet visibleWikiEditorEntityIds = FluentIterable.from((Iterable)interesting.keySet()).filter((Predicate)new Predicate<EntityId>(){

                    public boolean apply(@Nullable EntityId input) {
                        DBEntityComponent wikiEditorComponent = (DBEntityComponent)components.get((Object)input, (Object)StaticComponentType.WIKI_EDITOR);
                        return wikiEditorComponent != null && wikiEditorComponent.isVisible();
                    }
                }).toSet();
                return SearchDataServiceImpl.this._wikiEditorService.getDBWikiEditorByParentIds((Set<? extends GlobalId>)visibleWikiEditorEntityIds);
            }
        }

        private final class AdditionalPersonsMap
        extends CheckedMap<PersonId, DBPerson> {
            private AdditionalPersonsMap(ImmutableSet<PersonId> keys) {
                super(keys);
            }

            @Override
            protected Map<PersonId, ? extends DBPerson> loadMap(ImmutableSet<PersonId> keys) {
                return SearchDataServiceImpl.this._personReadDataService.getPersonsByIds((Set<PersonId>)keys);
            }
        }

        private final class AllCommentsMap
        extends CheckedMultimap<ItemId, DBComment> {
            private AllCommentsMap(ImmutableSet<ItemId> keys) {
                super(keys);
            }

            @Override
            protected Multimap<ItemId, DBComment> loadMultimap(ImmutableSet<ItemId> keys) {
                return SearchDataServiceImpl.this._commentsService.getDBCommentsByParents((Set<? extends ItemId>)keys);
            }
        }

        private final class AttachmentsMultimap
        extends CheckedMultimap<WorkstreamMessageId, Attachment> {
            private AttachmentsMultimap(ImmutableSet<WorkstreamMessageId> keys) {
                super(keys);
            }

            @Override
            protected Multimap<WorkstreamMessageId, Attachment> loadMultimap(ImmutableSet<WorkstreamMessageId> keys) {
                ImmutableListMultimap<WorkstreamMessageId, ItemId> attachmentIdsMap = SearchDataServiceImpl.this._workstreamDataService.getAttachedItemIds((Set<WorkstreamMessageId>)keys);
                ImmutableMap<ItemId, Attachment> attachmentMap = SearchDataServiceImpl.this._attachmentCreatorService.loadAttachments(EverythingAllowedAuthorizationCheckContextWithLocale.EN, (Iterable<ItemId>)attachmentIdsMap.values());
                return Multimaps.filterValues((Multimap)Multimaps.transformValues(attachmentIdsMap, (Function)Functions.forMap(attachmentMap, null)), (Predicate)Predicates.notNull());
            }
        }

        private final class ItemsWithPathEntityParentsNameMultimap
        extends CheckedMultimap<EntityId, String> {
            private ItemsWithPathEntityParentsNameMultimap(ImmutableSet<EntityId> keys) {
                super(keys);
            }

            @Override
            protected Multimap<EntityId, String> loadMultimap(ImmutableSet<EntityId> keys) {
                if (!SearchDataServiceImpl.this._settings.isIndexPathEnabled()) {
                    return ImmutableSetMultimap.of();
                }
                ImmutableSetMultimap<EntityId, EntityId> allEntityParents = SearchDataServiceImpl.this._entityChildrenService.getAllEntityParents((Set<EntityId>)keys);
                ImmutableSet allEntityParentIds = ImmutableSet.copyOf((Collection)allEntityParents.values());
                Map<EntityId, DBEntity> allDBEntityParents = SearchDataServiceImpl.this._entityService.getByIds((Set<EntityId>)allEntityParentIds);
                return ImmutableSetMultimap.copyOf((Multimap)Multimaps.transformValues(allEntityParents, entityId -> {
                    DBEntity entity = (DBEntity)allDBEntityParents.get(entityId);
                    return entity != null ? entity.getName() : "";
                }));
            }
        }

        private final class AllEntityParentsMultimap
        extends CheckedMultimap<EntityId, EntityId> {
            private AllEntityParentsMultimap(ImmutableSet<EntityId> keys) {
                super(keys);
            }

            @Override
            protected Multimap<EntityId, EntityId> loadMultimap(ImmutableSet<EntityId> keys) {
                return SearchDataServiceImpl.this._entityChildrenService.getAllEntityParents((Set<EntityId>)keys);
            }
        }

        private final class PersonMembershipsMultimap
        extends CheckedMultimap<PersonId, EntityId> {
            private PersonMembershipsMultimap(ImmutableSet<PersonId> keys) {
                super(keys);
            }

            @Override
            protected Multimap<PersonId, EntityId> loadMultimap(ImmutableSet<PersonId> keys) {
                return SearchDataServiceImpl.this._entityMemberService.getEntityIdsByPersonIdAndMemberRoles((Set<PersonId>)keys, (Set<EntityMemberRole>)EntityMemberRoles.VISIBLE_MEMBER);
            }
        }

        @ParametersAreNonnullByDefault
        private final class ProfileAttributesMap
        extends CheckedMap<PersonId, ImmutableSetMultimap<String, String>> {
            private ProfileAttributesMap(ImmutableSet<PersonId> keys) {
                super(keys);
            }

            @Override
            protected Map<PersonId, ImmutableSetMultimap<String, String>> loadMap(ImmutableSet<PersonId> personIds) {
                ImmutableSetMultimap<String, String> translations = SearchDataServiceImpl.this._profileAttributeTranslationService.getAllProfileAttributeTranslations();
                ImmutableSet profileIds = FluentIterable.from(personIds).transform(PersonId.AS_PROFILE_ID).toSet();
                ImmutableMap<ProfileId, ProfileAttributesConfiguration> visibleAttributesConfigurations = SearchDataServiceImpl.this._profileService.getVisibleAttributesConfigurations((Set<ProfileId>)profileIds, EverythingAllowedAuthorizationCheckContext.INSTANCE);
                ImmutableMap<ProfileId, ProfileAttributes> profileAttributes = SearchDataServiceImpl.this._profileReadDataService.getProfileAttributesByProfileId((Map<ProfileId, ProfileAttributesConfiguration>)visibleAttributesConfigurations);
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (PersonId id : personIds) {
                    ProfileId pid = id.asProfileId();
                    builder.put((Object)id, this.filterSearchableAttributes((ProfileAttributes)profileAttributes.get((Object)pid), (ProfileAttributesConfiguration)visibleAttributesConfigurations.get((Object)pid), translations));
                }
                return builder.build();
            }

            @Nonnull
            private ImmutableSetMultimap<String, String> filterSearchableAttributes(ProfileAttributes attributes, ProfileAttributesConfiguration attributesConfiguration, ImmutableSetMultimap<String, String> translations) {
                FluentIterable allAttributes = FluentIterable.from(attributes.getSections()).filter(Predicates.notNull()).transformAndConcat(ProfileSection.ATTRIBUTE_BLOCKS).filter(Predicates.notNull()).transformAndConcat(ProfileAttributeBlock.ATTRIBUTES);
                ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
                for (ProfileAttribute attribute : allAttributes) {
                    ProfileAttributeConfiguration attributeConfig = attributesConfiguration.getAttributeByName(attribute.getName());
                    if (ProfileAttributeSearchType.isSearchable(attributeConfig)) {
                        result.putAll((Object)("profile_dynamic_" + attribute.getName()), (Iterable)FluentIterable.from(attribute.getValues()).filter(Predicates.notNull()).transformAndConcat(this.getTranslationFor(attributeConfig, translations)));
                    }
                    if (!ProfileAttributeSearchType.isFacetable(attributeConfig)) continue;
                    result.putAll((Object)("profile_facet_dynamic_" + attribute.getName()), (Iterable)FluentIterable.from(attribute.getValues()).filter(Predicates.notNull()).transformAndConcat(this.getFacetsFor(attributeConfig)));
                }
                return result.build();
            }

            @Nonnull
            private Function<String, Iterable<String>> getTranslationFor(final ProfileAttributeConfiguration configuration, final ImmutableSetMultimap<String, String> translations) {
                switch (configuration.getType()) {
                    case CHECKRADIO: 
                    case SELECT: {
                        return new Function<String, Iterable<String>>(){

                            public Iterable<String> apply(String input) {
                                return translations.get((Object)input);
                            }
                        };
                    }
                    case TEXT: 
                    case TEXT_PHONE: 
                    case TEXTAREA: 
                    case MONTH_YEAR_PERIOD: {
                        return new Function<String, Iterable<String>>(){

                            public Iterable<String> apply(String input) {
                                ImmutableSet.Builder result = ImmutableSet.builder();
                                return input == null ? result.build() : result.add((Object)input).build();
                            }
                        };
                    }
                    case TREE_SELECT: {
                        return new Function<String, Iterable<String>>(){

                            public Iterable<String> apply(String input) {
                                ProfileAttributeTreeValues.ProfileAttributeTreeValue selectedValue = configuration.getTreeValues().getByPath(input);
                                return selectedValue != null ? FluentIterable.from(selectedValue.getPathValues()).filter(Predicates.notNull()).transformAndConcat(arg_0 -> ((ImmutableSetMultimap)translations).get(arg_0)) : ImmutableSet.of();
                            }
                        };
                    }
                }
                throw new UnsupportedOperationException("Unsupported Type : " + configuration.getType());
            }

            @Nonnull
            private Function<String, Iterable<String>> getFacetsFor(final ProfileAttributeConfiguration configuration) {
                return ProfileAttributeType.TREE_SELECT.equals((Object)configuration.getType()) ? new Function<String, Iterable<String>>(){

                    public Iterable<String> apply(String input) {
                        ProfileAttributeTreeValues.ProfileAttributeTreeValue selectedValue = configuration.getTreeValues().getByPath(input);
                        return selectedValue != null ? FluentIterable.from(selectedValue.getPathValues()).filter(Predicates.notNull()) : ImmutableSet.of();
                    }
                } : new Function<String, Iterable<String>>(){

                    public Iterable<String> apply(String input) {
                        return input != null ? ImmutableSet.of((Object)input) : ImmutableSet.of();
                    }
                };
            }
        }

        @ParametersAreNonnullByDefault
        private final class PersonRolesMultimap
        extends CheckedMultimap<PersonId, PersonRole> {
            private PersonRolesMultimap(ImmutableSet<PersonId> keys) {
                super(keys);
            }

            @Override
            protected Multimap<PersonId, PersonRole> loadMultimap(ImmutableSet<PersonId> keys) {
                return SearchDataServiceImpl.this._personRoleService.getPersonRoles((Set<PersonId>)keys);
            }
        }
    }

    static abstract class CheckedMultimap<K, V>
    extends AbstractCheckedMap<K, Collection<V>> {
        public CheckedMultimap(@Nonnull ImmutableSet<K> keys) {
            super(keys);
        }

        @Override
        protected Map<K, Collection<V>> load(ImmutableSet<K> keys) {
            return this.loadMultimap(keys).asMap();
        }

        @Nonnull
        protected abstract Multimap<K, V> loadMultimap(@Nonnull ImmutableSet<K> var1);

        @Override
        protected Collection<V> absent(@Nullable K key) {
            return ImmutableSet.of();
        }

        @Nonnull
        public FluentIterable<V> values() {
            return FluentIterable.from(this._map.values()).transformAndConcat(Functions.identity());
        }
    }

    static abstract class CheckedMap<K, V>
    extends AbstractCheckedMap<K, Optional<V>> {
        public CheckedMap(@Nonnull ImmutableSet<K> keys) {
            super(keys);
        }

        @Override
        protected Map<K, Optional<V>> load(ImmutableSet<K> keys) {
            return Maps.transformValues(this.loadMap(keys), Optionals.fromNullableFunction());
        }

        @Nonnull
        protected abstract Map<K, ? extends V> loadMap(@Nonnull ImmutableSet<K> var1);

        @Override
        protected Optional<V> absent(@Nullable K key) {
            return Optional.absent();
        }

        @Nonnull
        public Function<K, V> forMap() {
            return new NullPermeableFunction<K, V>(){

                @Override
                protected V applySafe(K input) {
                    return ((Optional)this.get(input)).orNull();
                }
            };
        }
    }

    static abstract class AbstractCheckedMap<K, V> {
        protected final Map<K, ? extends V> _map;
        final ImmutableSet<K> _keys;

        private AbstractCheckedMap(@Nonnull ImmutableSet<K> keys) {
            this._keys = keys;
            this._map = keys.isEmpty() ? ImmutableMap.of() : this.load(keys);
        }

        @Nonnull
        protected abstract Map<K, ? extends V> load(@Nonnull ImmutableSet<K> var1);

        @Nonnull
        public final V get(@Nullable K key) {
            V result = this._map.get(key);
            if (result != null) {
                return result;
            }
            if (this._keys.contains(key) || key == null) {
                return this.absent(key);
            }
            throw new IllegalArgumentException("you try to access a map with a key (" + key + "), which was not used to load the map!");
        }

        @Nonnull
        protected abstract V absent(@Nullable K var1);
    }
}

