/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import java.util.Collection;

final class RolesLoader
extends AbstractItemBasedSolrDataLoader<ImmutableSet<String>> {
    static final RolesLoader INSTANCE = new RolesLoader();

    private RolesLoader() {
    }

    @Override
    protected ImmutableSet<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, ProfileItem item) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        Collection roles = (Collection)preloadedData._personRoles.get(item.getId().asPersonId());
        for (PersonRole role : roles) {
            RolesLoader.addNonEmpty((ImmutableCollection.Builder<String>)result, role.getName());
        }
        return result.build();
    }

    @Override
    protected ImmutableSet<String> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return ImmutableSet.of();
    }

    @Override
    protected void set(JucoSolrInputDocument doc, ImmutableSet<String> value) {
        doc.addField((SearchField)CommonSearchFields.ROLES, (Iterable<?>)value);
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._personRolesPersonIds.addAll(ids.persons());
    }
}

