/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Optional;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import java.util.Date;

final class PublicationDateLoader
extends AbstractItemBasedSolrDataLoader<Optional<Date>> {
    static final PublicationDateLoader INSTANCE = new PublicationDateLoader();

    private PublicationDateLoader() {
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._entityVersions.addAll(ids.entities());
    }

    @Override
    protected Optional<Date> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        boolean releaseProcess = preloadedData.getEntityConfigService().releaseProcessMandatory(item.getEntity().getType());
        if (!releaseProcess) {
            return Optional.fromNullable((Object)item.getEntity().getCreateDate());
        }
        Optional entityVersion = (Optional)preloadedData._entityVersions.get(item.getId());
        if (entityVersion.isPresent()) {
            return Optional.fromNullable((Object)((EntityVersion)entityVersion.get()).getReleaseDate());
        }
        return Optional.absent();
    }

    @Override
    protected Optional<Date> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, ProfileItem item) {
        return Optional.of((Object)item.getPerson().getCreateDate());
    }

    @Override
    protected Optional<Date> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, WorkstreamItem item) {
        return Optional.fromNullable((Object)item.getMessage().getCreateDate());
    }

    @Override
    protected Optional<Date> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return Optional.absent();
    }

    @Override
    protected void set(JucoSolrInputDocument doc, Optional<Date> value) {
        doc.addField((SearchField)CommonSearchFields.PUBLICATION_DATE, value);
    }
}

