/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Predicate;
import de.justsoftware.onx.chat.model.ChatItem;
import de.justsoftware.onx.container.shared.server.model.AbstractSearchableItemVisitor;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.NewsChannelItem;
import de.justsoftware.onx.container.shared.server.model.NewsPostItem;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.wiki.model.ArticleItem;
import de.justsoftware.onx.wiki.model.ChapterItem;
import de.justsoftware.onx.wiki.model.WikiItem;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import de.justsoftware.polls.model.pollid.item.PollItem;
import javax.annotation.Nullable;

final class IndexableItemPredicate
extends AbstractSearchableItemVisitor<Boolean>
implements Predicate<Item<?>> {
    static final IndexableItemPredicate INSTANCE = new IndexableItemPredicate();

    private IndexableItemPredicate() {
    }

    @Override
    public Boolean visit(EntityItem item) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(DriveDocumentItem driveDocumentItem) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ProfileItem item) {
        return !item.getPerson().isDeleted();
    }

    @Override
    public Boolean visit(WorkstreamItem item) {
        return item.getType() == WorkstreamMessageType.MICROBLOG_POSTING && item.getMessage().isPublished();
    }

    @Override
    public Boolean visit(Conversation conversation) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ChatItem chat) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(WikiItem wikiItem) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ChapterItem chapterItem) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ArticleItem articleItem) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(PollItem pollItem) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(NewsPostItem newsPostItem) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(NewsChannelItem newsChannelItem) {
        return Boolean.TRUE;
    }

    public boolean apply(@Nullable Item<?> input) {
        return input != null && input.accept(this) != false;
    }

    @Override
    protected Boolean visitNotSearchableItem(Item<?> item) {
        return Boolean.FALSE;
    }
}

