/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Optional;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;

final class EntityFacetStatusLoader
extends AbstractItemBasedSolrDataLoader<Optional<Long>> {
    static final EntityFacetStatusLoader INSTANCE = new EntityFacetStatusLoader();

    private EntityFacetStatusLoader() {
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._entityVersions.addAll(ids.entities());
    }

    @Override
    protected Optional<Long> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        Optional entityVersion = (Optional)preloadedData._entityVersions.get(item.getId());
        if (!entityVersion.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)((EntityStatusId)((EntityVersion)entityVersion.get()).getStatus().getId()).idAsLongValue());
    }

    @Override
    protected Optional<Long> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return Optional.absent();
    }

    @Override
    protected void set(JucoSolrInputDocument doc, Optional<Long> value) {
        doc.addField((SearchField)CommonSearchFields.ENTITY_FACET_STATUS, value);
    }
}

