/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Optional;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import java.util.Date;

final class EndDateLoader
extends AbstractItemBasedSolrDataLoader<Optional<Date>> {
    static final EndDateLoader INSTANCE = new EndDateLoader();

    private EndDateLoader() {
    }

    @Override
    protected Optional<Date> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        DBEntity entity = item.getEntity();
        if (preloadedData.getEntityConfigService().getDurationTimeOption(entity.getType()) == EntityDurationTimeOption.OFF) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)entity.getEndAt());
    }

    @Override
    protected Optional<Date> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return Optional.absent();
    }

    @Override
    protected void set(JucoSolrInputDocument doc, Optional<Date> value) {
        doc.addField((SearchField)CommonSearchFields.END_DATE, value);
    }
}

