/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import java.util.Map;

final class DynamicProfileAttributesLoader
extends AbstractItemBasedSolrDataLoader<ImmutableSetMultimap<String, String>> {
    static final DynamicProfileAttributesLoader INSTANCE = new DynamicProfileAttributesLoader();

    private DynamicProfileAttributesLoader() {
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._dynamicProfileAttributes.addAll(ids.persons());
    }

    @Override
    protected ImmutableSetMultimap<String, String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, ProfileItem item) {
        Optional dynamicAttributes = (Optional)preloadedData._dynamicProfileAttributes.get(item.getId().asPersonId());
        if (!dynamicAttributes.isPresent()) {
            return ImmutableSetMultimap.of();
        }
        return (ImmutableSetMultimap)dynamicAttributes.get();
    }

    @Override
    protected ImmutableSetMultimap<String, String> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return ImmutableSetMultimap.of();
    }

    @Override
    protected void set(JucoSolrInputDocument doc, ImmutableSetMultimap<String, String> value) {
        doc.addWildcardField((Map<String, ?>)value.asMap());
    }
}

