/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.attributes.ArithmeticOperationInput;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.EntityDynamicAttributesUtil;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.NumberInput;
import de.justsoftware.onx.common.shared.model.attributes.PersonSuggestInput;
import de.justsoftware.onx.common.shared.model.attributes.SearchConfiguration;
import de.justsoftware.onx.common.shared.model.attributes.SelectOptionMessage;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.model.attributes.TextAreaInput;
import de.justsoftware.onx.common.shared.model.attributes.TextInput;
import de.justsoftware.onx.container.shared.model.EntityDynamicAttributeClientModel;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.IEntityDynamicAttribute;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import java.util.Map;
import javax.annotation.Nonnull;

final class DynamicEntityAttributesLoader
extends AbstractItemBasedSolrDataLoader<ImmutableSetMultimap<String, String>> {
    public static final DynamicEntityAttributesLoader INSTANCE = new DynamicEntityAttributesLoader();

    private DynamicEntityAttributesLoader() {
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        for (EntityItem item : ids.entityItems()) {
            DBEntity entity = item.getEntity();
            ImmutableList<DynamicAttributeConfig> confAttributes = idsCollector.entityConfigService().getDynamicAttributesForType(entity.getType());
            ImmutableMap clientAttributeMap = Maps.uniqueIndex(entity.getDynamicAttributes(), IEntityDynamicAttribute.TO_ATTRIBUTE_ID);
            for (DynamicAttributeConfig confAttr : confAttributes) {
                DynamicAttributeId id;
                EntityDynamicAttributeClientModel attribute;
                SearchConfiguration searchConfig = confAttr.getSearchConfig();
                if (!searchConfig.isSearchable() || (attribute = (EntityDynamicAttributeClientModel)clientAttributeMap.get((Object)(id = confAttr.getId()))) == null) continue;
                idsCollector._additionalPersons.addAll(confAttr.getInput().accept(new Input.InputVisitor<Iterable<PersonId>>(){

                    @Override
                    public Iterable<PersonId> visit(SelectionInput input) {
                        return ImmutableSet.of();
                    }

                    @Override
                    public Iterable<PersonId> visit(TextInput input) {
                        return ImmutableSet.of();
                    }

                    @Override
                    public Iterable<PersonId> visit(TextAreaInput input) {
                        return ImmutableSet.of();
                    }

                    @Override
                    public Iterable<PersonId> visit(PersonSuggestInput suggestInput) {
                        return FluentIterable.from(attribute.getValues()).transform(PersonId.PARSE);
                    }

                    @Override
                    public Iterable<PersonId> visit(NumberInput numberInput) {
                        return ImmutableSet.of();
                    }

                    @Override
                    public Iterable<PersonId> visit(ArithmeticOperationInput input) {
                        return ImmutableSet.of();
                    }
                }));
            }
        }
    }

    @Override
    protected ImmutableSetMultimap<String, String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        DBEntity entity = item.getEntity();
        ImmutableList<DynamicAttributeConfig> confAttributes = preloadedData.getEntityConfigService().getDynamicAttributesForType(entity.getType());
        ImmutableList<EntityDynamicAttributeClientModel> dynamicAttributes = entity.getDynamicAttributes();
        ImmutableMap clientAttributeMap = Maps.uniqueIndex(dynamicAttributes, IEntityDynamicAttribute.TO_ATTRIBUTE_ID);
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (DynamicAttributeConfig confAttr : confAttributes) {
            DynamicAttributeId id;
            EntityDynamicAttributeClientModel attribute;
            if (!confAttr.getSearchConfig().isSearchable() || (attribute = (EntityDynamicAttributeClientModel)clientAttributeMap.get((Object)(id = confAttr.getId()))) == null) continue;
            EntityDynamicAttributesSearchFieldVisitor searchFieldVisitor = new EntityDynamicAttributesSearchFieldVisitor(preloadedData, entity.getType(), attribute);
            ImmutableCollection<String> translatedValues = confAttr.getInput().accept(searchFieldVisitor);
            result.putAll((Object)EntityDynamicAttributesUtil.toSearchFieldName(id, entity.getType()), translatedValues);
            if (!confAttr.getSearchConfig().isFacettingEnabled()) continue;
            result.putAll((Object)EntityDynamicAttributesUtil.toFacetFieldName(id, entity.getType()), attribute.getValues());
        }
        return result.build();
    }

    @Override
    protected ImmutableSetMultimap<String, String> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return ImmutableSetMultimap.of();
    }

    @Override
    protected void set(JucoSolrInputDocument doc, ImmutableSetMultimap<String, String> value) {
        doc.addWildcardField((Map<String, ?>)value.asMap());
    }

    private static final class EntityDynamicAttributesSearchFieldVisitor
    implements Input.InputVisitor<ImmutableCollection<String>> {
        private final EntityType _entityType;
        private final EntityDynamicAttributeClientModel _attribute;
        private final SearchDataServiceImpl.SearchPreloadedData _preloadedData;

        private EntityDynamicAttributesSearchFieldVisitor(@Nonnull SearchDataServiceImpl.SearchPreloadedData preloadedData, @Nonnull EntityType entityType, @Nonnull EntityDynamicAttributeClientModel attribute) {
            this._preloadedData = preloadedData;
            this._entityType = entityType;
            this._attribute = attribute;
        }

        @Override
        public ImmutableSet<String> visit(SelectionInput input) {
            ImmutableSet.Builder valueSet = ImmutableSet.builder();
            for (String language : this._preloadedData.getAvailableLanguageCodes()) {
                Map<String, SelectOptionMessage> messages = this._preloadedData.i18nService().getSelectOptionMessagesForAttribute(this._entityType, this._attribute.getAttributeId(), (Iterable<String>)this._attribute.getValues(), language);
                for (Map.Entry<String, SelectOptionMessage> message : messages.entrySet()) {
                    valueSet.add((Object)message.getValue().name(message.getKey()));
                }
            }
            return valueSet.build();
        }

        @Override
        public ImmutableList<String> visit(TextInput input) {
            return this._attribute.getValues();
        }

        @Override
        public ImmutableList<String> visit(TextAreaInput input) {
            return this._attribute.getValues();
        }

        @Override
        public ImmutableList<String> visit(NumberInput numberInput) {
            return this._attribute.getValues();
        }

        @Override
        public ImmutableList<String> visit(ArithmeticOperationInput input) {
            return this._attribute.getValues();
        }

        @Override
        public ImmutableSet<String> visit(PersonSuggestInput suggestInput) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (String value : this._attribute.getValues()) {
                Optional person = (Optional)this._preloadedData._additionalPersons.get(PersonId.parse(value));
                if (!person.isPresent()) continue;
                result.add((Object)((DBPerson)person.get()).getFullName());
            }
            return result.build();
        }
    }
}

