/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.freiheit.toro.common.shared.server.util.StringUtil;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiEditor;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersion;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;

final class ContentLoader
extends AbstractItemBasedSolrDataLoader<ImmutableList<String>> {
    public static final ContentLoader INSTANCE = new ContentLoader();

    private ContentLoader() {
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._visibleWikiEditorsMappedEntities.addAll(ids.entities());
    }

    @Override
    protected ImmutableList<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        Optional editor = (Optional)preloadedData._visibleWikiEditors.get(item.getId());
        if (!editor.isPresent()) {
            return ImmutableList.of();
        }
        DBWikiVersion version = (DBWikiVersion)preloadedData._visibleWikiVersions.get((Object)((DBWikiEditor)editor.get()).getId());
        if (version == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)StringUtil.stripHTML(version.getText()));
    }

    @Override
    protected ImmutableList<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, WorkstreamItem item) {
        return ImmutableList.of((Object)((String)MoreObjects.firstNonNull((Object)item.getMessage().getAttribute("text"), (Object)"")));
    }

    @Override
    protected ImmutableList<String> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return ImmutableList.of();
    }

    @Override
    protected void set(JucoSolrInputDocument doc, ImmutableList<String> value) {
        doc.addField((SearchField)CommonSearchFields.CONTENT, (Iterable<?>)value);
    }
}

