/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.freiheit.toro.common.shared.server.util.StringUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.CommentVisitor;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.data.SolrDataLoader;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import java.util.Collection;

final class CommentsLoader
extends AbstractSolrDataLoader<ImmutableList<String>> {
    static final SolrDataLoader INSTANCE = new CommentsLoader();

    private CommentsLoader() {
    }

    @Override
    protected ImmutableList<String> getValue(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item, Item<?> rootParent) {
        Collection<DBComment> comments = item.accept(preloadedData._commentVisitor);
        ImmutableSet.Builder stringComments = ImmutableSet.builder();
        for (DBComment comment : comments) {
            stringComments.add((Object)StringUtil.stripHTML(comment.getText()));
        }
        return stringComments.build().asList();
    }

    @Override
    protected void set(JucoSolrInputDocument doc, ImmutableList<String> value) {
        doc.addField((SearchField)CommonSearchFields.COMMENTS, (Iterable<?>)value);
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        CommentVisitor.collectIds(idsCollector, ids);
    }
}

