/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class AuthorLoader
extends AbstractItemBasedSolrDataLoader<String> {
    public static final AuthorLoader INSTANCE = new AuthorLoader();

    private AuthorLoader() {
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._additionalPersons.addAll((Iterable)ids.workstreamMessageItems().transform(WorkstreamItem.TO_DB_WORKSTREAM_MESSAGE).transform(DBWorkstreamMessage.GET_AUTHOR_ID).filter(Predicates.notNull()));
    }

    @Nonnull
    private static String personIdToAuthor(@Nonnull SearchDataServiceImpl.SearchPreloadedData preloadedData, @Nullable PersonId personId) {
        Optional person = (Optional)preloadedData._additionalPersons.get(personId);
        if (person.isPresent()) {
            return ((DBPerson)person.get()).getFullName();
        }
        return "";
    }

    @Override
    protected String visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, WorkstreamItem item) {
        return AuthorLoader.personIdToAuthor(preloadedData, item.getMessage().getAuthorId().asPersonId());
    }

    @Override
    protected String visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return "";
    }

    @Override
    protected void set(JucoSolrInputDocument doc, String value) {
        doc.addField((SearchField)CommonSearchFields.AUTHOR, value);
    }
}

