/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import de.justsoftware.onx.chat.model.ChatItem;
import de.justsoftware.onx.container.shared.server.model.AbstractSearchableItemVisitor;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.NewsChannelItem;
import de.justsoftware.onx.container.shared.server.model.NewsPostItem;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.searchnew.business.data.AbstractSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.wiki.model.ArticleItem;
import de.justsoftware.onx.wiki.model.ChapterItem;
import de.justsoftware.onx.wiki.model.WikiItem;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import de.justsoftware.polls.model.pollid.item.PollItem;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
abstract class AbstractItemBasedSolrDataLoader<T>
extends AbstractSolrDataLoader<T> {
    AbstractItemBasedSolrDataLoader() {
    }

    @Override
    protected final T getValue(final SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item, Item<?> rootParent) {
        return item.accept(new AbstractSearchableItemVisitor<T>(){

            @Override
            public T visit(EntityItem entityItem) {
                return AbstractItemBasedSolrDataLoader.this.visit(preloadedData, entityItem);
            }

            @Override
            public T visit(ProfileItem profileItem) {
                return AbstractItemBasedSolrDataLoader.this.visit(preloadedData, profileItem);
            }

            @Override
            public T visit(WorkstreamItem workstreamItem) {
                return AbstractItemBasedSolrDataLoader.this.visit(preloadedData, workstreamItem);
            }

            @Override
            public T visit(DriveDocumentItem driveDocumentItem) {
                return AbstractItemBasedSolrDataLoader.this.visit(preloadedData, driveDocumentItem);
            }

            @Override
            public T visit(Conversation conversation) {
                return this.visitNotSearchableItem(conversation);
            }

            @Override
            public T visit(ChatItem chat) {
                return this.visitNotSearchableItem(chat);
            }

            @Override
            public T visit(WikiItem wikiItem) {
                return this.visitNotSearchableItem(wikiItem);
            }

            @Override
            public T visit(ChapterItem chapterItem) {
                return this.visitNotSearchableItem(chapterItem);
            }

            @Override
            public T visit(ArticleItem articleItem) {
                return this.visitNotSearchableItem(articleItem);
            }

            @Override
            public T visit(PollItem pollItem) {
                return this.visitNotSearchableItem(pollItem);
            }

            @Override
            public T visit(NewsPostItem newsPostItem) {
                return this.visitNotSearchableItem(newsPostItem);
            }

            @Override
            @Nonnull
            public T visit(NewsChannelItem newsChannelItem) {
                return this.visitNotSearchableItem(newsChannelItem);
            }

            @Override
            protected T visitNotSearchableItem(Item<?> nonSearchableItem) {
                return AbstractItemBasedSolrDataLoader.this.visitDefault(preloadedData, nonSearchableItem);
            }
        });
    }

    @Nonnull
    protected T visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        return this.visitDefault(preloadedData, item);
    }

    @Nonnull
    protected T visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, ProfileItem item) {
        return this.visitDefault(preloadedData, item);
    }

    @Nonnull
    protected T visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, WorkstreamItem item) {
        return this.visitDefault(preloadedData, item);
    }

    @Nonnull
    protected T visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, DriveDocumentItem driveDocumentItem) {
        return this.visitDefault(preloadedData, driveDocumentItem);
    }

    @Nonnull
    protected abstract T visitDefault(SearchDataServiceImpl.SearchPreloadedData var1, Item<?> var2);
}

