/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.criteria;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.justsoftware.onx.searchnew.business.criteria.Criterion;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;

public abstract class OperandExpression
implements Criterion {
    private final String _operand;
    private final Collection<Criterion> _criterionList = Lists.newArrayList();
    private final boolean _appendBrackets;

    protected OperandExpression(@Nonnull String operand, boolean appendBrackets) {
        if (operand == null) {
            throw new IllegalArgumentException("Operand must not be null");
        }
        this._operand = operand;
        this._appendBrackets = appendBrackets;
    }

    protected OperandExpression(@Nonnull String operand) {
        this(operand, true);
    }

    public void add(@Nonnull Criterion criterion) {
        this._criterionList.add((Criterion)Preconditions.checkNotNull((Object)criterion));
    }

    public void addAll(@Nonnull Collection<Criterion> cs) {
        this._criterionList.addAll((Collection<Criterion>)ImmutableList.copyOf(cs));
    }

    public boolean isEmpty() {
        return this._criterionList.isEmpty();
    }

    @Override
    public String toSolrQuery() {
        boolean appendBrackets;
        StringBuilder result = new StringBuilder();
        Iterator<Criterion> iterator = this._criterionList.iterator();
        boolean bl = appendBrackets = this._criterionList.size() > 1 && this._appendBrackets;
        if (appendBrackets) {
            result.append("(");
        }
        while (iterator.hasNext()) {
            result.append(iterator.next().toSolrQuery());
            if (!iterator.hasNext()) continue;
            if (this._operand != null && this._operand.trim().isEmpty()) {
                result.append(this._operand);
                continue;
            }
            result.append(" ").append(this._operand).append(" ");
        }
        if (appendBrackets) {
            result.append(")");
        }
        return result.toString();
    }

    public String toString() {
        return this.toSolrQuery();
    }
}

