/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.criteria;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.searchnew.business.criteria.SolrQueryElement;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocalParam
implements SolrQueryElement {
    private static final Joiner VALUES_JOINER = Joiner.on((char)',').skipNulls();
    private final String _key;
    private final ImmutableList<String> _values;

    public LocalParam(@Nullable String key, String ... values) {
        this(key, (ImmutableList<String>)ImmutableList.copyOf((Object[])values));
    }

    public LocalParam(@Nonnull String value) {
        this(null, (ImmutableList<String>)ImmutableList.of((Object)value));
    }

    public LocalParam(@Nullable String key, @Nonnull ImmutableList<String> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("At least one value is required");
        }
        this._key = key;
        this._values = values;
    }

    @CheckForNull
    public String getKey() {
        return this._key;
    }

    @Override
    public String toSolrQuery() {
        if (this._key == null) {
            return VALUES_JOINER.join(this._values);
        }
        return this._key + "=" + VALUES_JOINER.join(this._values);
    }
}

