/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ConversationSearchUtils {
    @Nonnull
    public static String getConversationName(Conversation conversation, Map<PersonId, DBPerson> allParticipants) {
        if (ConversationType.MULTI_USER_CHAT.equals(conversation.getType())) {
            return (String)MoreObjects.firstNonNull((Object)conversation.getCustomTitle(), (Object)"");
        }
        return ConversationSearchUtils.getParticipantNamesIterable(conversation, allParticipants).join(Joiner.on((String)", ").skipNulls());
    }

    @Nonnull
    public static FluentIterable<String> getParticipantNamesIterable(Conversation conversation, Map<PersonId, DBPerson> allParticipants) {
        ImmutableSet participants = FluentIterable.from(conversation.getParticipants()).transform(Functions.forMap(allParticipants, null)).filter(Predicates.notNull()).toSet();
        return FluentIterable.from((Iterable)FluentIterable.from((Iterable)participants).filter(DBPerson.NOT_DELETED).toSortedList((Comparator)DBPerson.BY_LASTNAME_ASC.nullsLast())).filter(Predicates.notNull()).transform(DBPerson.TO_FULL_NAME);
    }

    @Nonnull
    public static ImmutableList<String> getParticipantNames(Conversation conversation, Map<PersonId, DBPerson> allParticipants) {
        return ConversationSearchUtils.getParticipantNamesIterable(conversation, allParticipants).filter(Predicates.notNull()).toList();
    }
}

