/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.document.shared.model.DocumentId;
import de.justsoftware.onx.document.shared.model.db.DBDocument;
import de.justsoftware.onx.document.shared.model.db.DBDocumentVersion;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.searchnew.business.AdditionalSuggestData;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AdditionalData<T, ASD extends AdditionalSuggestData<T>> {
    private final ASD _additionalSuggestData;

    protected AdditionalData(@Nonnull ASD additionalSuggestData) {
        this._additionalSuggestData = additionalSuggestData;
    }

    @Nonnull
    public final Map<CompoundId, T> getDBBeans() {
        return ((AdditionalSuggestData)this.getAdditionalSuggestData()).getDBBeans();
    }

    @Nonnull
    public ASD getAdditionalSuggestData() {
        return this._additionalSuggestData;
    }

    public static class AdditionalWorkstreamData
    extends AdditionalData<DBWorkstreamMessage, AdditionalSuggestData.AdditionalWorkstreamSuggestData> {
        public static final AdditionalWorkstreamData EMPTY = new AdditionalWorkstreamData(AdditionalSuggestData.AdditionalWorkstreamSuggestData.EMPTY, (Map<EntityId, EntityInfo>)ImmutableMap.of(), (Map<PersonId, PersonTeaserModel>)ImmutableMap.of());
        private final Map<EntityId, EntityInfo> _parents;
        private final Map<PersonId, PersonTeaserModel> _profiles;

        public AdditionalWorkstreamData(@Nonnull AdditionalSuggestData.AdditionalWorkstreamSuggestData suggestData, @Nonnull Map<EntityId, EntityInfo> parentsMap, @Nonnull Map<PersonId, PersonTeaserModel> profileMap) {
            super(suggestData);
            this._parents = parentsMap;
            this._profiles = profileMap;
        }

        @Nonnull
        public Map<EntityId, EntityInfo> getParents() {
            return this._parents;
        }

        @Nonnull
        public Map<WorkstreamMessageId, WorkstreamMessage> getWorkstreamMessages() {
            return ((AdditionalSuggestData.AdditionalWorkstreamSuggestData)this.getAdditionalSuggestData()).getWorkstreamMessages();
        }

        @Nonnull
        public Map<PersonId, PersonTeaserModel> getProfiles() {
            return this._profiles;
        }
    }

    public static class PersonAdditionalData
    extends AdditionalData<DBPerson, AdditionalSuggestData.PersonAdditionalSuggestData> {
        public static final PersonAdditionalData EMPTY = new PersonAdditionalData(AdditionalSuggestData.PersonAdditionalSuggestData.EMPTY, (ImmutableSetMultimap<PersonId, PersonRole>)ImmutableSetMultimap.of(), (ImmutableListMultimap<PersonId, BadgeField>)ImmutableListMultimap.of(), (Map<PersonId, EntityMemberWithPerson>)ImmutableMap.of(), null);
        private final ImmutableSetMultimap<PersonId, PersonRole> _visibleRoles;
        private final ImmutableListMultimap<PersonId, BadgeField> _visibleProfileBadgeFields;
        private final Map<PersonId, EntityMemberWithPerson> _entityMembers;
        private final EntityInfo _entityInfo;

        public PersonAdditionalData(@Nonnull AdditionalSuggestData.PersonAdditionalSuggestData suggestData, @Nonnull ImmutableSetMultimap<PersonId, PersonRole> visibleRoles, @Nonnull ImmutableListMultimap<PersonId, BadgeField> visibleProfileBadgeFields, @Nonnull Map<PersonId, EntityMemberWithPerson> entityMembers, @Nullable EntityInfo entityInfo) {
            super(suggestData);
            this._visibleRoles = visibleRoles;
            this._visibleProfileBadgeFields = visibleProfileBadgeFields;
            this._entityMembers = entityMembers;
            this._entityInfo = entityInfo;
        }

        @Nonnull
        public ImmutableSetMultimap<PersonId, PersonRole> getVisibleRoles() {
            return this._visibleRoles;
        }

        @Nonnull
        public ImmutableListMultimap<PersonId, BadgeField> getVisibleProfileBadgeFields() {
            return this._visibleProfileBadgeFields;
        }

        @Nonnull
        public Map<PersonId, EntityMemberWithPerson> getEntityMembers() {
            return this._entityMembers;
        }

        @CheckForNull
        public EntityInfo getSearchContextEntity() {
            return this._entityInfo;
        }
    }

    public static class AdditionalEntityData
    extends AdditionalData<DBEntity, AdditionalSuggestData.AdditionalEntitySuggestData> {
        public static final AdditionalEntityData EMPTY = new AdditionalEntityData(AdditionalSuggestData.AdditionalEntitySuggestData.EMPTY, (ImmutableMap<EntityId, String>)ImmutableMap.of(), (ImmutableMap<EntityId, EntityInfo>)ImmutableMap.of(), (ImmutableSetMultimap<Optional<EntityId>, ? extends Action>)ImmutableSetMultimap.of(), (ImmutableMap<EntityId, EntityVersionClientModel>)ImmutableMap.of(), (ImmutableMap<EntityId, EntityVersionClientModel>)ImmutableMap.of(), (ImmutableMap<EntityId, Long>)ImmutableMap.of());
        private final ImmutableMap<EntityId, String> _teaserTexts;
        private final ImmutableMap<EntityId, EntityInfo> _parentInfos;
        private final ImmutableSetMultimap<Optional<EntityId>, ? extends Action> _may;
        private final ImmutableMap<EntityId, EntityVersionClientModel> _entityVersions;
        private final ImmutableMap<EntityId, EntityVersionClientModel> _publicVersions;
        private final ImmutableMap<EntityId, Long> _childrenCountMap;

        public AdditionalEntityData(@Nonnull AdditionalSuggestData.AdditionalEntitySuggestData suggestData, @Nonnull ImmutableMap<EntityId, String> teaserTexts, @Nonnull ImmutableMap<EntityId, EntityInfo> parentInfos, @Nonnull ImmutableSetMultimap<Optional<EntityId>, ? extends Action> may, @Nonnull ImmutableMap<EntityId, EntityVersionClientModel> entityVersions, @Nonnull ImmutableMap<EntityId, EntityVersionClientModel> publicVersions, @Nonnull ImmutableMap<EntityId, Long> childrenCountMap) {
            super(suggestData);
            this._teaserTexts = teaserTexts;
            this._parentInfos = parentInfos;
            this._may = may;
            this._entityVersions = entityVersions;
            this._publicVersions = publicVersions;
            this._childrenCountMap = childrenCountMap;
        }

        @Nonnull
        public ImmutableMap<EntityId, String> getTeaserTexts() {
            return this._teaserTexts;
        }

        @Nonnull
        public ImmutableMap<EntityId, EntityInfo> getParentInfos() {
            return this._parentInfos;
        }

        @Nonnull
        public ImmutableSetMultimap<Optional<EntityId>, ? extends Action> getMay() {
            return this._may;
        }

        @Nonnull
        public ImmutableMap<EntityId, EntityVersionClientModel> getVersions() {
            return this._entityVersions;
        }

        @Nonnull
        public ImmutableMap<EntityId, EntityVersionClientModel> getPublicVersions() {
            return this._publicVersions;
        }

        @Nonnull
        public ImmutableMap<EntityId, Long> getChildrenCountMap() {
            return this._childrenCountMap;
        }
    }

    public static class AdditionalDocumentData
    extends AdditionalData<DBDocument, AdditionalSuggestData.AdditionalDocumentSuggestData> {
        public static final AdditionalDocumentData EMPTY = new AdditionalDocumentData(AdditionalSuggestData.AdditionalDocumentSuggestData.EMPTY, (Map<EntityId, EntityInfo>)ImmutableMap.of(), (Map<PersonId, PersonTeaserModel>)ImmutableMap.of());
        private final Map<EntityId, EntityInfo> _parents;
        private final Map<PersonId, PersonTeaserModel> _profiles;

        public AdditionalDocumentData(@Nonnull AdditionalSuggestData.AdditionalDocumentSuggestData additionalDocumentSuggestData, @Nonnull Map<EntityId, EntityInfo> parentMap, @Nonnull Map<PersonId, PersonTeaserModel> profileMap) {
            super(additionalDocumentSuggestData);
            this._parents = parentMap;
            this._profiles = profileMap;
        }

        @Nonnull
        public Map<DocumentId, DBDocumentVersion> getDbVersions() {
            return ((AdditionalSuggestData.AdditionalDocumentSuggestData)this.getAdditionalSuggestData()).getDbVersions();
        }

        @Nonnull
        public Map<EntityId, EntityInfo> getParents() {
            return this._parents;
        }

        @Nonnull
        public Map<PersonId, PersonTeaserModel> getProfiles() {
            return this._profiles;
        }
    }
}

