/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.rest.business;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.mail.business.ChatMailService;
import de.justsoftware.onx.mail.business.model.ChatInfo;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/rest/internal/chat"})
public class ChatMailController {
    private final ChatMailService _chatMailService;
    private final PersonService _personService;

    @Autowired
    public ChatMailController(ChatMailService chatMailService, PersonService personService) {
        this._chatMailService = chatMailService;
        this._personService = personService;
    }

    @RequestMapping(value={"/mail"}, method={RequestMethod.POST})
    public void chatMail(@RequestBody Map<String, List<ChatInfo>> chatMailInfo) {
        Set<PersonId> receiverIds = chatMailInfo.keySet().stream().map(PersonId::parse).filter(Objects::nonNull).collect(Collectors.toSet());
        ImmutableMap<PersonId, DBPerson> receiverList = this._personService.getPersonsByIds(receiverIds);
        chatMailInfo.forEach((receiver, chatInfo) -> {
            PersonId receiverId = PersonId.parse(receiver);
            if (receiverId != null && receiverList.containsKey(receiverId)) {
                this._chatMailService.sendChatMail((List<ChatInfo>)chatInfo, (DBPerson)receiverList.get(receiverId));
            }
        });
    }
}

