/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.raweditor.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SetMultimap;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.raweditor.integration.persistence.RawEditorDAO;
import de.justsoftware.onx.raweditor.shared.model.RawEditorId;
import de.justsoftware.onx.raweditor.shared.model.RawEditorVersionId;
import de.justsoftware.onx.raweditor.shared.model.db.DBRawEditorVersion;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class IbatisRawEditorDAO
implements RawEditorDAO {
    private static final String NAMESPACE = "RawEditor.";
    private static final int OCC_TRIES = 3;
    private final SqlMapClient _sqlMapper;
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisRawEditorDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapper, StatementBuilderFactory statementBuilderFactory) {
        this._sqlMapper = sqlMapper;
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("RawEditor");
    }

    @Override
    public ImmutableTable<GlobalId, ComponentType, DBRawEditorVersion> getCurrentVersionsByParentIds(SetMultimap<? extends GlobalId, ? extends ComponentType> parentsAndComponentTypes) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getCurrentVersionByParentIds").partition(parentsAndComponentTypes.entries())).asTable("parentId", "editorType", null);
    }

    @Override
    public ImmutableMap<RawEditorId, DBRawEditorVersion> getCurrentVersionsByIds(Set<RawEditorId> ids) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "RawEditor.getCurrentVersionsByIds", "rawEditorId", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public RawEditorVersionId insertVersion(DBRawEditorVersion version) {
        for (int i = 1; i < 3; ++i) {
            try {
                return this.tryInsert(version);
            }
            catch (DAOException dAOException) {
                continue;
            }
        }
        return this.tryInsert(version);
    }

    @Nonnull
    private RawEditorVersionId tryInsert(DBRawEditorVersion version) {
        RawEditorId id = version.getRawEditorId();
        ImmutableMap<RawEditorId, DBRawEditorVersion> currentVersions = this.getCurrentVersionsByIds((Set<RawEditorId>)ImmutableSet.of((Object)id));
        DBRawEditorVersion current = InvalidIdServiceException.check((DBRawEditorVersion)currentVersions.get((Object)id));
        version.setVersion(current.getVersion() + 1);
        return (RawEditorVersionId)IbatisDAOUtil.wrappedInsert(this._sqlMapper, "RawEditor.insertVersion", version);
    }

    @Override
    public RawEditorId insertFirstVersion(DBRawEditorVersion version) {
        return (RawEditorId)IbatisDAOUtil.wrappedInsert(this._sqlMapper, "RawEditor.insertFirstVersion", version);
    }

    @Override
    public List<RawEditorId> getEditorIdsByParentId(GlobalId parentId) {
        return IbatisDAOUtil.wrappedQueryForList(this._sqlMapper, "RawEditor.getEditorIdsByParentId", parentId.asMap());
    }

    @Override
    public void deleteVersionsByEditorIds(Iterable<RawEditorId> editorIds) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, "RawEditor.deleteVersionsByEditorIds", ImmutableSet.copyOf(editorIds), IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableSet<ComponentType> getEditorTypesByEditorIds(Iterable<RawEditorId> editorIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableSet(this._sqlMapper, "RawEditor.getEditorTypesByEditorIds", ImmutableSet.copyOf(editorIds), IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }
}

