/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.raweditor.business.impl;

import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.raweditor.business.RawEditorModuleHandler;
import de.justsoftware.onx.raweditor.business.RawEditorService;
import de.justsoftware.onx.raweditor.shared.model.db.DBRawEditorVersion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RawEditorModuleHandlerImpl
implements RawEditorModuleHandler {
    @Autowired
    private RawEditorService _rawEditorService;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private PersonService _personService;
    @Autowired
    private EntityAdministrationWorkflowService _entityAdministrationService;

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, EntityItem entity, ComponentType componentType) throws InvalidIDException {
        return this._rawEditorService.getCurrentVersionByParentId(entity.getId(), componentType, authorizationContext);
    }

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, ProfileItem person, ComponentType componentType) throws InvalidIDException {
        return this._rawEditorService.getCurrentVersionByParentId(person.getId(), componentType, authorizationContext);
    }

    @Override
    public void create(ComponentType componentType, Iterable<DBEntity> entities, ServerEventCollector eventCollector) {
        for (DBEntity parentEntity : entities) {
            DBPerson person;
            DBRawEditorVersion version = new DBRawEditorVersion();
            PersonId authorId = new PersonId(-1L);
            version.setEditorType(componentType);
            version.setParentId(parentEntity.getId());
            version.setVersion(0);
            version.setText("");
            EntityMember admin = this._entityAdministrationService.getAdmin(parentEntity.getId());
            String language = "default";
            if (admin != null && (person = this._personService.getPersonById(admin.getPersonId())) != null) {
                language = person.getLanguageId();
                authorId = admin.getPersonId();
            }
            EntityConstants entityConstants = this._i18nService.getEntityConstantsByEntityType(parentEntity.getType(), language);
            switch ((StaticComponentType)componentType) {
                case RAW_EDITOR1: {
                    version.setText(entityConstants.defaultRawEditorText1());
                    break;
                }
                case RAW_EDITOR2: {
                    version.setText(entityConstants.defaultRawEditorText2());
                    break;
                }
                case RAW_EDITOR3: {
                    version.setText(entityConstants.defaultRawEditorText3());
                    break;
                }
                case RAW_EDITOR4: {
                    version.setText(entityConstants.defaultRawEditorText4());
                    break;
                }
                default: {
                    version.setText("");
                }
            }
            version.setAuthorId(authorId);
            this._rawEditorService.insertFirstVersion(version, eventCollector);
        }
    }

    @Override
    public void create(ProfileItem parentProfileItem, ComponentType componentType, ServerEventCollector eventCollector) {
        DBRawEditorVersion version = new DBRawEditorVersion();
        version.setEditorType(componentType);
        version.setParentId(parentProfileItem.getId());
        version.setVersion(0);
        version.setText("");
        version.setAuthorId(parentProfileItem.getId().asPersonId());
        this._rawEditorService.insertFirstVersion(version, eventCollector);
    }
}

