/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.raweditor.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.raweditor.business.RawEditorDeletionHandler;
import de.justsoftware.onx.raweditor.business.RawEditorService;
import de.justsoftware.onx.raweditor.shared.model.RawEditorId;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RawEditorDeletionHandlerImpl
implements RawEditorDeletionHandler {
    @Autowired
    private RawEditorService _rawEditorService;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        Iterable entityIds = Iterables.filter(parentIds, EntityId.class);
        for (EntityId entityId : entityIds) {
            ImmutableSet<RawEditorId> editorIds = deletionContext.filterItemsNotYetDeleted(this._rawEditorService.getRawEditorIdsByParentId(entityId));
            this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)editorIds, deletionContext);
            this._rawEditorService.deleteDependentRawEditors((Iterable<RawEditorId>)editorIds, entityId, deletionContext);
        }
    }
}

