/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.raweditor.business;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.raweditor.shared.model.RawEditorId;
import de.justsoftware.onx.raweditor.shared.model.RawEditorVersion;
import de.justsoftware.onx.raweditor.shared.model.RawEditorVersionId;
import de.justsoftware.onx.raweditor.shared.model.db.DBRawEditorVersion;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface RawEditorService {
    @CheckForNull
    public DBRawEditorVersion getCurrentDBVersionByParentId(GlobalId var1, ComponentType var2);

    @Nonnull
    public ImmutableTable<GlobalId, ComponentType, DBRawEditorVersion> getCurrentDBVersionsByParents(SetMultimap<? extends GlobalId, ? extends ComponentType> var1);

    @CheckForNull
    public RawEditorVersion getCurrentVersionByParentId(GlobalId var1, ComponentType var2, AuthorizationCheckContext var3);

    @Nonnull
    public ImmutableMap<RawEditorId, DBRawEditorVersion> getCurrentVersionsByIds(Set<RawEditorId> var1);

    @Nonnull
    public RawEditorVersionId insertVersion(DBRawEditorVersion var1);

    @Nonnull
    public RawEditorId insertFirstVersion(DBRawEditorVersion var1, ServerEventCollector var2);

    @Nonnull
    public ImmutableSet<RawEditorId> getRawEditorIdsByParentId(GlobalId var1);

    public void deleteDependentRawEditors(Iterable<RawEditorId> var1, GlobalId var2, DeletionContext var3);
}

