/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.shared.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.push.shared.model.PushAppName;
import de.justsoftware.onx.push.shared.model.PushNotificationProtocol;
import de.justsoftware.onx.push.shared.model.PushRegistrationId;
import de.justsoftware.pushnotification.client.model.PushNotificationApp;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PushTargetApp {
    private final PushRegistrationId _id;
    private final PushAppName _appName;
    private final String _token;
    private final PushNotificationProtocol _protocol;

    public PushTargetApp(PushAppName appName, String token, PushNotificationProtocol protocol) {
        this(null, appName, token, protocol);
    }

    public PushTargetApp(@Nullable PushRegistrationId id, PushAppName appName, String token, PushNotificationProtocol protocol) {
        this._id = id;
        this._appName = appName;
        this._token = token;
        this._protocol = protocol;
    }

    @CheckForNull
    public PushRegistrationId getId() {
        return this._id;
    }

    @Nonnull
    public PushAppName getAppName() {
        return this._appName;
    }

    @Nonnull
    public PushNotificationApp getPushNotificationApp() {
        switch (this._appName) {
            case CHAT: {
                return PushNotificationApp.CHAT;
            }
            case MOBILE_NG_WRAPPER: {
                return PushNotificationApp.MOBILE_NG_WRAPPER;
            }
            case MOBILE_NG_NATIVE_WRAPPER: {
                return PushNotificationApp.MOBILE_NG_NATIVE_WRAPPER;
            }
        }
        throw new IllegalStateException("Unexpected app name " + this._appName.name());
    }

    @Nonnull
    public String getToken() {
        return this._token;
    }

    @Nonnull
    public PushNotificationProtocol getProtocol() {
        return this._protocol;
    }

    @Nonnull
    public Receiver getReceiver() {
        return new Receiver(this._token, this._protocol);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("appName", (Object)this._appName).add("token", (Object)this._token).add("protocol", (Object)this._protocol).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushTargetApp that = (PushTargetApp)o;
        return this._appName == that._appName && Objects.equals(this._token, that._token) && this._protocol == that._protocol;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._appName, this._token, this._protocol});
    }

    @ParametersAreNonnullByDefault
    public static class Receiver {
        private final String _token;
        private final PushNotificationProtocol _protocol;

        public Receiver(String token, PushNotificationProtocol protocol) {
            this._token = token;
            this._protocol = protocol;
        }

        @Nonnull
        public String getToken() {
            return this._token;
        }

        @Nonnull
        public PushNotificationProtocol getProtocol() {
            return this._protocol;
        }
    }
}

