/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.push.business.PushNotificationReadWriteDataService;
import de.justsoftware.onx.push.business.PushNotificationService;
import de.justsoftware.onx.push.shared.model.PushRegistrationId;
import de.justsoftware.onx.push.shared.model.PushTargetApp;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class PushNotificationServiceImpl
implements PushNotificationService {
    private final PushNotificationReadWriteDataService _pushNotificationDataService;
    private final PersonService _personService;

    @Autowired
    public PushNotificationServiceImpl(PushNotificationReadWriteDataService pushNotificationDataService, PersonService personService) {
        this._pushNotificationDataService = pushNotificationDataService;
        this._personService = personService;
    }

    @Override
    public ImmutableSetMultimap<PersonId, PushTargetApp> getPushTargetAppsByPersonIds(Set<PersonId> personIds) {
        ImmutableSet activePersonIds = (ImmutableSet)this._personService.getPersonsByIds(personIds).values().stream().filter(p -> p != null && p.canLogin()).map(DBPerson::getId).collect(ImmutableSet.toImmutableSet());
        return ImmutableSetMultimap.copyOf(this._pushNotificationDataService.getPushTargetAppsByPersonIds((Set<PersonId>)activePersonIds));
    }

    @Override
    public PushRegistrationId addPushTargetApp(PushTargetApp app, AuthorizationCheckContextWithUserId authContext) {
        return this._pushNotificationDataService.insertPushTargetApp(app, authContext.getUserId());
    }

    @Override
    public boolean updatePushTargetApp(PushRegistrationId registrationId, PushTargetApp app, AuthorizationCheckContextWithUserId authContext) {
        return this._pushNotificationDataService.updatePushTargetApp(registrationId, app, authContext.getUserId());
    }

    @Override
    public boolean removePushTargetApp(PushRegistrationId registrationId, AuthorizationCheckContextWithUserId authContext) {
        return this._pushNotificationDataService.removePushTargetApp(registrationId, authContext.getUserId());
    }

    @Override
    public void removePushTargetAppsOfPersonIds(Set<PersonId> personIds) {
        this._pushNotificationDataService.removePushTargetAppsByPersonIds(personIds);
    }
}

