/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.business.impl;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.push.business.PushNotificationReadWriteDataService;
import de.justsoftware.onx.push.integration.persistence.PushNotificationDAO;
import de.justsoftware.onx.push.integration.persistence.ibatis.DBPushTargetApp;
import de.justsoftware.onx.push.shared.model.PushRegistrationId;
import de.justsoftware.onx.push.shared.model.PushTargetApp;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PushNotificationReadWriteDataServiceImpl
implements PushNotificationReadWriteDataService {
    private final PushNotificationDAO _dao;

    @Autowired
    public PushNotificationReadWriteDataServiceImpl(PushNotificationDAO dao) {
        this._dao = dao;
    }

    @Override
    @Nonnull
    public ImmutableMultimap<PersonId, PushTargetApp> getPushTargetAppsByPersonIds(Set<PersonId> personIds) {
        return ImmutableMultimap.copyOf((Multimap)Multimaps.transformValues(this._dao.getPushTargetAppsByPersonIds(personIds), DBPushTargetApp::toApp));
    }

    @Override
    @Nonnull
    public PushRegistrationId insertPushTargetApp(PushTargetApp app, PersonId personId) {
        return this._dao.insertPushTargetApp(app, personId);
    }

    @Override
    public boolean updatePushTargetApp(PushRegistrationId id, PushTargetApp app, PersonId personId) {
        return this._dao.updatePushTargetApp(id, app, personId);
    }

    @Override
    public boolean removePushTargetApp(PushRegistrationId id, PersonId personId) {
        return this._dao.removePushTargetApp(id, personId);
    }

    @Override
    public void removePushTargetAppsByPersonIds(Set<PersonId> personIds) {
        this._dao.removePushTargetAppsByPersonIds(personIds);
    }

    @Override
    public void removePushTargetAppsByReceivers(Iterable<PushTargetApp.Receiver> receivers) {
        this._dao.removePushTargetAppsByReceivers(receivers);
    }
}

