/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.business;

import com.google.common.collect.ImmutableListMultimap;
import de.justsoftware.mobilepush.model.PushNotification;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.message.business.ChatMessagePushFactory;
import de.justsoftware.onx.message.business.ChatUpdatePushFactory;
import de.justsoftware.onx.message.business.model.ChatMessagePushNotifications;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.notificationpush.business.NotificationPushFactory;
import de.justsoftware.onx.push.business.ApnsPushNotificationQueueService;
import de.justsoftware.onx.push.business.FcmPushNotificationQueueService;
import de.justsoftware.onx.push.model.PushNotifications;
import de.justsoftware.pushnotification.client.model.ApnsPushNotification;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PushNotificationSendService {
    private static final long IOS_PUSH_DELAY_MILLIS = 1500L;
    private final ApnsPushNotificationQueueService _apnsPushNotificationQueueService;
    private final FcmPushNotificationQueueService _fcmPushNotificationQueueService;
    private final NotificationPushFactory _notificationPushFactory;
    private final ChatUpdatePushFactory _chatUpdatePushFactory;
    private final ChatMessagePushFactory _chatMessagePushFactory;
    private final TaskScheduler _processDelayedApnsPushNotificationsScheduler;

    @Autowired
    public PushNotificationSendService(ApnsPushNotificationQueueService apnsPushNotificationQueueService, FcmPushNotificationQueueService fcmPushNotificationQueueService, NotificationPushFactory notificationPushFactory, ChatUpdatePushFactory chatUpdatePushFactory, ChatMessagePushFactory chatMessagePushFactory, @Qualifier(value="processDelayedApnsPushNotificationsScheduler") TaskScheduler processDelayedApnsPushNotificationsScheduler) {
        this._apnsPushNotificationQueueService = apnsPushNotificationQueueService;
        this._fcmPushNotificationQueueService = fcmPushNotificationQueueService;
        this._notificationPushFactory = notificationPushFactory;
        this._chatUpdatePushFactory = chatUpdatePushFactory;
        this._chatMessagePushFactory = chatMessagePushFactory;
        this._processDelayedApnsPushNotificationsScheduler = processDelayedApnsPushNotificationsScheduler;
    }

    public void sendNotificationsPushNotification(PushNotification pushNotification) {
        if (pushNotification.getReceivers().isEmpty()) {
            return;
        }
        PushNotifications pushNotifications = this._notificationPushFactory.createPushNotifications(pushNotification);
        this._apnsPushNotificationQueueService.add(pushNotifications.getApnsPushNotifications());
        this._fcmPushNotificationQueueService.add(pushNotifications.getFcmPushNotifications());
    }

    public void sendChatUpdate(ConversationId conversationId, Set<PersonId> recipients) {
        if (recipients.isEmpty()) {
            return;
        }
        PushNotifications pushNotifications = this._chatUpdatePushFactory.createPushNotifications(conversationId, recipients);
        this._apnsPushNotificationQueueService.add(pushNotifications.getApnsPushNotifications());
        this._fcmPushNotificationQueueService.add(pushNotifications.getFcmPushNotifications());
    }

    public void sendChatMessage(ChatMessage chatMessage) {
        ChatMessagePushNotifications pushNotifications = this._chatMessagePushFactory.createPushNotifications(chatMessage);
        this._apnsPushNotificationQueueService.add(pushNotifications.getImmediateApnsPushNotifications());
        this._fcmPushNotificationQueueService.add(pushNotifications.getFcmPushNotifications());
        this.scheduleDelayedApnsPushNotifications(pushNotifications.getDelayedApnsPushNotifications(), chatMessage);
    }

    private void scheduleDelayedApnsPushNotifications(ImmutableListMultimap<PersonId, ApnsPushNotification> delayedApnsPushNotifications, ChatMessage chatMessage) {
        if (delayedApnsPushNotifications.isEmpty()) {
            return;
        }
        this._processDelayedApnsPushNotificationsScheduler.schedule(() -> this.sendDelayedApnsPushMessages(delayedApnsPushNotifications, chatMessage), Instant.now().plusMillis(1500L));
    }

    private void sendDelayedApnsPushMessages(ImmutableListMultimap<PersonId, ApnsPushNotification> delayedApnsPushNotifications, ChatMessage chatMessage) {
        List<ApnsPushNotification> apnsPushNotifications = this._chatMessagePushFactory.silenceDelayedApnsPushNotificationsIfMessageRead(delayedApnsPushNotifications, chatMessage);
        this._apnsPushNotificationQueueService.sendPushNotifications(apnsPushNotifications);
    }
}

