/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.business;

import com.google.common.collect.Maps;
import de.justsoftware.onx.push.business.model.PushNotificationQueueEntry;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PushNotificationQueue<T> {
    private final Map<UUID, PushNotificationQueueEntry<T>> _storage = Maps.newConcurrentMap();

    public void add(PushNotificationQueueEntry<T> entry) {
        this._storage.put(entry.getId(), entry);
    }

    public void remove(Collection<PushNotificationQueueEntry<T>> entries) {
        entries.stream().map(PushNotificationQueueEntry::getId).forEach(this._storage::remove);
    }

    @Nonnull
    public Stream<PushNotificationQueueEntry<T>> stream() {
        return this._storage.values().stream();
    }

    public int size() {
        return this._storage.size();
    }
}

