/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.business;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.FileWatchService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.rest.JucoObjectMapper;
import de.justsoftware.onx.license.business.LicenseService;
import de.justsoftware.onx.push.business.exception.JunoDisabledException;
import de.justsoftware.onx.push.business.exception.JunoLoginFailedException;
import de.justsoftware.pushnotification.client.model.PushNotificationResults;
import de.justsoftware.pushnotification.client.model.error.ErrorCode;
import de.justsoftware.pushnotification.client.model.error.ErrorResponse;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.apache.http.NoHttpResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

@ParametersAreNonnullByDefault
public abstract class AbstractJunoRestClient
implements ServerEventHandler {
    private final Logger _log = LoggerFactory.getLogger(this.getClass());
    private final String _baseURL;
    private final RestOperations _restOperations;
    private final LicenseService _licenseService;
    private final JucoObjectMapper _objectMapper;
    private final String _loginPath;
    private final String _notificationPath;
    private OAuth2AccessToken _authToken = null;
    private boolean _disabled = false;

    public AbstractJunoRestClient(String baseURL, String loginPath, String notificationPath, RestOperations restOperations, LicenseService licenseService, JucoObjectMapper objectMapper) {
        this._baseURL = baseURL;
        this._loginPath = loginPath;
        this._notificationPath = notificationPath;
        this._restOperations = restOperations;
        this._licenseService = licenseService;
        this._objectMapper = objectMapper;
    }

    @Subscribe
    public void onLicenseChanged(FileWatchService.FileChangeEvent event) {
        if (FileWatchService.FileChangeEvent.LICENSE_FILE_CHANGED.equals(event)) {
            this.resetAuthToken();
        }
    }

    public synchronized boolean isDisabled() {
        return this._disabled;
    }

    @Nonnull
    public <T> PushNotificationResults send(List<T> pushNotifications) throws JunoDisabledException, RestClientException {
        if (this.isDisabled()) {
            this._log.debug("Login to juno server failed. We won't send push notifications. Request to send push notifications will be ignored.");
            throw new JunoDisabledException();
        }
        return this.junoAuthPostPushNotifications(pushNotifications, true);
    }

    @Nonnull
    private <T> PushNotificationResults junoAuthPostPushNotifications(List<T> pushNotifications, boolean retryIfAuthTokenExpired) throws RestClientException {
        try {
            HttpEntity httpEntity = new HttpEntity(pushNotifications, (MultiValueMap)this.getAuthHeaders());
            return this.postForObject(this._notificationPath, httpEntity, PushNotificationResults.class, true);
        }
        catch (JunoLoginFailedException e) {
            if (retryIfAuthTokenExpired && e.getErrorCode() == JunoLoginFailedException.ErrorCode.LICENSE_EXPIRED) {
                this._log.info("Auth Token expired. We will retry to login to juno server.");
                this.resetAuthToken();
                return this.junoAuthPostPushNotifications(pushNotifications, false);
            }
            throw new HttpClientErrorException(HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.UNAUTHORIZED && retryIfAuthTokenExpired) {
                this.resetAuthToken();
                return this.junoAuthPostPushNotifications(pushNotifications, false);
            }
            throw e;
        }
    }

    protected synchronized void resetAuthToken() {
        this._authToken = null;
        this._disabled = false;
    }

    @Nonnull
    @VisibleForTesting
    <T> T postForObject(String path, Object body, Class<T> responseType, boolean retryIfServerDidNotRespond) throws RestClientException {
        try {
            return (T)this._restOperations.postForObject(this._baseURL + path, body, responseType, new Object[0]);
        }
        catch (ResourceAccessException e) {
            if (retryIfServerDidNotRespond && this.serverDidNotRespond(e)) {
                this._log.info("Juno server did not respond to POST request. Will try again.");
                return this.postForObject(path, body, responseType, false);
            }
            throw e;
        }
    }

    private boolean serverDidNotRespond(ResourceAccessException e) {
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof NoHttpResponseException)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    HttpHeaders getAuthHeaders() throws JunoLoginFailedException {
        HttpHeaders authHeaders = new HttpHeaders();
        authHeaders.setContentType(MediaType.APPLICATION_JSON);
        OAuth2AccessToken authToken = this.getOrLoadAuthToken();
        authHeaders.add("Authorization", authToken.getTokenType() + " " + authToken.getValue());
        return authHeaders;
    }

    @Nonnull
    private synchronized OAuth2AccessToken getOrLoadAuthToken() throws JunoLoginFailedException {
        if (this._authToken != null) {
            return this._authToken;
        }
        try {
            OAuth2AccessToken authToken;
            this._authToken = authToken = this.loginToJuno();
            return authToken;
        }
        catch (JunoLoginFailedException e) {
            this._log.error("Failed to login to juno: " + e.getErrorCode(), (Throwable)e);
            if (e.getErrorCode() != JunoLoginFailedException.ErrorCode.UNEXPECTED_JUNO_EXCEPTION) {
                this._disabled = true;
            }
            throw e;
        }
    }

    @Nonnull
    private OAuth2AccessToken loginToJuno() throws JunoLoginFailedException {
        URL licenceFileURL = this._licenseService.getLicenceFileURL();
        if (licenceFileURL == null) {
            throw new JunoLoginFailedException(JunoLoginFailedException.ErrorCode.LICENSE_NOT_FOUND);
        }
        try {
            String license = FileUtils.readFileToString((File)de.justsoftware.onx.common.shared.server.util.FileUtils.urlToFile(licenceFileURL), (String)Charsets.UTF_8.toString());
            return this.postForObject(this._loginPath, license, OAuth2AccessToken.class, true);
        }
        catch (RestClientException e) {
            if (e instanceof HttpClientErrorException) {
                HttpClientErrorException httpClientErrorException = (HttpClientErrorException)((Object)e);
                throw new JunoLoginFailedException(this.loginErrorCode(httpClientErrorException), (Throwable)e);
            }
            throw new JunoLoginFailedException(JunoLoginFailedException.ErrorCode.UNEXPECTED_JUNO_EXCEPTION, (Throwable)e);
        }
        catch (IOException e) {
            this._log.error("Could not login to juno server. License file is not readable/available?", (Throwable)e);
            throw new JunoLoginFailedException(JunoLoginFailedException.ErrorCode.LICENSE_NOT_READABLE, (Throwable)e);
        }
    }

    @Nonnull
    private JunoLoginFailedException.ErrorCode loginErrorCode(HttpClientErrorException e) {
        ErrorCode errorCode;
        if (HttpStatus.UNAUTHORIZED != e.getStatusCode()) {
            return JunoLoginFailedException.ErrorCode.UNEXPECTED_JUNO_EXCEPTION;
        }
        ErrorResponse error = this.parseJson(e.getResponseBodyAsString(), ErrorResponse.class);
        ErrorCode errorCode2 = errorCode = error == null ? null : error.getCode();
        if (errorCode == ErrorCode.LICENSE_EXPIRED) {
            return JunoLoginFailedException.ErrorCode.LICENSE_EXPIRED;
        }
        if (errorCode == ErrorCode.LICENSE_INVALID) {
            return JunoLoginFailedException.ErrorCode.LICENSE_INVALID;
        }
        return JunoLoginFailedException.ErrorCode.UNEXPECTED_JUNO_EXCEPTION;
    }

    @CheckForNull
    private <T> T parseJson(String json, Class<T> returnType) {
        try {
            return (T)this._objectMapper.readValue(json, returnType);
        }
        catch (IOException e) {
            this._log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    synchronized OAuth2AccessToken getAuthToken() {
        return this._authToken;
    }
}

