/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.profile.model.ProfileAttributeBlock;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributePeriod;
import de.justsoftware.onx.profile.model.ProfileSectionType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.ObjectUtils;

@ParametersAreNonnullByDefault
public class ProfileSection {
    public static final Function<ProfileSection, String> TO_NAME = new NullPermeableFunction<ProfileSection, String>(){

        @Override
        protected String applySafe(ProfileSection input) {
            return input.getName();
        }
    };
    public static final Function<ProfileSection, Iterable<ProfileAttributeBlock>> ATTRIBUTE_BLOCKS = new NullPermeableFunction<ProfileSection, Iterable<ProfileAttributeBlock>>(){

        @Override
        protected Iterable<ProfileAttributeBlock> applySafe(ProfileSection input) {
            return input.getAttributeBlocks();
        }
    };
    private final String _name;
    private final ProfileSectionType _type;
    private final ImmutableList<ProfileAttributeBlock> _attributeBlocks;

    @JsonCreator
    public ProfileSection(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type", required=true) ProfileSectionType type, @JsonProperty(value="attributeBlocks", required=true) ImmutableList<ProfileAttributeBlock> attributeBlocks) {
        this._name = name;
        this._type = type;
        this._attributeBlocks = attributeBlocks;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public ProfileSectionType getType() {
        return this._type;
    }

    @Nonnull
    public ImmutableList<ProfileAttributeBlock> getAttributeBlocks() {
        return this._attributeBlocks;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this._name).add("type", (Object)this._type).add("attributeBlocks", this._attributeBlocks.size()).toString();
    }

    @Nonnull
    public static Builder builder(String name, ProfileSectionType type) {
        return new Builder(name, type);
    }

    @ParametersAreNonnullByDefault
    public static final class Builder {
        private final SortedMap<Integer, ProfileAttributeBlock.Builder> _blockBuilders = new TreeMap<Integer, ProfileAttributeBlock.Builder>();
        private final String _name;
        private final ProfileSectionType _type;

        private Builder(String name, ProfileSectionType type) {
            this._name = name;
            this._type = type;
        }

        @Nonnull
        public Builder addAttributeValues(Integer blockIndex, ProfileAttributeConfiguration attribute, ImmutableList<String> values) {
            if (values.isEmpty()) {
                return this;
            }
            ProfileAttributeBlock.Builder blockBuilder = (ProfileAttributeBlock.Builder)this._blockBuilders.get(blockIndex);
            if (blockBuilder == null) {
                blockBuilder = ProfileAttributeBlock.builder(blockIndex);
                this._blockBuilders.put(blockIndex, blockBuilder);
            }
            blockBuilder.addAttributeValues(attribute, values);
            return this;
        }

        @Nonnull
        public ProfileSection build() {
            ImmutableList.Builder blocks = ImmutableList.builder();
            for (ProfileAttributeBlock.Builder blockBuilder : this._blockBuilders.values()) {
                blocks.add((Object)blockBuilder.build());
            }
            ImmutableList sortedBlock = blocks.build();
            if (this._type == ProfileSectionType.CHRONOLOGY) {
                sortedBlock = FluentIterable.from((Iterable)sortedBlock).toSortedList((Comparator)new Comparator<ProfileAttributeBlock>(){

                    @Override
                    public int compare(ProfileAttributeBlock b1, ProfileAttributeBlock b2) {
                        ProfileAttributePeriod period1 = b1.getFirstPeriod();
                        ProfileAttributePeriod period2 = b2.getFirstPeriod();
                        int periodCompareResult = ObjectUtils.compare((Comparable)period2, (Comparable)period1);
                        if (periodCompareResult == 0 || period1 == null && period2 == null) {
                            return ObjectUtils.compare((Comparable)b1.getOrderIndex(), (Comparable)b2.getOrderIndex());
                        }
                        return periodCompareResult;
                    }
                });
            }
            return new ProfileSection(this._name, this._type, (ImmutableList<ProfileAttributeBlock>)sortedBlock);
        }
    }
}

