/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.model;

import com.freiheit.toro.account.shared.model.settings.BirthdayVisibility;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.util.Dates;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfilePersonalData {
    private final Date _birthday;
    private final BirthdayVisibility _birthdayVisibility;
    private final TimeZone _timezone;

    public ProfilePersonalData(@Nullable Date birthday, @Nullable BirthdayVisibility birthdayVisibility, @Nullable TimeZone timezone) {
        this._birthday = Dates.clone(birthday);
        this._birthdayVisibility = birthdayVisibility;
        this._timezone = timezone;
    }

    @CheckForNull
    public Date getBirthday() {
        return Dates.clone(this._birthday);
    }

    @CheckForNull
    public BirthdayVisibility getBirthdayVisibility() {
        return this._birthdayVisibility;
    }

    @CheckForNull
    public TimeZone getTimezone() {
        return this._timezone;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("birthday", (Object)this._birthday).add("birthdayVisibility", (Object)this._birthdayVisibility).add("timezone", (Object)this._timezone).toString();
    }
}

